/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGroup {
    private List<byte[]> dataObjects;
    private byte[] groupHash;
    private TreeSet<byte[]> hashes;

    public DataGroup(List<byte[]> dataObjects) {
        this.dataObjects = dataObjects;
    }

    public DataGroup(byte[] dataObject) {
        this.dataObjects = new ArrayList<byte[]>();
        this.dataObjects.add(dataObject);
    }

    public TreeSet<byte[]> getHashes(DigestCalculator digestCalculator) {
        return this.getHashes(digestCalculator, null);
    }

    private TreeSet<byte[]> getHashes(DigestCalculator digestCalculator, byte[] ha) {
        if (this.hashes == null) {
            this.hashes = new TreeSet(new ByteArrayComparator());
            for (int i = 0; i != this.dataObjects.size(); ++i) {
                byte[] dataObject = this.dataObjects.get(i);
                if (ha != null) {
                    this.hashes.add(DataGroup.calcDigest(digestCalculator, Arrays.concatenate(DataGroup.calcDigest(digestCalculator, dataObject), ha)));
                    continue;
                }
                this.hashes.add(DataGroup.calcDigest(digestCalculator, dataObject));
            }
        }
        return this.hashes;
    }

    public byte[] getHash(DigestCalculator digestCalculator) {
        if (this.groupHash == null) {
            TreeSet<byte[]> hashes = this.getHashes(digestCalculator);
            if (hashes.size() > 1) {
                byte[] concat = new byte[]{};
                Iterator<byte[]> iterator = hashes.iterator();
                while (iterator.hasNext()) {
                    concat = Arrays.concatenate(concat, iterator.next());
                }
                this.groupHash = DataGroup.calcDigest(digestCalculator, concat);
            } else {
                this.groupHash = hashes.first();
            }
        }
        return this.groupHash;
    }

    static byte[] calcDigest(DigestCalculator digCalc, byte[] data) {
        try {
            OutputStream dOut = digCalc.getOutputStream();
            dOut.write(data);
            dOut.close();
            return digCalc.getDigest();
        }
        catch (IOException e) {
            throw new IllegalStateException("digest calculator failure: " + e.getMessage());
        }
    }

    private class ByteArrayComparator
    implements Comparator {
        private ByteArrayComparator() {
        }

        public int compare(Object l, Object r) {
            byte[] left = (byte[])l;
            byte[] right = (byte[])r;
            int len = left.length < right.length ? left.length : right.length;
            for (int i = 0; i != len; ++i) {
                int a = left[i] & 0xFF;
                int b = right[i] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return left.length - right.length;
        }
    }
}

