/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.lang.management.OperatingSystemMXBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CpuInfo {
    private static final TraceComponent tc = Tr.register(CpuInfo.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    private static final CpuInfo INSTANCE = new CpuInfo();
    private final int AVAILABLE_PROCESSORS;
    private CpuInfoAccessor osmx;
    private final int cpuNSFactor;
    private long lastProcessCPUTime = 0L;
    private double lastProcessCpuUsage = -1.0;
    private long lastSystemTimeMillis = -1L;
    static final long serialVersionUID = 6663029528885505628L;

    private CpuInfo() {
        int runtimeAvailableProcessors = Runtime.getRuntime().availableProcessors();
        int fileSystemAvailableProcessors = CpuInfo.getAvailableProcessorsFromFilesystem();
        this.AVAILABLE_PROCESSORS = fileSystemAvailableProcessors <= 0 || fileSystemAvailableProcessors > runtimeAvailableProcessors ? runtimeAvailableProcessors : fileSystemAvailableProcessors;
        int nsFactor = 1;
        if (JavaInfo.vendor() == JavaInfo.Vendor.IBM) {
            int majorVersion = JavaInfo.majorVersion();
            int minorVersion = JavaInfo.minorVersion();
            int serviceRelease = JavaInfo.serviceRelease();
            if (majorVersion == 8 && minorVersion == 0 && serviceRelease < 5) {
                nsFactor = 100;
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"IBM Java level check", (Object[])new Object[]{"majorVersion: " + majorVersion + ", minorVersion: " + minorVersion + ", serviceRelease: " + serviceRelease + ", cpuNSFactor: " + nsFactor});
            }
        }
        this.cpuNSFactor = nsFactor;
    }

    /*
     * WARNING - void declaration
     */
    private double getSystemCPU() {
        double cpuUsage = -1.0;
        try {
            if (this.osmx == null) {
                this.osmx = CpuInfo.createCpuInfoAccessor();
            }
            cpuUsage = this.osmx.getSystemCpuLoad();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.util.CpuInfo", (String)"90", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getSystemCPU");
        }
        if (cpuUsage >= 0.0 && (cpuUsage *= 100.0) > 100.0) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"getSystemCPU error", (Object[])new Object[]{"system CPU out-of-range: " + cpuUsage});
            }
            cpuUsage = -1.0;
        }
        return cpuUsage;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized double getProcessCPU() {
        long currentTimeMs = System.currentTimeMillis();
        if (currentTimeMs - this.lastSystemTimeMillis < 500L) {
            return this.lastProcessCpuUsage;
        }
        double cpuUsage = -1.0;
        long processCpuTime = -1L;
        try {
            if (this.osmx == null) {
                this.osmx = CpuInfo.createCpuInfoAccessor();
            }
            processCpuTime = this.osmx.getProcessCpuTime();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.util.CpuInfo", (String)"122", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getProcessCPU");
        }
        if (processCpuTime != -1L) {
            long d1 = (currentTimeMs - this.lastSystemTimeMillis) * 1000000L;
            long d2 = processCpuTime - this.lastProcessCPUTime;
            cpuUsage = (double)d2 / (double)d1;
            cpuUsage = cpuUsage / (double)this.AVAILABLE_PROCESSORS * (double)this.cpuNSFactor * 100.0;
            this.lastSystemTimeMillis = currentTimeMs;
            this.lastProcessCPUTime = processCpuTime;
        }
        if (cpuUsage > 100.0) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"getProcessCPU error", (Object[])new Object[]{"process CPU out-of-range: " + cpuUsage});
            }
            cpuUsage = -1.0;
        }
        this.lastProcessCpuUsage = cpuUsage;
        return cpuUsage;
    }

    /*
     * WARNING - void declaration
     */
    private static int getAvailableProcessorsFromFilesystem() {
        int availableProcessorsInt;
        Double availableProcessorsDouble;
        block11: {
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            availableProcessorsDouble = null;
            availableProcessorsInt = -1;
            String periodFileLocation = File.separator + "sys" + File.separator + "fs" + File.separator + "cgroup" + File.separator + "cpu" + File.separator + "cpu.cfs_period_us";
            String quotaFileLocation = File.separator + "sys" + File.separator + "fs" + File.separator + "cgroup" + File.separator + "cpu" + File.separator + "cpu.cfs_quota_us";
            File cfsPeriod = new File(periodFileLocation);
            File cfsQuota = new File(quotaFileLocation);
            if (cfsPeriod.exists() && cfsQuota.exists()) {
                try {
                    String quotaContents = CpuInfo.readFile(cfsQuota);
                    double quotaFloat = new Double(quotaContents);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("quotaFloat = " + quotaFloat), (Object[])new Object[0]);
                    }
                    if (!(quotaFloat >= 0.0)) break block11;
                    String periodContents = CpuInfo.readFile(cfsPeriod);
                    double periodFloat = new Double(periodContents);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("periodFloat = " + periodFloat), (Object[])new Object[0]);
                    }
                    if (periodFloat != 0.0) {
                        availableProcessorsDouble = quotaFloat / periodFloat;
                        availableProcessorsDouble = CpuInfo.roundToTwoDecimalPlaces(availableProcessorsDouble);
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Calculated availableProcessors: " + availableProcessorsDouble + ". period=" + periodFloat + ", quota=" + quotaFloat), (Object[])new Object[0]);
                        }
                    }
                }
                catch (Throwable quotaContents) {
                    FFDCFilter.processException((Throwable)quotaContents, (String)"com.ibm.ws.kernel.service.util.CpuInfo", (String)"179", null, (Object[])new Object[0]);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)("Caught exception: " + e.getMessage() + ". Using number of processors reported by java"), (Object[])new Object[0]);
                    }
                    availableProcessorsDouble = null;
                }
            } else if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Files " + quotaFileLocation + " : " + cfsQuota.exists()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Files " + periodFileLocation + " : " + cfsPeriod.exists()), (Object[])new Object[0]);
            }
        }
        int n = availableProcessorsInt = availableProcessorsDouble == null ? -1 : availableProcessorsDouble.intValue();
        if (availableProcessorsDouble != null && availableProcessorsDouble > (double)availableProcessorsInt) {
            ++availableProcessorsInt;
        }
        return availableProcessorsInt;
    }

    private static String readFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
        String line = buf.readLine();
        StringBuilder sb = new StringBuilder();
        while (line != null) {
            sb.append(line).append("\n");
            line = buf.readLine();
        }
        buf.close();
        ((InputStream)is).close();
        return sb.toString();
    }

    private static Double roundToTwoDecimalPlaces(Double d) {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.setScale(2, RoundingMode.DOWN);
        return bd.doubleValue();
    }

    public static int getAvailableProcessors() {
        return CpuInfo.INSTANCE.AVAILABLE_PROCESSORS;
    }

    public static double getJavaCpuUsage() {
        return INSTANCE.getProcessCPU();
    }

    public static double getSystemCpuUsage() {
        return INSTANCE.getSystemCPU();
    }

    public static CpuInfoAccessor createCpuInfoAccessor() {
        java.lang.management.OperatingSystemMXBean mbean = ManagementFactory.getOperatingSystemMXBean();
        if (mbean == null) {
            return new NullCpuInfoAccessor();
        }
        try {
            if (JavaInfo.isSystemClassAvailable("com.ibm.lang.management.OperatingSystemMXBean")) {
                return new IBMJavaCpuInfoAccessor(mbean);
            }
            return new ModernJavaCpuInfoAccessor(mbean);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.kernel.service.util.CpuInfo", (String)"260", null, (Object[])new Object[0]);
            return new StandardAPICpuInfoAccessor(mbean);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class StandardAPICpuInfoAccessor
    implements CpuInfoAccessor {
        private final ObjectName objectName;
        private final MBeanServer mBeanServer;
        static final long serialVersionUID = 1064874384498110215L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StandardAPICpuInfoAccessor(java.lang.management.OperatingSystemMXBean jvmMbean) {
            this.objectName = jvmMbean.getObjectName();
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }

        @Override
        public long getProcessCpuTime() {
            try {
                return (Long)this.mBeanServer.getAttribute(this.objectName, "ProcessCpuTime");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.util.CpuInfo$StandardAPICpuInfoAccessor", (String)"333", (Object)this, (Object[])new Object[0]);
                return -1L;
            }
        }

        @Override
        public double getSystemCpuLoad() {
            try {
                return (Double)this.mBeanServer.getAttribute(this.objectName, "SystemCpuLoad");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.util.CpuInfo$StandardAPICpuInfoAccessor", (String)"342", (Object)this, (Object[])new Object[0]);
                return -1.0;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.CpuInfo$StandardAPICpuInfoAccessor", StandardAPICpuInfoAccessor.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ModernJavaCpuInfoAccessor
    implements CpuInfoAccessor {
        private final com.sun.management.OperatingSystemMXBean mbean;
        static final long serialVersionUID = 6891878823332654349L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ModernJavaCpuInfoAccessor(java.lang.management.OperatingSystemMXBean jvmMbean) {
            this.mbean = (com.sun.management.OperatingSystemMXBean)jvmMbean;
        }

        @Override
        public long getProcessCpuTime() {
            return this.mbean.getProcessCpuTime();
        }

        @Override
        public double getSystemCpuLoad() {
            return this.mbean.getSystemCpuLoad();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.CpuInfo$ModernJavaCpuInfoAccessor", ModernJavaCpuInfoAccessor.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class IBMJavaCpuInfoAccessor
    implements CpuInfoAccessor {
        private final OperatingSystemMXBean mbean;
        static final long serialVersionUID = 3828959572572075942L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public IBMJavaCpuInfoAccessor(java.lang.management.OperatingSystemMXBean jvmMbean) {
            this.mbean = (OperatingSystemMXBean)jvmMbean;
        }

        @Override
        public long getProcessCpuTime() {
            return this.mbean.getProcessCpuTime();
        }

        @Override
        public double getSystemCpuLoad() {
            return this.mbean.getSystemCpuLoad();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.CpuInfo$IBMJavaCpuInfoAccessor", IBMJavaCpuInfoAccessor.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class NullCpuInfoAccessor
    implements CpuInfoAccessor {
        static final long serialVersionUID = -7098881151618064483L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NullCpuInfoAccessor() {
        }

        @Override
        public long getProcessCpuTime() {
            return -1L;
        }

        @Override
        public double getSystemCpuLoad() {
            return -1.0;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.CpuInfo$NullCpuInfoAccessor", NullCpuInfoAccessor.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    private static interface CpuInfoAccessor {
        public long getProcessCpuTime();

        public double getSystemCpuLoad();
    }
}

