/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.equinox.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.equinox.module.internal.ModuleEntry;
import com.ibm.ws.artifact.equinox.module.internal.RootModuleEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModuleBundleFile
extends BundleFileWrapper {
    private static final TraceComponent tc = Tr.register(ModuleBundleFile.class, (String)"equinox.module", null);
    private final Container container;
    private final BundleFile wrappedBundleFile;
    private final Map<File, Container> nestedFiles;
    private final BundleContext context;
    static final long serialVersionUID = -852165117165725301L;

    public ModuleBundleFile(Container container, BundleFile wrappedBundleFile, Map<File, Container> nestedFiles, BundleContext context) {
        super(wrappedBundleFile);
        this.container = container;
        this.wrappedBundleFile = wrappedBundleFile;
        this.nestedFiles = nestedFiles;
        this.context = context;
    }

    public void close() throws IOException {
    }

    public void open() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    public File getFile(String path, boolean nativeCode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" asked to getFile for path " + path), (Object[])new Object[0]);
        }
        if ((path = this.preSlashify(path)).equals("/")) {
            if (this.container.getPhysicalPath() != null) {
                return new File(this.container.getPhysicalPath());
            }
            return null;
        }
        final Entry entry = this.container.getEntry(path);
        if (entry == null) {
            return null;
        }
        Container entryContainer = ModuleBundleFile.getContainer(entry);
        if (entryContainer == null) {
            String physical;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" returning file for entry at " + path + " @ " + entry.getPhysicalPath()), (Object[])new Object[0]);
            }
            if ((physical = entry.getPhysicalPath()) != null) {
                return AccessController.doPrivileged(new PrivilegedAction<File>(){
                    static final long serialVersionUID = -8143402730827378101L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public File run() {
                        return new File(physical);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.equinox.module.internal.ModuleBundleFile$1", 1.class, (String)"equinox.module", null);
                    }
                });
            }
            return null;
        }
        if (nativeCode) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" entry was a container.. but was it root? " + entryContainer.isRoot()), (Object[])new Object[0]);
        }
        if (!entryContainer.isRoot()) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)" leaf node was a root container, so use marker file for equinox", (Object[])new Object[0]);
        }
        final File tempBase = this.context.getDataFile("nestedTempFiles");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" creating a temp dir, request was for " + path + " the nested path"), (Object[])new Object[0]);
        }
        if (!AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -7674661180515724398L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return tempBase.exists() || tempBase.mkdirs();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.equinox.module.internal.ModuleBundleFile$2", 2.class, (String)"equinox.module", null);
            }
        }).booleanValue()) {
            throw new IllegalStateException();
        }
        try {
            File t = null;
            try {
                t = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){
                    static final long serialVersionUID = -2562657889246177843L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public File run() throws IOException {
                        return File.createTempFile(entry.getName(), null, tempBase);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.equinox.module.internal.ModuleBundleFile$3", 3.class, (String)"equinox.module", null);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.artifact.equinox.module.internal.ModuleBundleFile", (String)"181", (Object)((Object)this), (Object[])new Object[]{path, nativeCode});
                Exception e2 = e.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                if (e2 instanceof RuntimeException) {
                    throw (RuntimeException)e2;
                }
                throw new UndeclaredThrowableException((Throwable)e);
            }
            final File tempKey = t;
            this.nestedFiles.put(tempKey, entryContainer);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = -4297489974378970962L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    tempKey.deleteOnExit();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.equinox.module.internal.ModuleBundleFile$4", 4.class, (String)"equinox.module", null);
                }
            });
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" returning a tempkey file.. " + tempKey.getAbsolutePath()), (Object[])new Object[0]);
            }
            return tempKey;
        }
        catch (IOException t) {
            void e;
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.artifact.equinox.module.internal.ModuleBundleFile", (String)"205", (Object)((Object)this), (Object[])new Object[]{path, nativeCode});
            throw new IllegalStateException((Throwable)e);
        }
    }

    public BundleEntry getEntry(String path) {
        if ((path = this.preSlashify(path)).equals("/")) {
            return new RootModuleEntry(this.container);
        }
        Entry entry = this.container.getEntry(path);
        return entry == null ? null : new ModuleEntry(entry, this.postSlashify(path, entry));
    }

    private String preSlashify(String path) {
        path = path.isEmpty() || path.charAt(0) != '/' ? '/' + path : path;
        path = path.length() > 1 && path.charAt(path.length() - 1) == '/' ? path.substring(0, path.length() - 1) : path;
        return path;
    }

    private String postSlashify(String path, Entry entry) {
        Container c = null;
        if (entry == null || (c = ModuleBundleFile.getContainer(entry)) != null && !c.isRoot()) {
            path = path + '/';
        }
        return path.length() > 1 && path.charAt(0) == '/' ? path.substring(1) : path;
    }

    /*
     * WARNING - void declaration
     */
    static Container getContainer(Entry entry) {
        try {
            return (Container)entry.adapt(Container.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.artifact.equinox.module.internal.ModuleBundleFile", (String)"253", null, (Object[])new Object[]{entry});
            e.hashCode();
            return null;
        }
    }

    public Enumeration<String> getEntryPaths(String path, boolean recurse) {
        Iterator entries;
        if ((path = this.preSlashify(path)).equals("/")) {
            entries = this.container.iterator();
        } else {
            Entry entry = this.container.getEntry(path);
            Container entryContainer = entry == null ? null : ModuleBundleFile.getContainer(entry);
            entries = entryContainer == null || entryContainer.isRoot() ? null : entryContainer.iterator();
            path = this.postSlashify(path, null);
        }
        return entries == null ? null : new ContainerEnumeration(path, entries, recurse);
    }

    public Enumeration<String> getEntryPaths(String path) {
        return this.getEntryPaths(path, false);
    }

    public boolean containsDir(String dir) {
        return this.getEntryPaths(dir) != null;
    }

    public File getBaseFile() {
        return this.wrappedBundleFile.getBaseFile();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class ContainerEnumeration
    implements Enumeration<String> {
        private final Stack<String> path = new Stack();
        private final Stack<Iterator<Entry>> iEntries;
        private final boolean recurse;
        static final long serialVersionUID = 4102905935560911443L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ContainerEnumeration(String path, Iterator<Entry> iEntries, boolean recurse) {
            this.path.push(path);
            this.iEntries = new Stack();
            this.iEntries.push(iEntries);
            this.recurse = recurse;
        }

        @Override
        public boolean hasMoreElements() {
            for (int idx = 0; idx < this.iEntries.size(); ++idx) {
                if (!((Iterator)this.iEntries.get(idx)).hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public String nextElement() {
            while (!this.iEntries.peek().hasNext()) {
                this.iEntries.pop();
                this.path.pop();
            }
            if (this.iEntries.isEmpty()) {
                throw new IllegalStateException();
            }
            Entry next = this.iEntries.peek().next();
            Container nextContainer = ModuleBundleFile.getContainer(next);
            String result = this.path.peek() + next.getName();
            if (nextContainer != null) {
                result = result + "/";
            }
            if (this.recurse && nextContainer != null && !nextContainer.isRoot()) {
                this.iEntries.push(nextContainer.iterator());
                this.path.push(this.path.peek() + next.getName() + "/");
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.equinox.module.internal.ModuleBundleFile$ContainerEnumeration", ContainerEnumeration.class, (String)"equinox.module", null);
        }
    }
}

