/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.clientcontainer.remote.server;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.clientcontainer.remote.common.ClientEJBFactory;
import com.ibm.ws.clientcontainer.remote.common.ClientSupport;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.ws.container.service.naming.RemoteJavaColonNamingHelper;
import com.ibm.ws.container.service.naming.RemoteObjectInstance;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.transport.iiop.spi.ORBRef;
import com.ibm.ws.transport.iiop.spi.ServerPolicySource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.rmi.CORBA.Tie;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class ClientSupportImpl
implements ClientSupport {
    private static final TraceComponent tc = Tr.register(ClientSupportImpl.class, (String)"clientContainer", null);
    private static final String CLIENT_SUPPORT_POA_NAME = "ClientSupportPOA";
    private static final String REFERENCE_REMOTE_JAVA_COLON_NAMING_HELPERS = "remoteJavaColonNamingHelpers";
    private static final String REFERENCE_EJB_CLIENT_FACTORY = "clientEJBFactory";
    private static final ComponentMetaData DUMMY_CMD = new ComponentMetaData(){
        static final long serialVersionUID = 5967849796793712557L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public String getName() {
            return "ClientSupportImpl#DUMMY_CMD";
        }

        public void setMetaData(MetaDataSlot slot, java.lang.Object metadata) {
        }

        public java.lang.Object getMetaData(MetaDataSlot slot) {
            return null;
        }

        public void release() {
        }

        public ModuleMetaData getModuleMetaData() {
            return null;
        }

        public J2EEName getJ2EEName() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.clientcontainer.remote.server.ClientSupportImpl$1", 1.class, (String)"clientContainer", null);
        }
    };
    @Reference(target="(id=defaultOrb)")
    private ORBRef orbRef;
    private ORB orb;
    private Object thisRef;
    @Reference
    private MetaDataIdentifierService metadataIdService;
    @Reference
    private SerializationService serializationService;
    private final AtomicServiceReference<ClientEJBFactory> ejbFactoryRef = new AtomicServiceReference("clientEJBFactory");
    @Reference
    private ServerPolicySource serverPolicySource;
    private final ConcurrentServiceReferenceSet<RemoteJavaColonNamingHelper> remoteJavaColonNamingHelpers = new ConcurrentServiceReferenceSet("remoteJavaColonNamingHelpers");
    static final long serialVersionUID = -9015243308412764987L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteObjectInstance getRemoteObjectInstance(String appName, String moduleName, String compName, String namespaceString, String jndiName) throws NamingException, RemoteException {
        NamingConstants.JavaColonNamespace namespace = NamingConstants.JavaColonNamespace.fromName((String)namespaceString);
        ComponentMetaData cmd = this.getCMD(appName, moduleName, compName, namespace);
        RemoteObjectInstance roi = null;
        try {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext(cmd);
            Iterator remoteJCNHelpers = this.remoteJavaColonNamingHelpers.getServices();
            while (remoteJCNHelpers.hasNext()) {
                RemoteJavaColonNamingHelper helper = (RemoteJavaColonNamingHelper)remoteJCNHelpers.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getRemoteObjectInstance - checking " + helper), (java.lang.Object[])new java.lang.Object[0]);
                }
                if ((roi = helper.getRemoteObjectInstance(namespace, jndiName)) == null) continue;
                break;
            }
        }
        finally {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
        }
        return roi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemoteObjectWithPrefix(String appName, String moduleName, String compName, String namespaceString, String name) throws NamingException {
        boolean b = false;
        NamingConstants.JavaColonNamespace namespace = NamingConstants.JavaColonNamespace.fromName((String)namespaceString);
        ComponentMetaData cmd = this.getCMD(appName, moduleName, compName, namespace);
        try {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext(cmd);
            Iterator remoteJCNHelpers = this.remoteJavaColonNamingHelpers.getServices();
            while (remoteJCNHelpers.hasNext()) {
                RemoteJavaColonNamingHelper helper = (RemoteJavaColonNamingHelper)remoteJCNHelpers.next();
                b = helper.hasRemoteObjectWithPrefix(namespace, name);
                if (!b) continue;
                break;
            }
        }
        finally {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends NameClassPair> listRemoteInstances(String appName, String moduleName, String compName, String namespaceString, String nameInContext) throws NamingException {
        HashSet allInstances = new HashSet();
        NamingConstants.JavaColonNamespace namespace = NamingConstants.JavaColonNamespace.fromName((String)namespaceString);
        ComponentMetaData cmd = this.getCMD(appName, moduleName, compName, namespace);
        try {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext(cmd);
            Iterator remoteJCNHelpers = this.remoteJavaColonNamingHelpers.getServices();
            while (remoteJCNHelpers.hasNext()) {
                RemoteJavaColonNamingHelper helper = (RemoteJavaColonNamingHelper)remoteJCNHelpers.next();
                allInstances.addAll(helper.listRemoteInstances(namespace, nameInContext));
            }
        }
        finally {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
        }
        return allInstances;
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private ComponentMetaData getCMD(String appName, String moduleName, String compName, NamingConstants.JavaColonNamespace namespace) throws NamingException {
        ComponentMetaData cmd;
        String metadataId = this.metadataIdService.getMetaDataIdentifier("CLIENT", appName, moduleName, compName);
        try {
            cmd = (ComponentMetaData)this.metadataIdService.getMetaData(metadataId);
        }
        catch (IllegalStateException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getCMD - no component metadata found for " + metadataId), (java.lang.Object[])new java.lang.Object[0]);
            }
            cmd = null;
        }
        if (cmd == null && NamingConstants.JavaColonNamespace.GLOBAL.equals((java.lang.Object)namespace)) {
            cmd = DUMMY_CMD;
        }
        if (cmd == null) {
            throw new NamingException("Unable to find ComponentMetaData for " + appName + "/" + moduleName + "/" + compName);
        }
        return cmd;
    }

    @Activate
    protected void activate(ComponentContext cc) throws Exception {
        this.remoteJavaColonNamingHelpers.activate(cc);
        this.ejbFactoryRef.activate(cc);
        this.orb = this.orbRef.getORB();
        if (this.orb == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The orb instance is null, possibly because of an earlier failure to bind a port.", (java.lang.Object[])new java.lang.Object[0]);
            }
            return;
        }
        Tie tie = this.getTie();
        POA myPoa = this.createMyPoa();
        Servant servant = (Servant)tie;
        myPoa.activate_object_with_id("ClientSupport".getBytes(), servant);
        this.thisRef = myPoa.servant_to_reference(servant);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String ref = this.orb.object_to_string(this.thisRef);
            Tr.debug((TraceComponent)tc, (String)("activate - created IOR: " + ref), (java.lang.Object[])new java.lang.Object[0]);
        }
        Object o = this.orb.resolve_initial_references("NameService");
        NamingContextExt rootContext = NamingContextExtHelper.narrow((Object)o);
        rootContext.bind(new NameComponent[]{new NameComponent("ClientSupport", "")}, this.thisRef);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.ejbFactoryRef.deactivate(cc);
        this.remoteJavaColonNamingHelpers.deactivate(cc);
    }

    @Trivial
    @Reference(name="remoteJavaColonNamingHelpers", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addRemoteJavaColonNamingHelper(ServiceReference<RemoteJavaColonNamingHelper> helperSR) {
        this.remoteJavaColonNamingHelpers.addReference(helperSR);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addRemoteJavaColonNamingHelper - added helper " + helperSR + " -- all helpers: " + this.remoteJavaColonNamingHelpers), (java.lang.Object[])new java.lang.Object[0]);
        }
    }

    protected void removeRemoteJavaColonNamingHelper(ServiceReference<RemoteJavaColonNamingHelper> helperSR) {
        this.remoteJavaColonNamingHelpers.removeReference(helperSR);
    }

    private Tie getTie() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String packageName = this.getClass().getPackage().getName();
        String tieName = "_" + this.getClass().getSimpleName() + "_Tie";
        Class<?> tieClass = Class.forName(packageName + '.' + tieName);
        Tie tie = (Tie)tieClass.newInstance();
        tie.setTarget((Remote)((java.lang.Object)this));
        return tie;
    }

    /*
     * WARNING - void declaration
     */
    private POA createMyPoa() throws Exception {
        POA rootPoa = this.orbRef.getPOA();
        rootPoa.the_POAManager().activate();
        ArrayList<java.lang.Object> policies = new ArrayList<java.lang.Object>();
        try {
            this.serverPolicySource.addConfiguredPolicies(policies, this.orbRef);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.clientcontainer.remote.server.ClientSupportImpl", (String)"306", (java.lang.Object)this, (java.lang.Object[])new java.lang.Object[0]);
            throw new IllegalStateException((Throwable)e);
        }
        policies.add(rootPoa.create_lifespan_policy(LifespanPolicyValue.TRANSIENT));
        policies.add(rootPoa.create_request_processing_policy(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY));
        policies.add(rootPoa.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN));
        policies.add(rootPoa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID));
        POAManager manager = rootPoa.the_POAManager();
        POA tPOA = rootPoa.create_POA(CLIENT_SUPPORT_POA_NAME, manager, policies.toArray(new Policy[policies.size()]));
        return tPOA;
    }

    @Reference(name="clientEJBFactory", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setClientEJBFactory(ServiceReference<ClientEJBFactory> reference) {
        this.ejbFactoryRef.setReference(reference);
    }

    protected void unsetClientEJBFactory(ServiceReference<ClientEJBFactory> reference) {
        this.ejbFactoryRef.unsetReference(reference);
    }

    public Set<String> getEJBRmicCompatibleClasses(String appName) throws RemoteException {
        ClientEJBFactory factory = (ClientEJBFactory)this.ejbFactoryRef.getService();
        if (factory != null) {
            return factory.getRmicCompatibleClasses(appName);
        }
        throw new RemoteException("Enterprise beans remote feature is not enabled in server process.");
    }

    public RemoteObjectInstance createEJB(String appName, String moduleName, String beanName, String beanInterface) throws NamingException, RemoteException {
        ClientEJBFactory factory = (ClientEJBFactory)this.ejbFactoryRef.getService();
        if (factory != null) {
            return factory.create(appName, moduleName, beanName, beanInterface);
        }
        throw new RemoteException("Enterprise beans remote feature is not enabled in server process.");
    }

    public RemoteObjectInstance createEJB(String appName, String beanName, String beanInterface) throws NamingException, RemoteException {
        ClientEJBFactory factory = (ClientEJBFactory)this.ejbFactoryRef.getService();
        if (factory != null) {
            return factory.create(appName, beanName, beanInterface);
        }
        throw new RemoteException("Enterprise beans remote feature is not enabled in server process.");
    }

    public RemoteObjectInstance findEJBByBeanName(String appName, String beanName, String beanInterface) throws NamingException, RemoteException {
        ClientEJBFactory factory = (ClientEJBFactory)this.ejbFactoryRef.getService();
        if (factory != null) {
            return factory.findByBeanName(appName, beanName, beanInterface);
        }
        throw new RemoteException("Enterprise beans remote feature is not enabled in server process.");
    }

    public RemoteObjectInstance findEJBByInterface(String appName, String beanInterface) throws NamingException, RemoteException {
        ClientEJBFactory factory = (ClientEJBFactory)this.ejbFactoryRef.getService();
        if (factory != null) {
            return factory.findByInterface(appName, beanInterface);
        }
        throw new RemoteException("Enterprise beans remote feature is not enabled in server process.");
    }
}

