/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class Utils {
    private static final String pattern = "dd/MM/yyyy, HH:mm.ss:SSS z";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy, HH:mm.ss:SSS z");
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();

    public static final String traceTime(long timestamp) {
        return Instant.ofEpochMilli(timestamp).atZone(ZONE_ID).format(DATE_TIME_FORMATTER);
    }

    public static String toString(byte[] b) {
        StringBuffer result = new StringBuffer(b.length);
        for (int i = 0; i < b.length; ++i) {
            result.append((char)b[i]);
        }
        return result.toString();
    }

    public static byte[] byteArray(String s) {
        return Utils.byteArray(s, false);
    }

    public static byte[] byteArray(String s, boolean keepBothBytes) {
        byte[] result = new byte[s.length() * (keepBothBytes ? 2 : 1)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = keepBothBytes ? (byte)(s.charAt(i / 2) >> (i & 1) * 8) : (byte)s.charAt(i);
        }
        return result;
    }
}

