/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.selector.impl.Pattern;
import java.util.ArrayList;
import java.util.Iterator;

public class TopicPattern
extends Pattern {
    TopicPattern(Iterator tokens) {
        super(tokens);
    }

    @Override
    boolean checkPrefix(char[] chars, int[] cursor) {
        if (chars.length > cursor[0] && chars[cursor[0]] == '\u0001') {
            return false;
        }
        if (this.prefix == null) {
            return true;
        }
        if (cursor[1] - cursor[0] < this.prefix.minlen) {
            return false;
        }
        for (int i = 0; i < this.prefix.items.length; ++i) {
            Object item = this.prefix.items[i];
            if (!(item == Pattern.matchOne ? !TopicPattern.topicSkipForward(chars, cursor) : !TopicPattern.matchForward(chars, (char[])item, cursor))) continue;
            return false;
        }
        return cursor[0] == cursor[1] || chars[cursor[0]] == '/';
    }

    static boolean topicSkipForward(char[] chars, int[] cursor) {
        if (cursor[0] == cursor[1]) {
            return false;
        }
        while (cursor[0] < cursor[1] && chars[cursor[0]] != '/') {
            cursor[0] = cursor[0] + 1;
        }
        return true;
    }

    @Override
    boolean checkSuffix(char[] chars, int[] cursor) {
        int last;
        if (this.suffix == null) {
            return true;
        }
        if (cursor[1] - cursor[0] < this.suffix.minlen) {
            return false;
        }
        for (int i = last = this.suffix.items.length - 1; i >= 0; --i) {
            Object item = this.suffix.items[i];
            if (!(item == Pattern.matchOne ? !TopicPattern.topicSkipBackward(chars, cursor) : !TopicPattern.matchBackward(chars, (char[])item, cursor))) continue;
            return false;
        }
        return cursor[0] < cursor[1] && chars[cursor[1] - 1] == '/';
    }

    static boolean topicSkipBackward(char[] chars, int[] cursor) {
        if (cursor[0] == cursor[1]) {
            return false;
        }
        while (cursor[0] < cursor[1] && chars[cursor[1] - 1] != '/') {
            cursor[1] = cursor[1] - 1;
        }
        return true;
    }

    static boolean matchBackward(char[] chars, char[] pattern, int[] cursor) {
        int start = cursor[1] - pattern.length;
        if (start < cursor[0]) {
            return false;
        }
        if (!TopicPattern.matchForward(chars, pattern, new int[]{start, cursor[1]})) {
            return false;
        }
        cursor[1] = start;
        return true;
    }

    public static Object parsePattern(String pattern) {
        char[] accum = new char[pattern.length()];
        int finger = 0;
        ArrayList<Object> tokens = new ArrayList<Object>();
        boolean trivial = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                finger = TopicPattern.flush(accum, finger, tokens);
                tokens.add(matchOne);
                trivial = false;
                continue;
            }
            if (c == '/') {
                if (i == pattern.length() - 1) {
                    accum[finger++] = c;
                    continue;
                }
                if (pattern.charAt(i + 1) == '/') {
                    finger = TopicPattern.flush(accum, finger, tokens);
                    tokens.add(matchMany);
                    trivial = false;
                    if (pattern.charAt(++i + 1) != '.' || ++i + 1 >= pattern.length() || pattern.charAt(i + 1) != '/') continue;
                    ++i;
                    continue;
                }
                if (pattern.charAt(i + 1) == '.') {
                    ++i;
                    continue;
                }
                accum[finger++] = c;
                continue;
            }
            accum[finger++] = c;
        }
        if (trivial) {
            return new String(accum, 0, finger);
        }
        TopicPattern.flush(accum, finger, tokens);
        return new TopicPattern(tokens.iterator());
    }

    public static Object parseMQSIPattern(String pattern) {
        char[] accum = new char[pattern.length()];
        int finger = 0;
        ArrayList<Object> tokens = new ArrayList<Object>();
        boolean trivial = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '+') {
                finger = TopicPattern.flush(accum, finger, tokens);
                tokens.add(matchOne);
                trivial = false;
                continue;
            }
            if (c == '#') {
                finger = TopicPattern.flush(accum, finger, tokens);
                tokens.add(matchMany);
                trivial = false;
                if (i >= pattern.length() - 1) continue;
                ++i;
                continue;
            }
            if (c == '/') {
                if (i != pattern.length() - 1 && pattern.charAt(i + 1) == '#') continue;
                accum[finger++] = c;
                continue;
            }
            accum[finger++] = c;
        }
        if (trivial) {
            return new String(accum, 0, finger);
        }
        TopicPattern.flush(accum, finger, tokens);
        return new TopicPattern(tokens.iterator());
    }
}

