/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.pojo;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.v1.pojo.ToolEntry;
import com.ibm.ws.ui.internal.v1.utils.Utils;
import com.ibm.ws.ui.internal.validation.InvalidToolException;
import java.util.Locale;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Validator;

@TraceOptions(messageBundle="com.ibm.ws.ui.internal.resources.ValidationStrings")
public class Bookmark
extends ToolEntry {
    private static final transient TraceComponent tc = Tr.register(Bookmark.class);
    static final transient String INVALID_CHARACTERS = ".*[~&:;\\\\/?{}<>\\[\\]].*";
    transient String objectType = "bookmark";
    String name;
    String url;
    String icon;
    String description;

    @Trivial
    Bookmark() {
    }

    @Trivial
    public Bookmark(String name, String url, String icon) {
        this(Utils.urlEncode(name), "bookmark", name, url, icon, null);
    }

    @Trivial
    public Bookmark(String name, String url, String icon, String description) {
        this(Utils.urlEncode(name), "bookmark", name, url, icon, description);
    }

    @Trivial
    Bookmark(String id, String type, String name, String url, String icon, String description) {
        super(id, type);
        this.name = name;
        this.url = url;
        this.icon = icon;
        this.description = description;
    }

    @Trivial
    private void setName(String name) {
        this.name = name;
    }

    @Trivial
    public String getName() {
        return this.name;
    }

    @Trivial
    private void setURL(String url) {
        this.url = url;
    }

    @Trivial
    public String getURL() {
        return this.url;
    }

    @Trivial
    private void setIcon(String icon) {
        this.icon = icon;
    }

    @Trivial
    public String getIcon() {
        return this.icon;
    }

    @Trivial
    private void setDescription(String description) {
        this.description = description;
    }

    @Trivial
    public String getDescription() {
        return this.description;
    }

    @Trivial
    private String listNullFields(boolean descriptionOptional) {
        StringBuilder sb = new StringBuilder();
        if (this.name == null || this.name.isEmpty()) {
            this.addTo(sb, "name");
        }
        if (this.url == null || this.url.isEmpty()) {
            this.addTo(sb, "url");
        }
        if (this.icon == null || this.icon.isEmpty()) {
            this.addTo(sb, "icon");
        }
        if (!descriptionOptional && (this.description == null || this.description.isEmpty())) {
            this.addTo(sb, "description");
        }
        return sb.toString();
    }

    private boolean isValidURL(String value) {
        String lowerURL = value.toLowerCase();
        Validator v = ESAPI.validator();
        if (lowerURL.contains(":/")) {
            return v.isValidInput("URL", lowerURL, "UIToolAbsoluteURLRule", Integer.MAX_VALUE, false);
        }
        String[] relativeURLRules = new String[]{"UIToolRelativeURLRule1", "UIToolRelativeURLRule2", "UIToolRelativeURLRule3", "UIToolRelativeURLRule4"};
        for (int i = 0; i < relativeURLRules.length; ++i) {
            if (v.isValidInput("URL", lowerURL, relativeURLRules[i], Integer.MAX_VALUE, true)) continue;
            return false;
        }
        return true;
    }

    boolean containsNoXSS(String value) {
        if (value != null) {
            return ESAPI.validator().isValidInput("FIELD", value.toLowerCase(Locale.ENGLISH), "NoXSSContent", Integer.MAX_VALUE, true);
        }
        return true;
    }

    boolean containsValidCharacters(String value) {
        return ESAPI.validator().isValidInput("FIELD", value, "UIToolValidCharacters", Integer.MAX_VALUE, true);
    }

    private String listXSSFields() {
        StringBuilder sb = new StringBuilder();
        if (!this.containsNoXSS(this.name)) {
            this.addTo(sb, "name");
        }
        if (!this.containsNoXSS(this.url)) {
            this.addTo(sb, "url");
        }
        if (!this.containsNoXSS(this.icon)) {
            this.addTo(sb, "icon");
        }
        if (!this.containsNoXSS(this.description)) {
            this.addTo(sb, "description");
        }
        return sb.toString();
    }

    @Override
    public void validateSelf() throws InvalidToolException {
        this.validateSelf(true, true);
    }

    void validateSelf(boolean shouldIdCheck, boolean descriptionOptional) throws InvalidToolException {
        super.validateSelf();
        if (!this.objectType.equals(this.type)) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "TYPE_NOT_CORRECT", this.objectType, this.type));
        }
        String badRQDfields = this.listNullFields(descriptionOptional);
        if (badRQDfields.length() != 0) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "RQD_FIELDS_MISSING", badRQDfields));
        }
        String badXSSfields = this.listXSSFields();
        if (badXSSfields.length() != 0) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "XSS_DETECTED", badXSSfields));
        }
        if (!this.isValidURL(this.url)) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "URL_NOT_VALID", this.url));
        }
        if (!this.isValidURL(this.icon)) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "ICON_NOT_VALID", this.icon));
        }
        if (shouldIdCheck && !this.id.equals(Utils.urlEncode(this.name))) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "ID_NOT_VALID", this.id, this.name));
        }
        if (!this.containsValidCharacters(this.name)) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "NAME_NOT_VALID", this.name, INVALID_CHARACTERS));
        }
        if (this.description != null && !this.containsValidCharacters(this.description)) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "DESCRIPTION_NOT_VALID", this.description, INVALID_CHARACTERS));
        }
    }

    @Override
    @Trivial
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Bookmark) {
            Bookmark that = (Bookmark)o;
            boolean sameFields = true;
            sameFields &= this.name == that.name || this.name != null && this.name.equals(that.name);
            sameFields &= this.url == that.url || this.url != null && this.url.equals(that.url);
            sameFields &= this.icon == that.icon || this.icon != null && this.icon.equals(that.icon);
            return super.equals(o) && (sameFields &= this.description == that.description || this.description != null && this.description.equals(that.description));
        }
        return false;
    }

    @Override
    @Trivial
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder("Bookmark {\"id\":");
        sb.append(this.getJSONString(this.id));
        sb.append(",\"type\":");
        sb.append(this.getJSONString(this.type));
        sb.append(",\"name\":");
        sb.append(this.getJSONString(this.name));
        sb.append(",\"url\":");
        sb.append(this.getJSONString(this.url));
        sb.append(",\"icon\":");
        sb.append(this.getJSONString(this.icon));
        sb.append(",\"description\":");
        sb.append(this.getJSONString(this.description));
        sb.append("}");
        return sb.toString();
    }
}

