/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.rest.v1.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.rest.CommonJSONRESTHandler;
import com.ibm.ws.ui.internal.rest.exceptions.BadRequestException;
import com.ibm.ws.ui.internal.rest.exceptions.NoSuchResourceException;
import com.ibm.ws.ui.internal.rest.exceptions.RESTException;
import com.ibm.ws.ui.internal.rest.exceptions.UserNotAuthorizedException;
import com.ibm.ws.ui.internal.rest.v1.utils.V1UtilsConstants;
import com.ibm.ws.ui.internal.v1.pojo.Message;
import com.ibm.ws.ui.internal.v1.utils.URLUtility;
import com.ibm.ws.ui.internal.v1.utils.URLUtilityImpl;
import com.ibm.ws.ui.internal.v1.utils.Utils;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class URLUtils
extends CommonJSONRESTHandler
implements V1UtilsConstants {
    private static final TraceComponent tc = Tr.register(URLUtils.class);
    private final URLUtility utils;

    public URLUtils() {
        super("/adminCenter/v1/utils/url", true, false);
        this.utils = new URLUtilityImpl();
    }

    public URLUtils(URLUtility utils) {
        super("/adminCenter/v1/utils/url", true, false);
        this.utils = utils;
    }

    @Override
    public boolean isKnownChildResource(String child, RESTRequest request) {
        if ("getTool".equals(child)) {
            return true;
        }
        return "getStatus".equals(child);
    }

    @Override
    public Map<String, String> getBase(RESTRequest request, RESTResponse response) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String url = request.getURL();
        map.put("getTool", url + (url.endsWith("/") ? "getTool" : "/getTool"));
        map.put("getStatus", url + (url.endsWith("/") ? "getStatus" : "/getStatus"));
        return map;
    }

    @FFDCIgnore(value={MalformedURLException.class})
    private URL getURLParameter(String operation, RESTRequest request) throws BadRequestException {
        String toolURL = request.getParameter("url");
        if (toolURL == null) {
            Message error = new Message(400, RequestNLS.formatMessage(tc, "OP_REQUIRES_URL", operation));
            throw new BadRequestException("application/json; charset=UTF-8", error);
        }
        URL urlObj = null;
        try {
            urlObj = Utils.getURL(toolURL);
        }
        catch (MalformedURLException e) {
            Message error = new Message(400, RequestNLS.formatMessage(tc, "OP_BAD_URL", operation, e.getMessage()));
            throw new BadRequestException("application/json; charset=UTF-8", error);
        }
        return urlObj;
    }

    private Object getStatus(RESTRequest request) throws RESTException {
        URL url = this.getURLParameter("getStatus", request);
        return this.utils.getStatus(url);
    }

    private Object getTool(RESTRequest request) throws RESTException {
        URL url = this.getURLParameter("getTool", request);
        return this.utils.analyzeURL(url);
    }

    @Override
    public Object getChild(RESTRequest request, RESTResponse response, String childResource) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        if ("getStatus".equals(childResource)) {
            return this.getStatus(request);
        }
        if ("getTool".equals(childResource)) {
            return this.getTool(request);
        }
        throw new NoSuchResourceException();
    }
}

