/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ElementKind;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.bval.BeanValidationContext;
import org.apache.bval.jsr.ConstraintValidation;
import org.apache.bval.jsr.ConstraintValidationListener;
import org.apache.bval.jsr.ConstraintValidatorIdentity;
import org.apache.bval.jsr.GraphBeanIdentity;
import org.apache.bval.jsr.GroupValidationContext;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.groups.Groups;
import org.apache.bval.jsr.resolver.CachingTraversableResolver;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.AccessStrategy;

final class GroupValidationContextImpl<T>
extends BeanValidationContext<ConstraintValidationListener<T>>
implements GroupValidationContext<T>,
MessageInterpolator.Context {
    private final MessageInterpolator messageResolver;
    private final PathImpl path;
    private final MetaBean rootMetaBean;
    private final ParameterNameProvider parameterNameProvider;
    private Groups groups;
    private Group currentGroup;
    private Class<?> currentOwner;
    private HashSet<ConstraintValidatorIdentity> validatedConstraints = new HashSet();
    private ConstraintValidation<?> constraintValidation;
    private final TraversableResolver traversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private Object[] parameters;
    private Object returnValue;
    private Method method;
    private Constructor<?> constructor;

    public GroupValidationContextImpl(ConstraintValidationListener<T> listener, MessageInterpolator aMessageResolver, TraversableResolver traversableResolver, ParameterNameProvider parameterNameProvider, ConstraintValidatorFactory constraintValidatorFactory, MetaBean rootMetaBean) {
        super(listener, new HashMap());
        this.messageResolver = aMessageResolver;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.traversableResolver = CachingTraversableResolver.cacheFor(traversableResolver);
        this.parameterNameProvider = parameterNameProvider;
        this.rootMetaBean = rootMetaBean;
        this.path = PathImpl.create();
    }

    @Override
    public void setCurrentIndex(Integer index) {
        NodeImpl leaf = this.path.getLeafNode();
        if (leaf.getName() == null) {
            leaf.setIndex(index);
        } else {
            this.path.addNode(NodeImpl.atIndex(index));
        }
    }

    @Override
    public void setCurrentKey(Object key) {
        NodeImpl leaf = this.path.getLeafNode();
        if (leaf.getName() == null) {
            leaf.setKey(key);
        } else {
            this.path.addNode(NodeImpl.atKey(key));
        }
    }

    @Override
    public void setKind(ElementKind type) {
        this.path.getLeafNode().setKind(type);
    }

    @Override
    public void moveDown(MetaProperty prop, AccessStrategy access) {
        this.moveDown(prop.getName());
        super.moveDown(prop, access);
    }

    @Override
    public void moveDown(String prop) {
        this.path.addProperty(prop);
    }

    @Override
    public void moveDown(Path.Node node) {
        this.path.addNode(node);
    }

    @Override
    public void moveUp(Object bean, MetaBean metaBean) {
        NodeImpl leaf = this.path.getLeafNode();
        if (leaf.isInIterable() && leaf.getName() != null) {
            leaf.setName(null);
        } else {
            this.path.removeLeafNode();
        }
        super.moveUp(bean, metaBean);
    }

    @Override
    public boolean collectValidated() {
        GraphBeanIdentity gbi = new GraphBeanIdentity(this.getBean(), this.getCurrentGroup().getGroup(), this.getCurrentOwner());
        HashSet<PathImpl> validatedPathsForGBI = (HashSet<PathImpl>)this.validatedObjects.get(gbi);
        if (validatedPathsForGBI == null) {
            validatedPathsForGBI = new HashSet<PathImpl>();
            this.validatedObjects.put(gbi, validatedPathsForGBI);
        }
        for (PathImpl validatedPath : validatedPathsForGBI) {
            if (!this.path.isSubPathOf(validatedPath)) continue;
            return false;
        }
        validatedPathsForGBI.add(PathImpl.copy(this.path));
        return true;
    }

    @Override
    public boolean collectValidated(ConstraintValidator<?, ?> constraint) {
        ConstraintValidatorIdentity cvi = new ConstraintValidatorIdentity(this.getBean(), this.getPropertyPath(), constraint);
        return this.validatedConstraints.add(cvi);
    }

    public void resetValidatedConstraints() {
        this.validatedConstraints.clear();
    }

    @Override
    public PathImpl getPropertyPath() {
        PathImpl currentPath = PathImpl.copy(this.path);
        if (this.getMetaProperty() != null) {
            currentPath.addProperty(this.getMetaProperty().getName());
        }
        return currentPath;
    }

    @Override
    public MetaBean getRootMetaBean() {
        return this.rootMetaBean;
    }

    public void setGroups(Groups groups) {
        this.groups = groups;
    }

    @Override
    public Groups getGroups() {
        return this.groups;
    }

    @Override
    public void setCurrentGroups(Groups g) {
        this.groups = g;
    }

    @Override
    public Group getCurrentGroup() {
        return this.currentGroup;
    }

    @Override
    public void setCurrentGroup(Group currentGroup) {
        this.currentGroup = currentGroup;
    }

    @Override
    public void setConstraintValidation(ConstraintValidation<?> constraint) {
        this.constraintValidation = constraint;
    }

    @Override
    public ConstraintValidation<?> getConstraintValidation() {
        return this.constraintValidation;
    }

    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintValidation;
    }

    @Override
    public Object getValidatedValue() {
        if (this.getMetaProperty() != null) {
            return this.getPropertyValue(this.constraintValidation.getAccess());
        }
        return this.getBean();
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    @Override
    public MessageInterpolator getMessageResolver() {
        return this.messageResolver;
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    @Override
    public Class<?> getCurrentOwner() {
        return this.currentOwner;
    }

    @Override
    public void setCurrentOwner(Class<?> currentOwner) {
        this.currentOwner = currentOwner;
    }

    @Override
    public ElementKind getElementKind() {
        return this.path.getLeafNode().getKind();
    }

    @Override
    public Object getReturnValue() {
        return this.returnValue;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    @Override
    public ParameterNameProvider getParameterNameProvider() {
        return this.parameterNameProvider;
    }

    @Override
    public void setMethod(Method method) {
        this.method = method;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Override
    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }
}

