/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.octracker;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.jfapchannel.JFapConnectFailedException;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionFactory;
import com.ibm.ws.sib.jfapchannel.framework.NetworkTransportFactory;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.JFapAddress;
import com.ibm.ws.sib.jfapchannel.impl.OutboundConnection;
import com.ibm.ws.sib.jfapchannel.impl.octracker.ClientConnectionReadyCallback;
import com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionData;
import com.ibm.ws.sib.jfapchannel.impl.octracker.EndPointDescriptor;
import com.ibm.ws.sib.jfapchannel.impl.octracker.IdleConnectionPool;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.utils.Semaphore;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;

public class ConnectionDataGroup {
    private static final TraceComponent tc = SibTr.register(ConnectionDataGroup.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls;
    private final OutboundConnectionTracker tracker;
    private final LinkedList<ConnectionData> connectionData = new LinkedList();
    private final EndPointDescriptor groupEndpointDescriptor;
    private int connectAttemptsPending = 0;
    private final int conversationsPerConnection;
    private final ExistingNetworkConnectionFactoryHolder currentConnectionFactoryFactory;
    private final Framework framework;
    private final int heartbeatInterval;
    private final int heartbeatTimeout;
    private final Object connectionMonitor = new Object(){};

    protected ConnectionDataGroup(OutboundConnectionTracker tracker, NetworkConnectionFactory virtualConnectionFactory, EndPointDescriptor descriptor, int conversationsPerConnection, int heartbeatInterval, int heartbeatTimeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{tracker, virtualConnectionFactory, descriptor, "" + conversationsPerConnection});
        }
        this.groupEndpointDescriptor = descriptor;
        this.tracker = tracker;
        this.currentConnectionFactoryFactory = new ExistingNetworkConnectionFactoryHolder(virtualConnectionFactory);
        this.conversationsPerConnection = conversationsPerConnection;
        this.framework = null;
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatTimeout = heartbeatTimeout;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected ConnectionDataGroup(OutboundConnectionTracker tracker, EndPointDescriptor descriptor, int conversationsPerConnection, Framework framework, int heartbeatInterval, int heartbeatTimeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{tracker, descriptor, "" + conversationsPerConnection, framework, "" + heartbeatInterval, "" + heartbeatTimeout});
        }
        this.groupEndpointDescriptor = descriptor;
        this.tracker = tracker;
        this.currentConnectionFactoryFactory = new ExistingNetworkConnectionFactoryHolder(null);
        this.conversationsPerConnection = conversationsPerConnection;
        this.framework = framework;
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatTimeout = heartbeatTimeout;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected ConnectionDataGroup(OutboundConnectionTracker tracker, NetworkConnectionFactory virtualConnectionFactory, EndPointDescriptor descriptor, Framework framework) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{tracker, virtualConnectionFactory, descriptor, framework});
        }
        this.groupEndpointDescriptor = descriptor;
        this.tracker = tracker;
        this.currentConnectionFactoryFactory = new ExistingNetworkConnectionFactoryHolder(virtualConnectionFactory);
        this.conversationsPerConnection = Integer.MAX_VALUE;
        this.framework = framework;
        this.heartbeatInterval = Integer.MAX_VALUE;
        this.heartbeatTimeout = Integer.MAX_VALUE;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getConnections() {
        List rc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnections");
        }
        LinkedList<ConnectionData> linkedList = this.connectionData;
        synchronized (linkedList) {
            rc = (List)this.connectionData.clone();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnections", (Object)rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionData findConnectionDataToUse() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findConnectionDataToUse");
        }
        ConnectionData connectionDataToUse = null;
        LinkedList<ConnectionData> linkedList = this.connectionData;
        synchronized (linkedList) {
            IdleConnectionPool p;
            OutboundConnection oc;
            int lowestUseCount = this.conversationsPerConnection;
            for (int i = 0; i < this.connectionData.size(); ++i) {
                ConnectionData cd = this.connectionData.get(i);
                if (cd.getUseCount() >= lowestUseCount) continue;
                lowestUseCount = cd.getUseCount();
                connectionDataToUse = cd;
            }
            if (connectionDataToUse == null && (oc = (p = IdleConnectionPool.getInstance()).remove(this.groupEndpointDescriptor)) != null) {
                connectionDataToUse = new ConnectionData(this, this.groupEndpointDescriptor);
                oc.setConnectionData(connectionDataToUse);
                connectionDataToUse.setConnection(oc);
                this.connectionData.add(connectionDataToUse);
            }
            if (connectionDataToUse != null) {
                connectionDataToUse.incrementUseCount();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findConnectionDataToUse", (Object)connectionDataToUse);
        }
        return connectionDataToUse;
    }

    protected Conversation connect(Object endPoint, ConversationReceiveListener conversationReceiveListener, Conversation.ConversationType conversationType) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{endPoint, conversationReceiveListener, conversationType});
        }
        if (this.currentConnectionFactoryFactory.isNonNull()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"type of endpoint does not match group");
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"));
        }
        CreateNewVirtualConnectionFactory factory = new CreateNewVirtualConnectionFactory(endPoint);
        JFapAddressHolder jfapAddressHolder = new JFapAddressHolder(factory, conversationType);
        Conversation retConversation = this.doConnect(conversationReceiveListener, ConversationUsageType.JFAP, jfapAddressHolder, factory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)retConversation);
        }
        return retConversation;
    }

    protected Conversation connect(InetSocketAddress remoteAddress, String chainName, ConversationReceiveListener conversationReceiveListener, Conversation.ConversationType conversationType) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{remoteAddress, chainName, conversationReceiveListener, conversationType});
        }
        if (!this.currentConnectionFactoryFactory.isNonNull()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"type of endpoint does not match group");
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"));
        }
        JFapAddressHolder jfapAddressHolder = new JFapAddressHolder(remoteAddress, conversationType);
        Conversation retConversation = this.doConnect(conversationReceiveListener, ConversationUsageType.JFAP, jfapAddressHolder, this.currentConnectionFactoryFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)retConversation);
        }
        return retConversation;
    }

    protected Conversation connect(ConversationReceiveListener conversationReceiveListener, ConversationUsageType usageType) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{conversationReceiveListener, usageType});
        }
        Conversation retConversation = this.doConnect(conversationReceiveListener, usageType, new JFapAddressHolder(), this.currentConnectionFactoryFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)retConversation);
        }
        return retConversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Conversation doConnect(ConversationReceiveListener conversationReceiveListener, ConversationUsageType usageType, JFapAddressHolder jfapAddressHolder, NetworkConnectionFactoryHolder ncfHolder) throws JFapConnectFailedException, SIResourceException {
        Conversation retConversation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"doConnect", (Object)new Object[]{conversationReceiveListener, usageType, jfapAddressHolder, ncfHolder});
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            try {
                ConnectionData connectionDataToUse = this.findConnectionDataToUse();
                boolean isNewConnectionData = false;
                if (connectionDataToUse == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection data does not already exist");
                    }
                    try {
                        NetworkConnection vc = this.connectOverNetwork(jfapAddressHolder, ncfHolder);
                        connectionDataToUse = this.createnewConnectionData(vc);
                        isNewConnectionData = true;
                    }
                    catch (FrameworkException frameworkException) {
                        FFDCFilter.processException((Throwable)frameworkException, (String)"com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup.doConnect", (String)"00240004", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)frameworkException);
                        }
                        throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"), (Throwable)frameworkException);
                    }
                }
                retConversation = this.startNewConversation(connectionDataToUse, conversationReceiveListener, isNewConnectionData, usageType.requiresNormalHandshakeProcessing());
            }
            finally {
                ConnectionDataGroup connectionDataGroup = this;
                synchronized (connectionDataGroup) {
                    --this.connectAttemptsPending;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(this.connectAttemptsPending + " connection attempts still pending"));
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"doConnect", (Object)retConversation);
        }
        return retConversation;
    }

    private NetworkConnection connectOverNetwork(JFapAddressHolder addressHolder, NetworkConnectionFactoryHolder factoryHolder) throws JFapConnectFailedException, FrameworkException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connectOverNetwork", (Object)new Object[]{addressHolder, factoryHolder});
        }
        NetworkConnectionFactory vcf = factoryHolder.getFactory();
        NetworkConnection vc = vcf.createConnection();
        Semaphore sem = new Semaphore();
        ClientConnectionReadyCallback callback = new ClientConnectionReadyCallback(sem);
        vc.connectAsynch(addressHolder.getAddress(), callback);
        sem.waitOnIgnoringInterruptions();
        if (!callback.connectionSucceeded()) {
            Object[] failureInserts;
            String failureKey;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connect has failed due to ", (Object)callback.getException());
            }
            if (addressHolder.getAddress() != null) {
                failureKey = "CONNDATAGROUP_CONNFAILED_SICJ0063";
                failureInserts = addressHolder.getErrorInserts();
            } else {
                failureKey = "CONNDATAGROUP_CONNFAILED_SICJ0080";
                failureInserts = new Object[]{};
            }
            String message = nls.getFormattedMessage(failureKey, failureInserts, failureKey);
            throw new JFapConnectFailedException(message, callback.getException());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connectOverNetwork", (Object)vc);
        }
        return vc;
    }

    private ConnectionData createnewConnectionData(NetworkConnection vc) throws FrameworkException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createnewConnectionData", (Object)vc);
        }
        NetworkConnectionContext connLink = vc.getNetworkConnectionContext();
        ConnectionData connectionDataToUse = new ConnectionData(this, this.groupEndpointDescriptor);
        connectionDataToUse.incrementUseCount();
        OutboundConnection oc = new OutboundConnection(connLink, vc, this.tracker, this.heartbeatInterval, this.heartbeatTimeout, connectionDataToUse);
        connectionDataToUse.setConnection(oc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createnewConnectionData", (Object)connectionDataToUse);
        }
        return connectionDataToUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Conversation startNewConversation(ConnectionData connectionDataToUse, ConversationReceiveListener conversationReceiveListener, boolean isNewConnectionData, boolean handshake) throws SIResourceException {
        ConversationImpl retConversation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startNewConversation", (Object)new Object[]{connectionDataToUse, conversationReceiveListener, isNewConnectionData, handshake});
        }
        ConnectionDataGroup connectionDataGroup = this;
        synchronized (connectionDataGroup) {
            if (isNewConnectionData) {
                LinkedList<ConnectionData> linkedList = this.connectionData;
                synchronized (linkedList) {
                    this.connectionData.add(connectionDataToUse);
                }
            }
            retConversation = connectionDataToUse.getConnection().startNewConversation(conversationReceiveListener, handshake);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startNewConversation", (Object)retConversation);
        }
        return retConversation;
    }

    protected synchronized void connectionPending() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connectionPending");
        }
        ++this.connectAttemptsPending;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)(this.connectAttemptsPending + " connection attempts now pending"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connectionPending");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void close(OutboundConnection connection) {
        ConnectionData data;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)connection);
        }
        if (connection.getConnectionData().getConnectionDataGroup() != this) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection does not belong to this group", (Object)connection.getConnectionData().getConnectionDataGroup());
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"));
        }
        boolean isNowIdle = false;
        LinkedList<ConnectionData> linkedList = this.connectionData;
        synchronized (linkedList) {
            data = connection.getConnectionData();
            data.decrementUseCount();
            if (data.getUseCount() == 0) {
                this.connectionData.remove(data);
                isNowIdle = true;
            }
        }
        if (isNowIdle) {
            IdleConnectionPool.getInstance().add(data.getConnection(), this.groupEndpointDescriptor);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    protected EndPointDescriptor getEndPointDescriptor() {
        return this.groupEndpointDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEmpty() {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEmpty");
        }
        ConnectionDataGroup connectionDataGroup = this;
        synchronized (connectionDataGroup) {
            LinkedList<ConnectionData> linkedList = this.connectionData;
            synchronized (linkedList) {
                result = this.connectionData.isEmpty();
            }
            result = result && this.connectAttemptsPending == 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isEmpty", (Object)("" + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation clone(OutboundConnection connection, ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        ConversationImpl retConversation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clone", (Object)new Object[]{connection, conversationReceiveListener});
        }
        if (connection.getConnectionData().getConnectionDataGroup() != this) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection not part of this data group", (Object)connection.getConnectionData().getConnectionDataGroup());
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNDATAGROUP_INTERNAL_SICJ0062", null, "CONNDATAGROUP_INTERNAL_SICJ0062"));
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            ConnectionDataGroup connectionDataGroup = this;
            synchronized (connectionDataGroup) {
                ConnectionData connectionDataToUse = connection.getConnectionData();
                retConversation = connectionDataToUse.getConnection().startNewConversation(conversationReceiveListener, true);
                LinkedList<ConnectionData> linkedList = this.connectionData;
                synchronized (linkedList) {
                    connectionDataToUse.incrementUseCount();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clone", (Object)retConversation);
        }
        return retConversation;
    }

    protected void purgeFromInvalidateImpl(OutboundConnection connection, boolean notifyPeer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"purgeFromInvalidateImpl", (Object)new Object[]{connection, notifyPeer});
        }
        this.purge(connection, true, notifyPeer);
        IdleConnectionPool p = IdleConnectionPool.getInstance();
        while (p.remove(this.groupEndpointDescriptor) != null) {
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"purgeFromInvalidateImpl");
        }
    }

    protected void purgeClosedConnection(OutboundConnection connection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"purgeClosedConnection", (Object)connection);
        }
        this.purge(connection, false, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"purgeClosedConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge(OutboundConnection connection, boolean calledFromInvalidateImpl, boolean notifyPeer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"purge", (Object)new Object[]{connection, calledFromInvalidateImpl, notifyPeer});
        }
        boolean connectionBeingPurged = false;
        OutboundConnection outboundConnection = connection;
        synchronized (outboundConnection) {
            connectionBeingPurged = connection.isBeingPurged();
            if (!connectionBeingPurged) {
                connection.beingPurged();
            }
        }
        if (!connectionBeingPurged) {
            boolean doPhysicalClose;
            LinkedList<ConnectionData> linkedList = this.connectionData;
            synchronized (linkedList) {
                doPhysicalClose = this.connectionData.remove(connection.getConnectionData());
            }
            if (doPhysicalClose && calledFromInvalidateImpl) {
                connection.physicalCloseFromInvalidateImpl(notifyPeer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"purge");
        }
    }

    public NetworkConnectionFactory getNetworkConnectionFactory() {
        return this.currentConnectionFactoryFactory.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionDataFromGroup(ConnectionData cd) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeConnectionDataFromGroup", (Object)new Object[]{cd});
        }
        boolean removed = false;
        LinkedList<ConnectionData> linkedList = this.connectionData;
        synchronized (linkedList) {
            removed = this.connectionData.remove(cd);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeConnectionDataFromGroup", (Object)new Object[]{removed});
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/octracker/ConnectionDataGroup.java, SIB.comms, WASX.SIB, uu1215.01 1.55");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    }

    private static class JFapAddressHolder {
        private CreateNewVirtualConnectionFactory factory;
        private Conversation.ConversationType conversationType;
        private InetSocketAddress inetAddress;
        private JFapAddress jFapAddress;
        private String hostAddress;
        private final boolean empty;

        public JFapAddressHolder() {
            this.empty = true;
        }

        public JFapAddressHolder(CreateNewVirtualConnectionFactory factory, Conversation.ConversationType conversationType) {
            this.factory = factory;
            this.conversationType = conversationType;
            this.inetAddress = null;
            this.jFapAddress = null;
            this.hostAddress = null;
            this.empty = false;
        }

        public JFapAddressHolder(InetSocketAddress inetAddress, Conversation.ConversationType conversationType) {
            this.factory = null;
            this.conversationType = conversationType;
            this.inetAddress = inetAddress;
            this.jFapAddress = null;
            this.hostAddress = null;
            this.empty = false;
        }

        public JFapAddress getAddress() {
            if (this.empty) {
                return null;
            }
            if (this.jFapAddress == null) {
                if (this.factory != null) {
                    InetAddress epAddress = this.factory.getEndPointAddress();
                    int epPort = this.factory.getEndPointPort();
                    this.inetAddress = new InetSocketAddress(epAddress, epPort);
                }
                this.jFapAddress = new JFapAddress(this.inetAddress, this.conversationType);
            }
            return this.jFapAddress;
        }

        public Object[] getErrorInserts() {
            if (this.empty) {
                return null;
            }
            if (this.hostAddress == null) {
                this.hostAddress = this.inetAddress.getAddress() != null ? this.inetAddress.getAddress().toString() : this.inetAddress.toString();
            }
            return new Object[]{this.hostAddress, this.inetAddress.getPort()};
        }
    }

    private class CreateNewVirtualConnectionFactory
    implements NetworkConnectionFactoryHolder {
        private Object endPoint;
        private InetAddress epAddress;
        private int epPort;

        public CreateNewVirtualConnectionFactory(Object endPoint) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"CreateNewVirtualConnectionFactory.<init>", (Object)endPoint);
            }
            this.endPoint = endPoint;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"CreateNewVirtualConnectionFactory.<init>");
            }
        }

        @Override
        public NetworkConnectionFactory getFactory() throws FrameworkException, JFapConnectFailedException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"CreateNewVirtualConnectionFactory.getFactory");
            }
            this.endPoint = ConnectionDataGroup.this.framework.prepareOutboundConnection(this.endPoint);
            this.epAddress = ConnectionDataGroup.this.framework.getHostAddress(this.endPoint);
            this.epPort = ConnectionDataGroup.this.framework.getHostPort(this.endPoint);
            NetworkTransportFactory transportFactory = ConnectionDataGroup.this.framework.getNetworkTransportFactory();
            NetworkConnectionFactory vcFactory = transportFactory.getOutboundNetworkConnectionFactoryFromEndPoint(this.endPoint);
            if (vcFactory == null) {
                JFapConnectFailedException e = new JFapConnectFailedException(nls.getFormattedMessage("CONNDATAGROUP_CONNFAILED_SICJ0063", new Object[]{this.epAddress.getHostAddress(), "" + this.epPort}, "CONNDATAGROUP_CONNFAILED_SICJ0063"));
                FFDCFilter.processException((Throwable)((Object)e), (String)"com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup", (String)"00240004", (Object)this.endPoint);
                throw e;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"CreateNewVirtualConnectionFactory.getFactory", (Object)vcFactory);
            }
            return vcFactory;
        }

        public InetAddress getEndPointAddress() {
            return this.epAddress;
        }

        public int getEndPointPort() {
            return this.epPort;
        }
    }

    private static class ExistingNetworkConnectionFactoryHolder
    implements NetworkConnectionFactoryHolder {
        private final NetworkConnectionFactory outboundVirtualConnectionFactory;

        public ExistingNetworkConnectionFactoryHolder(NetworkConnectionFactory vcf) {
            this.outboundVirtualConnectionFactory = vcf;
        }

        @Override
        public NetworkConnectionFactory getFactory() {
            return this.outboundVirtualConnectionFactory;
        }

        public boolean isNonNull() {
            return this.outboundVirtualConnectionFactory != null;
        }
    }

    private static interface NetworkConnectionFactoryHolder {
        public NetworkConnectionFactory getFactory() throws FrameworkException, JFapConnectFailedException;
    }
}

