/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.upgrade;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http2.upgrade.H2UpgradeHandler;
import com.ibm.ws.webcontainer.servlet.H2Handler;
import com.ibm.ws.webcontainer31.upgrade.H2UpgradeHandlerWrapper;
import com.ibm.wsspi.http.HttpInboundConnection;
import com.ibm.wsspi.http.ee8.Http2InboundConnection;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class H2HandlerImpl
implements H2Handler {
    private static final TraceComponent tc = Tr.register(H2HandlerImpl.class, null);
    private static final String CONSTANT_upgrade = "upgrade";
    private static final String CONSTANT_connection = "connection";
    private static final String HTTP2_SETTINGS = "HTTP2-Settings";

    public boolean isH2Request(HttpInboundConnection hic, ServletRequest request) throws ServletException {
        if (!((Http2InboundConnection)hic).isHTTP2UpgradeRequest(null, true)) {
            return false;
        }
        HashMap<String, String> h2Headers = null;
        HttpServletRequest hsrt = (HttpServletRequest)request;
        Enumeration headerNames = hsrt.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!CONSTANT_connection.equalsIgnoreCase(headerName) && !CONSTANT_upgrade.equalsIgnoreCase(headerName)) continue;
            if (h2Headers == null) {
                h2Headers = new HashMap<String, String>();
            }
            h2Headers.put(headerName, hsrt.getHeader(headerName));
        }
        return ((Http2InboundConnection)hic).isHTTP2UpgradeRequest(h2Headers == null ? Collections.emptyMap() : h2Headers, false);
    }

    public void handleRequest(HttpInboundConnection hic, HttpServletRequest request, HttpServletResponse response) {
        String http2Settings;
        Map http2Headers;
        boolean upgraded;
        Http2InboundConnection h2ic = (Http2InboundConnection)hic;
        H2UpgradeHandlerWrapper h2uh = null;
        try {
            h2uh = (H2UpgradeHandlerWrapper)request.upgrade(H2UpgradeHandlerWrapper.class);
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("returning: user configurator threw an IOException. Exception message: " + e.getMessage()), (Object[])new Object[0]);
            }
            response.setStatus(500);
            return;
        }
        catch (ServletException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("returning: user configurator threw a ServletException. Exception message: " + e.getMessage()), (Object[])new Object[0]);
            }
            response.setStatus(500);
            return;
        }
        if (h2uh != null) {
            h2uh.init(new H2UpgradeHandler());
        }
        if (!(upgraded = h2ic.handleHTTP2UpgradeRequest(http2Headers = (http2Settings = request.getHeader(HTTP2_SETTINGS)) == null ? Collections.emptyMap() : Collections.singletonMap(HTTP2_SETTINGS, http2Settings)))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"returning: http2 connection initialization failed", (Object[])new Object[0]);
            }
            response.setStatus(500);
        }
    }
}

