/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.EncodingLevel;
import com.ibm.ws.sib.api.jms.JmsDestInternals;
import com.ibm.ws.sib.api.jms.MessageDestEncodingUtils;
import com.ibm.ws.sib.api.jms.impl.IntegerPropertyCoder;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicImpl;
import com.ibm.ws.sib.api.jms.impl.OnOffPropertyCoder;
import com.ibm.ws.sib.api.jms.impl.PhantomPropertyCoder;
import com.ibm.ws.sib.api.jms.impl.PropertyCoder;
import com.ibm.ws.sib.api.jms.impl.ReadAheadCoder;
import com.ibm.ws.sib.api.jms.impl.ShortStringPropertyCoder;
import com.ibm.ws.sib.api.jms.impl.StringPropertyCoder;
import com.ibm.ws.sib.jms.util.ArrayUtil;
import com.ibm.ws.sib.jms.util.Utf8Codec;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Topic;

public class MsgDestEncodingUtilsImpl
implements MessageDestEncodingUtils {
    private static TraceComponent tc = SibTr.register(MsgDestEncodingUtilsImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static final byte QUEUE_TYPE = 0;
    private static final byte TOPIC_TYPE = 16;
    private static final byte DM_NOT_SET = 0;
    private static final byte DM_PERSISTENT = 1;
    private static final byte DM_NON_PERSISTENT = 2;
    private static final byte DM_MASK = 15;
    private static final byte PRIORITY_NOT_SET = -16;
    private static final byte PRIORITY_MASK = -16;
    private static final byte TTL_NOT_SET = 0;
    private static final byte TTL_SET = 1;
    private static final Map<String, PropertyEntry> propertyMap = new HashMap<String, PropertyEntry>();
    private static final Map<String, String> reverseMap = new HashMap<String, String>();
    private static Map<Class<? extends JmsDestinationImpl>, Map<String, Object>> defaultJNDIProperties = new HashMap<Class<? extends JmsDestinationImpl>, Map<String, Object>>();
    private static final String PR = "pr";
    private static final int PR_INT = 1;
    private static final String DM = "dm";
    private static final int DM_INT = 2;
    private static final String TL = "tl";
    private static final int TL_INT = 3;
    private static final String RA = "ra";
    private static final int RA_INT = 4;
    private static final String TN = "tn";
    private static final int TN_INT = 5;
    private static final String TS = "ts";
    private static final int TS_INT = 6;
    private static final String QN = "qn";
    private static final int QN_INT = 7;
    private static final String QP = "qp";
    private static final int QP_INT = 8;
    private static final String PL = "pl";
    private static final int PL_INT = 9;
    private static final String PB = "pb";
    private static final int PB_INT = 10;
    private static final String GM = "gm";
    private static final int GM_INT = 11;
    private static final String BN = null;
    private static final int BN_INT = 12;
    private static final String BD = null;
    private static final int BD_INT = 13;
    private static final String DN = null;
    private static final int DN_INT = 14;
    private static final String DD = null;
    private static final int DD_INT = 15;

    @Override
    public final byte[] getMessageRepresentationFromDest(JmsDestination dest, EncodingLevel encodingLevel) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageRepresentationFromDest", (Object)new Object[]{dest, encodingLevel});
        }
        boolean isTopic = false;
        byte[] encodedDest = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (dest == null) {
            JMSException e = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_INVALID_VALUE_CWSIA0361", new Object[]{"null", "JmsDestination"}, tc);
            FFDCFilter.processException((Throwable)e, (String)"MsgDestEncodingUtilsImpl", (String)"getMessageRepresentationFromDest#1", (Object)this);
            throw e;
        }
        if (dest instanceof Topic) {
            isTopic = true;
        }
        Map<String, Object> destProps = ((JmsDestinationImpl)dest).getCopyOfProperties();
        MsgDestEncodingUtilsImpl.manipulateProperties(destProps, isTopic, encodingLevel);
        MsgDestEncodingUtilsImpl.encodeBasicProperties(baos, isTopic, destProps);
        MsgDestEncodingUtilsImpl.encodeOtherProperties(baos, destProps);
        encodedDest = baos.toByteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageRepresentationFromDest", (Object)encodedDest);
        }
        return encodedDest;
    }

    @Override
    public final JmsDestination getDestinationFromMsgRepresentation(byte[] msgForm) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationFromMsgRepresentation");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("msgForm: " + SibTr.formatBytes((byte[])msgForm)));
        }
        JmsDestinationImpl newDest = null;
        if (msgForm == null) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_INVALID_VALUE_CWSIA0361", new Object[]{"null", "getDestinationFromMsgRepresentation(byte[])"}, tc);
        }
        newDest = (msgForm[0] & 0x10) == 16 ? new JmsTopicImpl() : new JmsQueueImpl();
        int offset = MsgDestEncodingUtilsImpl.decodeBasicProperties(newDest, msgForm);
        MsgDestEncodingUtilsImpl.decodeOtherProperties(newDest, msgForm, offset);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationFromMsgRepresentation", (Object)newDest);
        }
        return newDest;
    }

    static final Object getDefaultPropertyValue(String propName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultPropertyValue", (Object)propName);
        }
        Object defaultValue = null;
        PropertyEntry prop = propertyMap.get(propName);
        if (prop != null) {
            defaultValue = prop.getDefaultValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultPropertyValue", (Object)defaultValue);
        }
        return defaultValue;
    }

    static final Class getPropertyType(String longPropertyName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPropertyType", (Object)longPropertyName);
        }
        Class propType = null;
        PropertyEntry prop = propertyMap.get(longPropertyName);
        if (prop != null) {
            propType = prop.getType();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPropertyType", (Object)propType);
        }
        return propType;
    }

    static final Object convertPropertyToType(String longPropertyName, String stringValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"convertPropertyToType", (Object)new Object[]{longPropertyName, stringValue});
        }
        Object decodedObject = stringValue;
        Class requiredType = MsgDestEncodingUtilsImpl.getPropertyType(longPropertyName);
        if (requiredType == Integer.class) {
            decodedObject = Integer.valueOf(stringValue);
        } else if (requiredType == Long.class) {
            decodedObject = Long.valueOf(stringValue);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"convertPropertyToType");
        }
        return decodedObject;
    }

    static final void setDestinationProperty(JmsDestination dest, String longName, Object longValue) throws JMSException {
        PropertyEntry propEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationProperty", (Object)new Object[]{dest, longName, longValue});
        }
        if ((propEntry = propertyMap.get(longName)) != null) {
            if (longValue != null && !longValue.getClass().equals(propEntry.getType())) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_INVALID_VALUE_CWSIA0361", new Object[]{longValue, longName}, null, "MsgDestEncodingUtilsImpl.setDestinationProperty#1", null, tc);
            }
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNKNOWN_PROPERTY_CWSIA0363", new Object[]{longName}, null, "MsgDestEncodingUtilsImpl.setDestinationProperty#2", null, tc);
        }
        MsgDestEncodingUtilsImpl.setProperty(dest, longName, propEntry.getIntValue(), longValue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MsgDestEncodingUtilsImpl.setDestinationProperty#2");
        }
    }

    static final Map<String, Object> getDefaultJNDIProperties(Class<? extends JmsDestinationImpl> clazz) {
        Map answer = defaultJNDIProperties.get(clazz);
        if (answer == null) {
            answer = Collections.EMPTY_MAP;
        }
        return answer;
    }

    private static void initializePropertyMaps() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializePropertyMap");
        }
        MsgDestEncodingUtilsImpl.addToMaps(new PhantomPropertyCoder("priority", PR), 1, Integer.class, 4, null);
        MsgDestEncodingUtilsImpl.addToMaps(new PhantomPropertyCoder("deliveryMode", DM), 2, String.class, "Application", null);
        MsgDestEncodingUtilsImpl.addToMaps(new PhantomPropertyCoder("timeToLive", TL), 3, Long.class, 0L, null);
        MsgDestEncodingUtilsImpl.addToMaps(new ReadAheadCoder("readAhead", RA), 4, String.class, "AsConnection", null);
        MsgDestEncodingUtilsImpl.addToMaps(new ShortStringPropertyCoder("topicName", TN), 5, String.class, null, null);
        MsgDestEncodingUtilsImpl.addToMaps(new ShortStringPropertyCoder("topicSpace", TS), 6, String.class, "Default.Topic.Space", null);
        MsgDestEncodingUtilsImpl.addToMaps(new ShortStringPropertyCoder("queueName", QN), 7, String.class, null, null);
        MsgDestEncodingUtilsImpl.addToMaps(new OnOffPropertyCoder("scopeToLocalQP", QP), 8, String.class, "Off", JmsQueueImpl.class);
        MsgDestEncodingUtilsImpl.addToMaps(new OnOffPropertyCoder("producerPreferLocal", PL), 9, String.class, "On", JmsQueueImpl.class);
        MsgDestEncodingUtilsImpl.addToMaps(new OnOffPropertyCoder("producerBind", PB), 10, String.class, "Off", JmsQueueImpl.class);
        MsgDestEncodingUtilsImpl.addToMaps(new OnOffPropertyCoder("gatherMessages", GM), 11, String.class, "Off", JmsQueueImpl.class);
        MsgDestEncodingUtilsImpl.addToMaps(new StringPropertyCoder("busName", BN), 12, String.class, null, null);
        MsgDestEncodingUtilsImpl.addToMaps(new IntegerPropertyCoder("blockedDestinationCode", BD), 13, Integer.class, null, null);
        MsgDestEncodingUtilsImpl.addToMaps(new StringPropertyCoder("destName", DN), 14, String.class, null, null);
        MsgDestEncodingUtilsImpl.addToMaps(new StringPropertyCoder("destDiscrim", DD), 15, String.class, null, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("propertyMap" + propertyMap));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("reverseMap" + reverseMap));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializePropertyMap");
        }
    }

    private static final void addToMaps(PropertyCoder propCoder, int intValue, Class type, Object defaultVal, Class<? extends JmsDestinationImpl> suppressIfDefaultInJNDI) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addToMaps", (Object)new Object[]{propCoder, intValue, type, defaultVal, suppressIfDefaultInJNDI});
        }
        String longName = propCoder.getLongName();
        String shortName = propCoder.getShortName();
        PropertyEntry propEntry = new PropertyEntry(intValue, type, defaultVal, propCoder);
        propertyMap.put(longName, propEntry);
        if (shortName != null) {
            reverseMap.put(shortName, longName);
        } else {
            reverseMap.put(longName, longName);
        }
        if (suppressIfDefaultInJNDI != null) {
            Map<String, Object> map = defaultJNDIProperties.get(suppressIfDefaultInJNDI);
            if (map == null) {
                map = new HashMap<String, Object>();
                defaultJNDIProperties.put(suppressIfDefaultInJNDI, map);
            }
            map.put(longName, defaultVal);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addToMaps");
        }
    }

    private static void manipulateProperties(Map<String, Object> destProps, boolean isTopic, EncodingLevel encodingLevel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"manipulateProperties", (Object)new Object[]{destProps, isTopic, encodingLevel});
        }
        destProps.remove("forwardRP");
        destProps.remove("reverseRP");
        if (encodingLevel != EncodingLevel.FULL) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Removing reply header properties from list");
            }
            destProps.remove("priority");
            destProps.remove("timeToLive");
            destProps.remove("scopeToLocalQP");
            destProps.remove("gatherMessages");
        }
        if (encodingLevel == EncodingLevel.MINIMAL) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Removing dest name properties from list");
            }
            destProps.remove("DEST_DISCRIM");
            destProps.remove("DEST_NAME");
            destProps.remove("busName");
        }
        if (isTopic) {
            Object destDiscrimObj;
            Object destNameObj = destProps.remove("DEST_NAME");
            if (destNameObj != null) {
                destProps.put("topicSpace", destNameObj);
            }
            if ((destDiscrimObj = destProps.remove("DEST_DISCRIM")) != null) {
                destProps.put("topicName", destDiscrimObj);
            }
        } else {
            Object destDiscrimObj;
            Object destNameObj = destProps.remove("DEST_NAME");
            if (destNameObj != null) {
                destProps.put("queueName", destNameObj);
            }
            if ((destDiscrimObj = destProps.remove("DEST_DISCRIM")) != null) {
                destProps.put("destDiscrim", destDiscrimObj);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"manipulateProperies", destProps);
        }
    }

    private static void encodeBasicProperties(ByteArrayOutputStream baos, boolean isTopic, Map<String, Object> destProps) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"encodeBasicProperties", (Object)new Object[]{baos, isTopic, destProps});
        }
        String dm = (String)destProps.remove("deliveryMode");
        Integer pri = (Integer)destProps.remove("priority");
        Long ttl = (Long)destProps.remove("timeToLive");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)(" isTopic=" + isTopic + " dm: " + dm + " pri: " + pri + " ttl: " + ttl));
        }
        int dmByte = 0;
        if (dm != null && !"Application".equals(dm)) {
            if ("Persistent".equals(dm)) {
                dmByte = 1;
            } else if ("NonPersistent".equals(dm)) {
                dmByte = 2;
            }
        }
        if (isTopic) {
            baos.write(0x10 | dmByte);
        } else {
            baos.write(0 | dmByte);
        }
        int priByte = -16;
        if (pri != null) {
            priByte = (byte)(pri.byteValue() << 4);
        }
        if (ttl == null) {
            baos.write(priByte | 0);
        } else {
            baos.write(priByte | 1);
            byte[] ttlBytes = new byte[8];
            ArrayUtil.writeLong((byte[])ttlBytes, (int)0, (long)ttl);
            baos.write(ttlBytes, 0, 8);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Encoded basic information: " + SibTr.formatBytes((byte[])baos.toByteArray())));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"encodeBasicProperties");
        }
    }

    private static void encodeOtherProperties(ByteArrayOutputStream baos, Map<String, Object> destProps) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"encodeOtherProperties", (Object)new Object[]{baos, destProps});
        }
        for (Map.Entry<String, Object> nextProp : destProps.entrySet()) {
            String propName = nextProp.getKey();
            Object propValue = nextProp.getValue();
            if (propValue == null || propValue.equals(MsgDestEncodingUtilsImpl.getDefaultPropertyValue(propName))) continue;
            PropertyEntry propEntry = propertyMap.get(propName);
            if (propEntry != null) {
                propEntry.getPropertyCoder().encodeProperty(baos, propValue);
                continue;
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNKNOWN_PROPERTY_CWSIA0363", new Object[]{propName}, null, "MsgDestEncodingUtilsImpl.encodeOtherProperties#1", null, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"encodeOtherProperties");
        }
    }

    private static int decodeBasicProperties(JmsDestination newDest, byte[] msgForm) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decodeBasicProperties", (Object)new Object[]{newDest, msgForm});
        }
        int offset = 0;
        byte delMode = (byte)(msgForm[0] & 0xF);
        if (delMode == 1) {
            newDest.setDeliveryMode("Persistent");
        } else if (delMode == 2) {
            newDest.setDeliveryMode("NonPersistent");
        } else {
            newDest.setDeliveryMode("Application");
        }
        byte priority = (byte)(msgForm[1] & 0xFFFFFFF0);
        if (priority != -16) {
            int pri = 0xF & priority >>> 4;
            newDest.setPriority(pri);
        }
        if ((msgForm[1] & 1) == 1) {
            long ttl = ArrayUtil.readLong((byte[])msgForm, (int)2);
            newDest.setTimeToLive(ttl);
            offset = 10;
        } else {
            offset = 2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decodeBasicProperties", (Object)offset);
        }
        return offset;
    }

    private static void decodeOtherProperties(JmsDestination newDest, byte[] msgForm, int offset) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decodeOtherProperties", (Object)new Object[]{newDest, msgForm, offset});
        }
        PropertyInputStream stream = new PropertyInputStream(msgForm, offset);
        while (stream.hasMore()) {
            String shortName = stream.readShortName();
            String longName = reverseMap.get(shortName);
            if (longName != null) {
                PropertyEntry propEntry = propertyMap.get(longName);
                Object propValue = propEntry.getPropertyCoder().decodeProperty(stream);
                MsgDestEncodingUtilsImpl.setProperty(newDest, longName, propEntry.getIntValue(), propValue);
                continue;
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNKNOWN_PROPERTY_CWSIA0363", new Object[]{shortName}, null, "MsgDestEncodingUtilsImpl.decodeOtherProperties#1", null, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decodeOtherProperties");
        }
    }

    private static void setProperty(JmsDestination dest, String longName, int propIntValue, Object value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setProperty", (Object)new Object[]{dest, longName, propIntValue, value});
        }
        switch (propIntValue) {
            case 1: {
                dest.setPriority((Integer)value);
                break;
            }
            case 2: {
                dest.setDeliveryMode((String)value);
                break;
            }
            case 3: {
                dest.setTimeToLive((Long)value);
                break;
            }
            case 4: {
                dest.setReadAhead((String)value);
                break;
            }
            case 5: {
                ((JmsTopic)dest).setTopicName((String)value);
                break;
            }
            case 6: {
                ((JmsTopic)dest).setTopicSpace((String)value);
                break;
            }
            case 7: {
                ((JmsQueue)dest).setQueueName((String)value);
                break;
            }
            case 8: {
                ((JmsQueue)dest).setScopeToLocalQP((String)value);
                break;
            }
            case 9: {
                ((JmsQueue)dest).setProducerPreferLocal((String)value);
                break;
            }
            case 10: {
                ((JmsQueue)dest).setProducerBind((String)value);
                break;
            }
            case 11: {
                ((JmsQueue)dest).setGatherMessages((String)value);
                break;
            }
            case 12: {
                dest.setBusName((String)value);
                break;
            }
            case 13: {
                ((JmsDestInternals)dest).setBlockedDestinationCode((Integer)value);
                break;
            }
            case 14: {
                ((JmsDestinationImpl)dest).setDestName((String)value);
                break;
            }
            case 15: {
                ((JmsDestinationImpl)dest).setDestDiscrim((String)value);
                break;
            }
            default: {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNKNOWN_PROPERTY_CWSIA0363", new Object[]{longName}, null, "MsgDestEncodingUtilsImpl.setProperty#1", null, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setProperty");
        }
    }

    static {
        MsgDestEncodingUtilsImpl.initializePropertyMaps();
    }

    static class PropertyInputStream {
        private static TraceComponent tc = SibTr.register(PropertyInputStream.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
        private byte[] bytes;
        private int offset;

        private PropertyInputStream(byte[] bytes, int offset) {
            this.bytes = bytes;
            this.offset = offset;
        }

        boolean hasMore() {
            return this.offset < this.bytes.length;
        }

        final String readShortName() throws JMSException {
            String shortName;
            if (this.bytes[this.offset] == 42) {
                ++this.offset;
                shortName = this.readStringValue();
            } else {
                shortName = this.readString(2);
            }
            return shortName;
        }

        final String readStringValue() throws JMSException {
            try {
                short length = ArrayUtil.readShort((byte[])this.bytes, (int)this.offset);
                this.offset += 2;
                String value = this.readString(length);
                return value;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jms.PropertyInputStream", (String)"PropertyInputStream.readStringValue#1", (Object)this, (Object[])new Object[]{this.toDebugString()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("PropertyInputStream.readStringValue#1 " + this.toDebugString()));
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"PropertyInputStream.readStringValue#1", this.offset, ""}, e, null, null, null);
            }
        }

        private String readString(int length) throws JMSException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"readString", (Object)length);
            }
            try {
                String str = Utf8Codec.decode((byte[])this.bytes, (int)this.offset, (int)length);
                this.offset += length;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"readString", (Object)str);
                }
                return str;
            }
            catch (StringIndexOutOfBoundsException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jms.PropertyInputStream", (String)"PropertyInputStream.readString#1", (Object)this, (Object[])new Object[]{this.toDebugString()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("PropertyInputStream.readString#1 " + this.toDebugString()));
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"PropertyInputStream.readString#1", this.offset, ""}, e, null, null, null);
            }
        }

        final String toDebugString() {
            StringBuilder sb = new StringBuilder();
            sb.append("offset: ");
            sb.append(this.offset);
            sb.append(" bytes: ");
            sb.append(SibTr.formatBytes((byte[])this.bytes));
            return new String(sb);
        }
    }

    private static class PropertyEntry {
        private int intValue;
        private Class type;
        private Object defaultValue;
        private PropertyCoder propCoder;
        private String debugString;

        private PropertyEntry(int aIntValue, Class aType, Object aDefault, PropertyCoder aCoder) {
            this.intValue = aIntValue;
            this.type = aType;
            this.defaultValue = aDefault;
            this.propCoder = aCoder;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("PropertyEntry.<init> " + this.toString()));
            }
        }

        private final int getIntValue() {
            return this.intValue;
        }

        private final Class getType() {
            return this.type;
        }

        private final Object getDefaultValue() {
            return this.defaultValue;
        }

        private final PropertyCoder getPropertyCoder() {
            return this.propCoder;
        }

        public final String toString() {
            if (this.debugString == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("PropertyEntry: [ ");
                sb.append(this.intValue);
                sb.append(", ");
                sb.append(this.type);
                sb.append(", ");
                sb.append(this.defaultValue);
                sb.append(", ");
                sb.append(this.propCoder);
                sb.append(" ]");
                this.debugString = new String(sb);
            }
            return this.debugString;
        }
    }
}

