/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.dispatch;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.stack.dispatch.Event;
import com.ibm.ws.sip.stack.transaction.transport.TransportCommLayerMgr;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.util.Debug;

class IncomingDataEvent
implements Event {
    private static final LogMgr s_logger = Log.get(IncomingDataEvent.class);
    private SipMessageByteBuffer m_buffer;
    private SIPConnection m_source;
    private int m_id;
    private static int s_id = 0;

    IncomingDataEvent(SipMessageByteBuffer buffer, SIPConnection source) {
        this.m_buffer = buffer;
        this.m_source = source;
        this.m_id = s_id++;
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("IncomingDataEvent [" + this.m_id + "] queued");
        }
    }

    @Override
    public void onExecute() {
        if (s_logger.isTraceDebugEnabled()) {
            int len = this.m_buffer.getMarkedBytesNumber();
            StringBuffer msg = new StringBuffer();
            msg.append("IncomingDataEvent [");
            msg.append(this.m_id);
            msg.append("] dispatched. [");
            msg.append(len);
            msg.append("] bytes received from [");
            msg.append(this.m_source == null ? "?" : this.m_source.toString());
            msg.append("]\n");
            Debug.hexDump(this.m_buffer.getBytes(), 0, len, msg);
            s_logger.traceDebug(msg.toString());
        }
        TransportCommLayerMgr.instance().onRead(this.m_buffer, this.m_source);
    }
}

