/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.context;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.stack.context.MessageContextFactory;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransaction;
import com.ibm.ws.sip.stack.transaction.transport.IBackupMessageSender;
import com.ibm.ws.sip.stack.transaction.transport.TransportCommLayerMgr;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipStreamConnectionWriteListener;
import com.ibm.ws.sip.stack.util.StackExternalizedPerformanceMgr;
import com.ibm.ws.sip.stack.util.StackTaskDurationMeasurer;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import jain.protocol.ip.sip.message.Message;
import java.io.IOException;

public abstract class MessageContext
implements TCPWriteCompletedCallback,
SipStreamConnectionWriteListener {
    private static final LogMgr s_logger = Log.get(MessageContext.class);
    protected SIPConnection sipConnection;
    protected Message sipMessage;
    protected SipMessageByteBuffer sipMessageByteBuffer;
    protected boolean naptrCalled = false;
    protected SIPTransaction sipTransaction = null;
    private IBackupMessageSender sender = null;
    private WsByteBuffer wsByteBuffer;
    private static StackExternalizedPerformanceMgr s_perfMgr = null;
    private StackTaskDurationMeasurer _sipContainerQueueDuration = null;
    private boolean m_mtuSwitch = false;
    private RuntimeException m_recycled = null;
    private static final boolean s_messageContextPoolingDebug = SIPTransactionStack.instance().getConfiguration().messageContextPoolingDebug();

    public void setSipMessage(Message sipMessage) {
        this.m_recycled = null;
        this.sipMessage = sipMessage;
    }

    public SIPConnection getSipConnection() {
        this.assertNotRecycled();
        return this.sipConnection;
    }

    public void setSipConnection(SIPConnection sipConnection) {
        this.assertNotRecycled();
        this.sipConnection = sipConnection;
    }

    public Message getSipMessage() {
        this.assertNotRecycled();
        return this.sipMessage;
    }

    public SipMessageByteBuffer getSipMessageByteBuffer() {
        this.assertNotRecycled();
        return this.sipMessageByteBuffer;
    }

    public void setSipMessageByteBuffer(SipMessageByteBuffer sipMessageByteBuffer) {
        this.assertNotRecycled();
        this.sipMessageByteBuffer = sipMessageByteBuffer;
    }

    public boolean isNaptrCalled() {
        this.assertNotRecycled();
        return this.naptrCalled;
    }

    public void setNaptrCalled(boolean naptrCalled) {
        this.assertNotRecycled();
        this.naptrCalled = naptrCalled;
    }

    public SIPTransaction getSipTransaction() {
        this.assertNotRecycled();
        return this.sipTransaction;
    }

    public void setSipTransaction(SIPTransaction sipTransaction) {
        this.assertNotRecycled();
        this.sipTransaction = sipTransaction;
    }

    public IBackupMessageSender getSender() {
        this.assertNotRecycled();
        return this.sender;
    }

    public void setSender(IBackupMessageSender sender) {
        this.assertNotRecycled();
        this.sender = sender;
    }

    public WsByteBuffer getWsByteBuffer() {
        this.assertNotRecycled();
        return this.wsByteBuffer;
    }

    public void setWsByteBuffer(WsByteBuffer wsByteBuffer) {
        this.assertNotRecycled();
        this.wsByteBuffer = wsByteBuffer;
    }

    public void transportSwitch() {
        this.m_mtuSwitch = true;
    }

    public boolean transportSwitched() {
        return this.m_mtuSwitch;
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        this.writeComplete();
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        this.assertNotRecycled();
        this.sipConnection.connectionError(ioe);
    }

    @Override
    public void writeError(Exception e2) {
        this.assertNotRecycled();
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "writeError", "an error occurred while writing message to destination: " + this.sipConnection + ". message: " + this.sipMessage, e2);
        }
        TransportCommLayerMgr transportLayer = TransportCommLayerMgr.instance();
        if (this.m_mtuSwitch) {
            transportLayer.handleMtuError(this, this.sipMessage, this.sipConnection);
        } else {
            transportLayer.onMessageSendingFailed(this);
        }
    }

    @Override
    public void writeComplete() {
        this.assertNotRecycled();
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("MessageContext - write is complete to destination: " + this.sipConnection.getRemoteHost() + ":" + this.sipConnection.getRemotePort());
        }
        this.sipConnection.writeComplete(this);
        MessageContext.doneWithContext(this);
    }

    public abstract void handleFailure();

    protected abstract void doneWithContext();

    public static void doneWithContext(MessageContext messageContext) {
        if (messageContext == null) {
            return;
        }
        messageContext.doneWithContext();
        if (s_messageContextPoolingDebug) {
            messageContext.assertNotRecycled();
            messageContext.m_recycled = new RuntimeException("recycled [" + System.identityHashCode(messageContext) + ']');
        }
        MessageContextFactory.instance().finishToUseContext(messageContext);
    }

    private void assertNotRecycled() {
        if (this.m_recycled != null) {
            IllegalStateException e2 = new IllegalStateException("recycled object access fault [" + System.identityHashCode(this) + ']');
            s_logger.traceDebug(this, "assertNotRecycled", "recycled object access fault", e2);
            if (s_messageContextPoolingDebug) {
                s_logger.traceDebug(this, "assertNotRecycled", "recycled object access fault was caused due to the following stack call", this.m_recycled);
            }
            throw e2;
        }
    }

    public void cleanItself() {
        this.sipConnection = null;
        this.sipMessage = null;
        this.sipMessageByteBuffer = null;
        this.naptrCalled = false;
        this.sipTransaction = null;
        this.sender = null;
        this.wsByteBuffer = null;
        this.m_mtuSwitch = false;
        this._sipContainerQueueDuration = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MessageContext: ");
        buf.append("class [").append(this.getClass().getName());
        buf.append("] connection [").append(this.sipConnection);
        buf.append("] transaction [").append(this.sipTransaction).append(']');
        return buf.toString();
    }

    public StackTaskDurationMeasurer getSipContainerQueueDuration() {
        return this._sipContainerQueueDuration;
    }

    public void setStackTaskDurationMeasurer(StackTaskDurationMeasurer tm) {
        this._sipContainerQueueDuration = tm;
    }
}

