/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.security.auth;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.security.auth.ThreadLocalStorage;
import java.security.MessageDigest;

public class DigestUtils {
    private static final LogMgr c_logger = Log.get(DigestUtils.class);
    private static final int BUFFER_INITIAL_SIZE = 100;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static String toHexString(byte[] b) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(null, "toHexString");
        }
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = HEX_CHARS[b[i] >> 4 & 0xF];
            c[pos++] = HEX_CHARS[b[i] & 0xF];
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "toHexString");
        }
        return new String(c);
    }

    private static byte[] digest(byte[] msg, MessageDigest digester) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(null, "digest");
        }
        digester.update(msg);
        byte[] retVa = digester.digest();
        digester.reset();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "digest");
        }
        return retVa;
    }

    private static String textDigest(String text, MessageDigest digester) {
        return DigestUtils.textDigest(text.getBytes(), digester);
    }

    private static String textDigest(byte[] textBytes, MessageDigest digester) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(null, "textDigest");
        }
        byte[] hash = DigestUtils.digest(textBytes, digester);
        String hexHash = DigestUtils.toHexString(hash);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "textDigest", hexHash);
        }
        return hexHash;
    }

    public static String createHashedA1(String user, String realm, String passwd) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "createHA1", user, realm, "*****");
        }
        StringBuffer buff = new StringBuffer(100);
        buff.append(user);
        buff.append(":");
        buff.append(realm);
        buff.append(":");
        buff.append(passwd);
        String a1 = buff.toString();
        MessageDigest digester = ThreadLocalStorage.getMessageDigest();
        String ha1 = DigestUtils.textDigest(a1, digester);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "createHA1", ha1);
        }
        return ha1;
    }

    private static String createA1MD5Sess(String ha1, String nonce, String cnonce, MessageDigest digester) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "createA1MD5Sess", ha1, nonce, cnonce, digester);
        }
        StringBuffer buff = new StringBuffer(100);
        buff.append(ha1);
        buff.append(":");
        buff.append(nonce);
        buff.append(":");
        buff.append(cnonce);
        String hexHash = buff.toString();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "createA1MD5Sess", hexHash);
        }
        return hexHash;
    }

    private static String createA2WithBody(String sipMethod, String uri, String hashedBody) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "createA2WithBody", sipMethod, uri, hashedBody);
        }
        StringBuffer buff = new StringBuffer(100);
        if (hashedBody == null) {
            hashedBody = "";
        }
        buff.append(sipMethod.toUpperCase());
        buff.append(":");
        buff.append(uri);
        buff.append(":");
        buff.append(hashedBody);
        String A2 = buff.toString();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "createA2WithBody", A2);
        }
        return A2;
    }

    private static String createA2(String method, String digestUri) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "createA2", method, digestUri);
        }
        StringBuffer buff = new StringBuffer(100);
        buff.append(method.toUpperCase());
        buff.append(":");
        buff.append(digestUri);
        String A2 = buff.toString();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "createA2", A2);
        }
        return A2;
    }

    private static String createKD(String HA1, String nonce, String nc, String cnonce, String qop, String HA2, MessageDigest digester) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "createKD", HA1, nonce, nc, cnonce, qop, HA2, digester);
        }
        StringBuffer kdBuff = new StringBuffer(100);
        kdBuff.append(HA1);
        kdBuff.append(":");
        kdBuff.append(nonce);
        if (qop != null && (qop.equals("auth") || qop.equals("auth-int"))) {
            kdBuff.append(":");
            kdBuff.append(nc);
            kdBuff.append(":");
            kdBuff.append(cnonce);
            kdBuff.append(":");
            kdBuff.append(qop);
        }
        kdBuff.append(":");
        kdBuff.append(HA2);
        String response = DigestUtils.textDigest(kdBuff.toString(), digester);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "createKD", response);
        }
        return response;
    }

    public static String createDigestFromAuthParams(String username, String realm, String password, String nonce, String qop, String nc, String cnonce, String uri, String algorithm, String sipMethod, byte[] body) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "createDigestFromAuthParams", username, realm, "*****", nonce, qop, nc, cnonce, uri, algorithm, sipMethod, body);
        }
        MessageDigest digester = ThreadLocalStorage.getMessageDigest();
        String HA1 = DigestUtils.createHashedA1(username, realm, password);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "createDigestFromAuthParams", "HA1[" + HA1 + "]");
        }
        String digest = DigestUtils.createDigestFromAuthParams(HA1, nonce, qop, nc, cnonce, uri, algorithm, sipMethod, body);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "createDigestFromAuthParams", digest);
        }
        return digest;
    }

    public static String createDigestFromAuthParams(String ha1, String nonce, String qop, String nc, String cnonce, String uri, String algorithm, String sipMethod, byte[] body) {
        boolean isAuthInt;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "createDigestFromAuthParams", ha1, nonce, qop, nc, cnonce, uri, algorithm, sipMethod, body);
        }
        MessageDigest digester = ThreadLocalStorage.getMessageDigest();
        if (algorithm != null && algorithm.equals("MD5-sess")) {
            String A1 = DigestUtils.createA1MD5Sess(ha1, nonce, cnonce, digester);
            ha1 = DigestUtils.textDigest(A1, digester);
        }
        String A2 = null;
        if (sipMethod == null) {
            sipMethod = "AUTHENTICATE";
        }
        boolean bl = isAuthInt = qop != null && qop.equals("auth-int");
        if (isAuthInt) {
            String hashedBody = DigestUtils.textDigest(body, digester);
            A2 = DigestUtils.createA2WithBody(sipMethod, uri, hashedBody);
        } else {
            A2 = DigestUtils.createA2(sipMethod, uri);
        }
        String HA2 = DigestUtils.textDigest(A2, digester);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "createDigestFromAuthParams", "A2[" + A2 + "],HA2[" + HA2 + "]");
        }
        String KD = DigestUtils.createKD(ha1, nonce, nc, cnonce, qop, HA2, digester);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "createDigestFromAuthParams", "KD[" + KD + "]");
        }
        return KD;
    }
}

