/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.appqueue.AppQueueHandler;
import com.ibm.ws.sip.container.appqueue.MessageDispatchingHandler;
import com.ibm.ws.sip.container.appqueue.NativeMessageDispatchingHandler;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.router.tasks.RequestRoutedTask;
import com.ibm.ws.sip.container.util.Queueable;
import com.ibm.ws.sip.container.was.ContextBasedQueue;
import com.ibm.ws.sip.container.was.SignalingEndOfTask;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={MessageDispatchingHandler.class}, immediate=false, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.vendor=IBM"})
public class ExecutorMessageDispatchingHandler
extends NativeMessageDispatchingHandler {
    private static final LogMgr c_logger = Log.get(ExecutorMessageDispatchingHandler.class);
    private ExecutorService executorService;

    @Activate
    protected void activate(Map<String, Object> properties) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("ExecutorMessageDispatchingHandler activated", properties);
        }
        SipPropertiesMap props = PropertiesStore.getInstance().getProperties();
        props.updateProperties(properties);
        this.start();
    }

    @Deactivate
    protected void deactivate(int reason) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("ExecutorMessageDispatchingHandler deactivated, reason=" + reason, new Object[0]);
        }
        this.stop();
    }

    @Override
    public void start() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("ExecutorMessageDispatchingHandler start");
        }
        super.start();
    }

    @Reference(policy=ReferencePolicy.STATIC)
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("ExecutorMessageDispatchingHandler setExecutorService", this.executorService);
        }
    }

    @Override
    protected void initThreadsArray() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("ExecutorMessageDispatchingHandler initThreadsArray");
        }
        super.initThreadsArray();
    }

    @Override
    protected void fillArray(int maxQsize) {
        for (int i = 0; i < s_dispatchers; ++i) {
            this._dispatchersArray[i] = new ContextBasedQueue(maxQsize, i, this);
        }
    }

    protected boolean detectNonWASenv(Queueable msg) {
        return false;
    }

    void reportHangedThread(String threadName) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry("reportHangedThread", threadName);
        }
        this.performHungThreadProcess(threadName, this._dispatchersArray);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "reportHangedThread");
        }
    }

    protected void performHungThreadProcess(String threadName, AppQueueHandler[] queue) {
        for (int i = 0; i < s_dispatchers; ++i) {
            ContextBasedQueue current = (ContextBasedQueue)queue[i];
            if (!current.reportHangedThread(threadName)) continue;
            Queueable relatedTask = current.getLastTask();
            if (relatedTask != null && relatedTask instanceof RequestRoutedTask) {
                RequestRoutedTask sipMsg = (RequestRoutedTask)relatedTask;
                String currentRunningMsgDescription = sipMsg.getRequest().getCallId();
                if (c_logger.isInfoEnabled()) {
                    c_logger.info("warn.sip.queue.hung", currentRunningMsgDescription);
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("reportHangedThread", "found a hanged queue match:" + current + " desc=" + relatedTask);
            }
            current.finishedToExecuteTask(null);
            break;
        }
    }

    public void execute(Runnable task) throws IllegalStateException, InterruptedException {
        this.executorService.execute(task);
    }

    public SignalingEndOfTask wrapTaskWithSignaling(ContextBasedQueue q, Queueable task) {
        return new SignalingEndOfTask(q, task);
    }

    @Reference(service=PerformanceMgr.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setPerformanceMgr(PerformanceMgr performanceMgr) {
        this.m_perfMgr = performanceMgr;
    }

    protected void unsetPerformanceMgr(PerformanceMgr performanceMgr) {
        if (performanceMgr == this.m_perfMgr) {
            this.m_perfMgr = null;
        }
    }
}

