/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.proxy;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.jain.protocol.ip.sip.address.AddressFactoryImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.ReasonHeaderImpl;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.protocol.OutboundProcessor;
import com.ibm.ws.sip.container.proxy.ProxyBranchImpl;
import com.ibm.ws.sip.container.proxy.ProxyParent;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.proxy.StatefulProxyBestResponse;
import com.ibm.ws.sip.container.proxy.StatefullProxy;
import com.ibm.ws.sip.container.servlets.AddressImpl;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.IncomingSipServletResponse;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.container.servlets.SipSessionSeqLog;
import com.ibm.ws.sip.container.servlets.SipURIImpl;
import com.ibm.ws.sip.container.sessions.SipTransactionUserTable;
import com.ibm.ws.sip.container.transaction.ClientTransactionListener;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.OutboundInterface;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.ws.sip.stack.properties.StackProperties;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.util.SipStackUtil;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.ContentTypeHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderFactory;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.MaxForwardsHeader;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.servlet.sip.Address;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;

abstract class BranchManager
implements ProxyParent {
    private static final LogMgr c_logger = Log.get(BranchManager.class);
    protected ArrayList<ProxyBranchImpl> _proxyBranches = new ArrayList(5);
    protected int _nextBranchToExecute = 0;
    private static Hashtable<String, String> c_notCopiedRequestHeader = new Hashtable();
    private static Hashtable<String, String> c_notCopiedResponseHeader = new Hashtable();
    protected int _activeBranchCount = 0;
    protected boolean _isRecurse = true;
    protected boolean _started = false;
    protected SipServletRequestImpl _originalReq;
    protected SipURI _pathUri = null;
    protected SipURI _recordRouteURI;
    protected StatefulProxyBestResponse _bestResponse = new StatefulProxyBestResponse();
    private String _myInfo = null;
    protected boolean _parentTimedOut = false;
    protected String _host = null;
    protected int _port = -1;
    protected String _transport;
    protected int _preferedOutBoundIfaceIdxUDP = -1;
    protected int _preferedOutBoundIfaceIdxTCP = -1;
    protected int _preferedOutBoundIfaceIdxTLS = -1;
    private static final String TLS = "TLS";
    protected boolean _isRecordRoute = false;

    protected BranchManager(SipServletRequestImpl originalReq) {
        this._originalReq = originalReq;
        this.getListeningPointParams();
    }

    protected BranchManager(SipServletRequestImpl originalReq, StatefullProxy proxy) {
        this._originalReq = originalReq;
        this._isRecurse = proxy.getRecurse();
        this.getListeningPointParams();
    }

    protected String getMyInfo() {
        if (this._myInfo == null) {
            StringBuffer buff = new StringBuffer();
            buff.append("<");
            buff.append(this);
            buff.append(">");
            this._myInfo = buff.toString();
        }
        return this._myInfo;
    }

    public void send() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "startSending", this.getMyInfo() + "sending to all branches.");
        }
        if (this.getIsParallel()) {
            this.sendToStartedURIsInParallelMode();
        } else {
            this.sendToNextURIInSequentialMode();
        }
    }

    private void sendToStartedURIsInParallelMode() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "sendToStartedURIsInParallelMode");
        }
        boolean sent = false;
        while (this._nextBranchToExecute < this._proxyBranches.size()) {
            ProxyBranchImpl branch = this._proxyBranches.get(this._nextBranchToExecute);
            if (branch.isInitial()) {
                sent |= this.sendOnTheBranch(branch);
            }
            ++this._nextBranchToExecute;
        }
        if (!sent) {
            if (this._bestResponse.getBestResponse() == null) {
                this.updateBestResponse(this.getRequestForInternalUse(), 603, null);
            }
            this.allBranchesCompleted();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "sendToStartedURIsInParallelMode");
        }
    }

    private void sendToNextURIInSequentialMode() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "sendToNextURIInSequentialMode");
        }
        if (this._activeBranchCount > 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "sendToNextURIInSequentialMode", this.getMyInfo() + "sequencial proxy mode - not sending till previous branch completes.");
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "sendToNextURIInSequentialMode");
            }
            return;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "sendToNextURIInSequentialMode", this.getMyInfo());
        }
        boolean sent = false;
        while (!sent && this._nextBranchToExecute < this._proxyBranches.size()) {
            ProxyBranchImpl branch;
            if ((branch = this._proxyBranches.get(this._nextBranchToExecute++)).isInitial()) {
                sent = this.sendOnTheBranch(branch);
            }
            if (sent || !c_logger.isTraceDebugEnabled()) continue;
            c_logger.traceDebug(this, "sendToNextURIInSequentialMode", this.getMyInfo() + "branch wasn't sent");
        }
        if (this._nextBranchToExecute == this._proxyBranches.size() && !sent) {
            if (this._bestResponse.getBestResponse() == null) {
                this.updateBestResponse(this.getRequestForInternalUse(), 603, null);
            }
            this.allBranchesCompleted();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "sendToNextURIInSequentialMode");
        }
    }

    abstract SipServletRequest getRequestForInternalUse();

    abstract int getPreferedOutboundIface(String var1);

    private int getOutboundIface(String transport) {
        IncomingSipServletRequest origRequest;
        TransactionUserWrapper tu;
        int outboundIface = this.getPreferedOutboundIface(transport);
        if (outboundIface == -1 && (tu = (origRequest = (IncomingSipServletRequest)this.getOriginalRequest()).getTransactionUser()) != null) {
            outboundIface = tu.getPreferedOutboundIface(transport);
        }
        return outboundIface;
    }

    private boolean sendOnTheBranch(ProxyBranchImpl branch) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "sendOnTheBranch", (Object)(this.getMyInfo() + "branch" + branch));
        }
        try {
            ++this._activeBranchCount;
            branch.continueAndSend();
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "sendOnTheBranch", Boolean.TRUE);
            }
            return true;
        }
        catch (IOException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "startSending", this.getMyInfo() + "IOException on branch " + branch + " try next");
            }
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.create.request", null, branch.getRequestForInternalUse());
            }
            branch.failedToSend();
            this.updateBestResponse(branch.getRequestForInternalUse(), 603, branch);
            --this._activeBranchCount;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "sendOnTheBranch", Boolean.FALSE);
            }
            return false;
        }
    }

    public List<ProxyBranch> getAllBranches() {
        if (this._proxyBranches.isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getAllBranches", this.getMyInfo() + "No ProxyBranches were created");
            }
            return null;
        }
        Vector<ProxyBranch> allBranches = new Vector<ProxyBranch>(this._proxyBranches.size());
        allBranches.addAll(this._proxyBranches);
        return allBranches;
    }

    protected List<ProxyBranch> getAllNewlyCreatedProxyBranches() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getAllNewlyCreatedProxyBranches", this.getMyInfo());
        }
        Vector<ProxyBranch> allBranches = new Vector<ProxyBranch>(3);
        for (int i = 0; i < this._proxyBranches.size(); ++i) {
            ProxyBranchImpl element = this._proxyBranches.get(i);
            if (element.isInitial()) continue;
            allBranches.add(element);
        }
        return allBranches;
    }

    public synchronized void startSending() throws IllegalStateException {
        TransactionUserWrapper tu = this._originalReq.getTransactionUser();
        tu.setIsProxying(true);
        tu.setIsRRProxying(this._isRecordRoute);
        boolean temp = false;
        for (ProxyBranchImpl pb : this._proxyBranches) {
            temp |= pb.getRecordRoute();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "startSending", "Noam: " + temp);
        }
        tu.setIsRRProxying(temp);
        this.send();
    }

    protected boolean isFinalResponse(int status) {
        return status >= 200 && status < 300 || status >= 600 && status < 700;
    }

    protected IncomingSipServletResponse generateResponse(SipServletRequest req, int errorCode) {
        IncomingSipServletResponse response;
        block5: {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "generateResponse", this.getMyInfo() + "Error - " + errorCode);
            }
            response = null;
            SipServletRequestImpl request = (SipServletRequestImpl)req;
            try {
                response = SipUtil.createResponse(errorCode, request);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.exception", "Create", null, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block5;
                c_logger.error("error.exception", "Create", null, (Throwable)e3);
            }
        }
        return response;
    }

    protected boolean areAllBranchesCompleted() {
        if (c_logger.isTraceDebugEnabled() && this._activeBranchCount < 0) {
            c_logger.traceDebug(this, "areAllBranchesCompleted", this.getMyInfo() + "Error invalid active branch count: " + this._activeBranchCount);
        }
        return this._activeBranchCount == 0 && this._started;
    }

    protected void updateBestResponse(SipServletRequest request, int errorCode, ProxyBranchImpl branch) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "updateBestResponse", request, new Integer(errorCode), branch);
        }
        if (branch.getRecurse() && errorCode >= 300 && errorCode < 400) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "updateBestResponse", this.getMyInfo() + "Not updating best response on a redirect response when proxy in recurse mode");
            }
        } else {
            IncomingSipServletResponse response = null;
            if (request.isInitial() && ((SipServletRequestImpl)request).isJSR289Application()) {
                response = this.generateResponse(request, errorCode);
                response.setIsCommited(false);
                this.associateResponseWithSipSession(response, branch);
                if (this.treat2xx6xxAsBestResponse(response.getStatus())) {
                    branch.notifyIntermediateBranchResponse(response);
                }
            }
            if (this._bestResponse.getNewPreference(errorCode) != -1) {
                if (response == null) {
                    response = this.generateResponse(request, errorCode);
                }
                this._bestResponse.updateBestResponse(response, branch);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "updateBestResponse");
        }
    }

    protected boolean treat2xx6xxAsBestResponse(int status) {
        boolean prop = PropertiesStore.getInstance().getProperties().getBoolean("treat2xx6xxAsBestResponse");
        if (prop && (status >= 200 && status < 300 || status >= 600 && status < 700)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "treat2xx6xxAsBestResponse", "got " + status + " response, not sending branch response to application");
            }
            return false;
        }
        return true;
    }

    protected void updateBestResponse(SipServletResponse response, ProxyBranchImpl branch) {
        if (c_logger.isTraceDebugEnabled()) {
            String last = null;
            SipServletResponse best = this._bestResponse.getBestResponse();
            if (null != best) {
                last = best.toString();
            }
            if (null == last) {
                last = "null";
            }
            StringBuffer buffer = new StringBuffer("best: ");
            buffer.append(last);
            buffer.append(", current: ");
            buffer.append(response.getStatus());
            c_logger.traceDebug(this, this.getMyInfo() + "updateBestResponse", buffer.toString());
        }
        if (branch.getRecurse() && response.getStatus() >= 300 && response.getStatus() < 400) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "updateBestResponse", this.getMyInfo() + "Not updating best response on a redirect response when proxy in recurse mode");
            }
        } else {
            this._bestResponse.updateBestResponse(response, branch);
            if (SipSessionSeqLog.isEnabled()) {
                int bestResponse = -1;
                SipServletResponse resp = this._bestResponse.getBestResponse();
                if (null != resp) {
                    bestResponse = resp.getStatus();
                }
                this._originalReq.getTransactionUser().logToContext(272, bestResponse);
            }
        }
    }

    protected void branchCompleted(ProxyBranchImpl branch, SipServletResponse response) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "branchCompleted", this.getMyInfo() + "completed branch " + branch + " response" + response);
        }
        this.updateBestResponse(response, branch);
        if (!branch.isVirtual()) {
            --this._activeBranchCount;
        }
        if (!this._parentTimedOut && this._nextBranchToExecute <= this._proxyBranches.size() && !this.getIsParallel()) {
            this.send();
            return;
        }
        if (this.areAllBranchesCompleted()) {
            this.allBranchesCompleted();
        }
    }

    protected OutgoingSipServletRequest proxy(OutgoingSipServletRequest request, URI uri, ClientTransactionListener listener) throws IllegalStateException, IOException {
        boolean strictRoutingApplied;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "proxy", this.getMyInfo() + " " + uri);
        }
        if (!(strictRoutingApplied = this.checkForStrictRouting(request, uri))) {
            this.checkForLooseRouting(request, uri);
        }
        SipServletRequestImpl origRequest = this._originalReq;
        SipURI rr_uri = null;
        if (this._isRecordRoute) {
            SipURL target = SipStackUtil.createTargetFromMessage(request.getRequest());
            SipURIImpl targetURI = new SipURIImpl(target);
            String targetTransport = SipUtil.getTransport(targetURI);
            SipProvider provider = request.getSipProvider();
            ListeningPoint lp = provider.getListeningPoint();
            int targetPort = lp.getPort();
            rr_uri = this.getRecordRouteURI(targetTransport, targetPort);
            this._recordRouteURI = rr_uri = this.copyParams(rr_uri);
            BranchManager.setSchemeAccordingToDestination(request, rr_uri);
            rr_uri.setParameter("ibmsid", origRequest.getTransactionUser().getId());
            rr_uri.setParameter("lr", "");
            SipURI inbound_rr_uri = null;
            SipURI receivedOnInterfaceURI = SipProxyInfo.getInstance().extractReceivedOnInterface(this._originalReq);
            if (receivedOnInterfaceURI != null) {
                receivedOnInterfaceURI = (SipURI)receivedOnInterfaceURI.clone();
                int inboundIfaceIndex = -1;
                OutboundInterface inboundIface = this.getOutboundInterface(new InetSocketAddress(receivedOnInterfaceURI.getHost(), receivedOnInterfaceURI.getPort()));
                if (inboundIface != null && SIPTransactionStack.instance().getConfiguration().getSentByHost() == null) {
                    inboundIfaceIndex = inboundIface.getOutboundInterface(receivedOnInterfaceURI.getTransportParam());
                }
                if (!SipUtil.isSameTransport(inbound_rr_uri = this.getRecordRouteURI(receivedOnInterfaceURI.getTransportParam(), receivedOnInterfaceURI.getPort(), inboundIfaceIndex), rr_uri) || !SipUtil.isSameHost(inbound_rr_uri, rr_uri)) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "proxy", "either outgoing transport is different than incoming transport or outbound interface is different than incoming interface, adding a second Record-Route header");
                    }
                    request.setProvider(target);
                    BranchManager.convertToCanonicalSipsURI(inbound_rr_uri);
                    inbound_rr_uri.setParameter("ibmsid", origRequest.getTransactionUser().getId());
                    inbound_rr_uri.setParameter("lr", "");
                    rr_uri.setParameter("ibmdrr", "");
                    inbound_rr_uri.setParameter("ibmdrr", "");
                } else {
                    inbound_rr_uri = null;
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "proxy", "received on interface is null.");
            }
            if (inbound_rr_uri != null) {
                request.pushRecordRoute(inbound_rr_uri);
            }
            request.pushRecordRoute(rr_uri);
        }
        if (this.shouldAddToPath()) {
            SipURI pathURI = this.getPathAddress(request.getTransport());
            pathURI.setParameter("lr", "");
            SipServletsFactoryImpl f = SipServletsFactoryImpl.getInstance();
            Address address = f.createAddress(pathURI);
            request.pushPath(address);
        }
        request.setProxy(this.getStatefullProxy());
        if (this.getPreferedOutboundIface(request.getTransport()) >= 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "proxy", "adding this preferred outboundIF from the proxy: " + this.getPreferedOutboundIface(request.getTransport()));
            }
            SipProxyInfo.getInstance().addPreferedOutboundHeader(request, this.getPreferedOutboundIface(request.getTransport()));
        } else if (this._originalReq.getTransactionUser() != null && this._originalReq.getTransactionUser().getPreferedOutboundIface(request.getTransport()) >= 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "proxy", "adding this preferred outboundIF from the TU: " + origRequest.getTransactionUser().getPreferedOutboundIface(request.getTransport()));
            }
            SipProxyInfo.getInstance().addPreferedOutboundHeader(request, origRequest.getTransactionUser().getPreferedOutboundIface(request.getTransport()));
        }
        OutboundProcessor outboundProcessor = OutboundProcessor.instance();
        outboundProcessor.forwardingRequest(origRequest, request, rr_uri);
        request.send(listener);
        return request;
    }

    private SipURI copyParams(SipURI rrHeader) {
        if (this._recordRouteURI == null) {
            return rrHeader;
        }
        SipURI returnUri = (SipURI)this._recordRouteURI.clone();
        returnUri.setHost(rrHeader.getHost());
        returnUri.setPort(rrHeader.getPort());
        returnUri.setTransportParam(rrHeader.getTransportParam());
        returnUri.setSecure(rrHeader.isSecure());
        return returnUri;
    }

    private boolean shouldAddToPath() {
        String h_supported;
        if (this.getAddToPathValue() && this._originalReq.getMethod().equals("REGISTER") && (h_supported = this._originalReq.getHeader("Supported")) != null) {
            if (h_supported.indexOf("path") != -1) {
                return true;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "shouldAddToPath", this.getMyInfo() + "Origianl Request doesn't support path option");
            }
        }
        return false;
    }

    abstract boolean getAddToPathValue();

    abstract Proxy getStatefullProxy();

    abstract void allBranchesCompleted();

    abstract SipURI getPathAddress(String var1);

    abstract boolean getIsParallel();

    private final void checkForLooseRouting(OutgoingSipServletRequest outReq, URI uri) {
        if (!uri.isSipURI()) {
            return;
        }
        Request jainReq = outReq.getRequest();
        try {
            NameAddressHeader bottomRoute = (NameAddressHeader)jainReq.getHeader("Route", false);
            if (bottomRoute != null && bottomRoute.getNameAddress().getAddress() instanceof SipURL) {
                SipURL routeURL = (SipURL)bottomRoute.getNameAddress().getAddress();
                SipURI reqURI = (SipURI)uri;
                String routeHost = routeURL.getHost();
                int routePort = routeURL.getPort();
                boolean routeSecure = routeURL.getScheme().equalsIgnoreCase("sips");
                if (!routeURL.hasParameter("ibmrb") && routePort == reqURI.getPort() && routeHost.equals(reqURI.getHost()) && outReq.checkIsLocalListeningPoint(routeHost, routePort, routeSecure)) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "checkForLooseRouting", this.getMyInfo() + "Removing bottom route as it matches the request uri: " + bottomRoute);
                    }
                    jainReq.removeHeader("Route", false);
                }
            }
        }
        catch (HeaderParseException e2) {
            BranchManager.logException(e2);
        }
        catch (IllegalArgumentException e3) {
            BranchManager.logException(e3);
        }
    }

    protected void timeoutAllChildBranches(boolean isTimeout) {
        for (int i = 0; i < this._proxyBranches.size(); ++i) {
            ProxyBranchImpl branch = this._proxyBranches.get(i);
            if (!branch.isActive()) continue;
            branch.proxyTimedOut(isTimeout);
            if (!this.getIsParallel()) break;
        }
    }

    private final boolean checkForStrictRouting(OutgoingSipServletRequest outReq, URI uri) {
        boolean rc = false;
        if (!uri.isSipURI()) {
            return rc;
        }
        Request jainReq = outReq.getRequest();
        try {
            NameAddressHeader topRoute = (NameAddressHeader)jainReq.getHeader("Route", true);
            if (topRoute != null && topRoute.getNameAddress().getAddress() instanceof SipURL) {
                SipURL routeURL = (SipURL)topRoute.getNameAddress().getAddress();
                SipURI reqURI = (SipURI)uri;
                if (!routeURL.hasParameter("lr") && routeURL.getPort() == reqURI.getPort() && routeURL.getHost().equals(reqURI.getHost())) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "checkForStrictRouting", this.getMyInfo() + "Removing top route as it matches the request uri: " + topRoute);
                    }
                    jainReq.removeHeader("Route", true);
                    topRoute = (NameAddressHeader)jainReq.getHeader("Route", true);
                    if (topRoute != null && topRoute.getNameAddress().getAddress() instanceof SipURL) {
                        routeURL = (SipURL)topRoute.getNameAddress().getAddress();
                        routeURL.setParameter("ibmsr", "");
                    }
                    rc = true;
                }
            }
        }
        catch (HeaderParseException e2) {
            BranchManager.logException(e2);
        }
        catch (IllegalArgumentException e3) {
            BranchManager.logException(e3);
        }
        catch (SipParseException e4) {
            BranchManager.logException(e4);
        }
        return rc;
    }

    protected ProxyBranchImpl createVirtualBranch(StatefullProxy proxy, OutgoingSipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{response.getTransactionUser().getCallId()};
            c_logger.traceEntry((Object)this, "createVirtualBranch", params);
        }
        ProxyBranchImpl branch = this.createBranch(null, false, proxy, true);
        return branch;
    }

    public ProxyBranchImpl createBranch(URI nextHop, boolean createdViaProxyTo, StatefullProxy proxy) {
        return this.createBranch(nextHop, createdViaProxyTo, proxy, false);
    }

    private ProxyBranchImpl createBranch(URI nextHop, boolean createdViaProxyTo, StatefullProxy proxy, boolean isVirtual) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{nextHop};
            c_logger.traceEntry((Object)this, "createBranch", params);
        }
        if (!(isVirtual || "sip".equals(nextHop.getScheme()) || "sips".equals(nextHop.getScheme()))) {
            throw new IllegalArgumentException("Unsupported Scheme");
        }
        ProxyBranchImpl curBranch = ThreadLocalStorage.getCurrentBranch();
        if (curBranch != null && curBranch.isCancelled()) {
            throw new IllegalStateException("Cannot create Branches on a canceled proxy branch during doBranchResponse");
        }
        if (isVirtual) {
            if (proxy.isVirtualBranchExists()) {
                throw new IllegalStateException("Virtual Branch Already exists");
            }
        } else if (this.proxyBranchExists(nextHop)) {
            throw new IllegalStateException("Duplicate Branch - Attempt to proxy message to the same URI again: " + nextHop);
        }
        ProxyBranchImpl branch = new ProxyBranchImpl(nextHop, this, proxy, createdViaProxyTo, isVirtual);
        if (isVirtual) {
            proxy.setVirtualBranch(branch);
        } else {
            this._proxyBranches.add(branch);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createBranch", this.getMyInfo() + "Branch created successfully: " + nextHop);
        }
        return branch;
    }

    private void getListeningPointParams() {
        if (this._host != null) {
            return;
        }
        SipProvider provider = this._originalReq.getSipProvider();
        ListeningPoint lp = provider.getListeningPoint();
        this._host = lp.getSentBy();
        this._port = lp.getPort();
        this._transport = ((ListeningPointImpl)lp).isSecure() ? TLS : lp.getTransport();
    }

    public SipURI getRecordRouteURI() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "getRecordRouteURI");
        }
        if (!this._isRecordRoute) {
            throw new IllegalStateException("Record-routing is not enabled");
        }
        if (null == this._recordRouteURI) {
            this._recordRouteURI = this.getRecordRouteURI(this._transport, this._port);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "getRecordRouteURI");
        }
        return this._recordRouteURI;
    }

    public SipURI getRecordRouteURI(String transport, int port) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{transport, port};
            c_logger.traceEntry((Object)this, "getRecordRouteURI", params);
        }
        if (!this._isRecordRoute) {
            throw new IllegalStateException("Record-routing is not enabled");
        }
        SipURI recordRouteURI = null;
        try {
            int outboundIface = this.getOutboundIface(transport);
            if (outboundIface != -1) {
                recordRouteURI = (SipURI)SipProxyInfo.getInstance().getOutboundInterface(outboundIface, transport).clone();
            } else {
                SipURL url = AddressFactoryImpl.createSipURL(null, null, null, this._host, port, null, null, null, transport);
                recordRouteURI = new SipURIImpl(url);
            }
        }
        catch (IllegalArgumentException e2) {
            Object[] args = new Object[]{e2};
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.create.record.route.uri", "Request", args, (Throwable)e2);
            }
        }
        catch (SipParseException e3) {
            Object[] args = new Object[]{e3};
            c_logger.error("error.create.record.route.uri", "Request", args, (Throwable)e3);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getRecordRouteURI", recordRouteURI);
        }
        return recordRouteURI;
    }

    public SipURI getRecordRouteURI(String transport, int port, int outboundIface) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{transport, port, outboundIface};
            c_logger.traceEntry((Object)this, "getRecordRouteURI", params);
        }
        if (!this._isRecordRoute) {
            throw new IllegalStateException("Record-routing is not enabled");
        }
        SipURI recordRouteURI = null;
        try {
            if (outboundIface != -1) {
                recordRouteURI = (SipURI)SipProxyInfo.getInstance().getOutboundInterface(outboundIface, transport).clone();
            } else {
                SipURL url = AddressFactoryImpl.createSipURL(null, null, null, this._host, port, null, null, null, transport);
                recordRouteURI = new SipURIImpl(url);
            }
        }
        catch (IllegalArgumentException e2) {
            Object[] args = new Object[]{e2};
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.create.record.route.uri", "Request", args, (Throwable)e2);
            }
        }
        catch (SipParseException e3) {
            Object[] args = new Object[]{e3};
            c_logger.error("error.create.record.route.uri", "Request", args, (Throwable)e3);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getRecordRouteURI", recordRouteURI);
        }
        return recordRouteURI;
    }

    public SipServletRequest getOriginalRequest() {
        return this._originalReq;
    }

    protected abstract boolean proxyBranchExists(URI var1);

    protected void associateResponseWithSipSession(SipServletResponseImpl response, ProxyBranchImpl relatedBranch) {
        SipServletRequestImpl branchRequest;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "associateResponseWithSipSession", response, relatedBranch);
        }
        if ((branchRequest = (SipServletRequestImpl)relatedBranch.getRequestForInternalUse()) == null) {
            branchRequest = (SipServletRequestImpl)relatedBranch.getOriginalRequest();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "associateResponseWithSipSession", "Using original (incoming) request related transaction user. Branch is virtual = " + relatedBranch.isVirtual());
            }
        }
        TransactionUserWrapper origTU = branchRequest.getTransactionUser();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "associateResponseWithSipSession", "Branch request related transaction user=" + origTU);
        }
        TransactionUserWrapper tu = response.getTransactionUser();
        String toTag = response.getResponse().getToHeader().getTag();
        if (tu == null) {
            if (origTU.getRemoteTag_2() != null) {
                tu = SipTransactionUserTable.getInstance().getTransactionUserInboundResponse(response.getResponse());
                if (tu == null) {
                    tu = origTU.createDerivedTU(response.getResponse(), " StatefullProxy - response with different tag received");
                    tu.setIsRRProxying(relatedBranch.getIsRecordRoute());
                    tu.addToTransactionUsersTable();
                    relatedBranch.relateTU(tu);
                    if (!relatedBranch._amIRecurseBranch && relatedBranch._mainAssociatedTu == null) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "associateResponseWithSipSession", "First Derived Session was associate with this ProxyBranch =" + origTU);
                        }
                        origTU.removeTransaction(response.getMethod());
                        relatedBranch._mainAssociatedTu = tu;
                        relatedBranch.setRemoveFromOriginalTU();
                    }
                }
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "associateResponseWithSipSession", "First response with remote tag received for this dialog");
                }
                tu = origTU;
                tu.setRemoteTag_2(toTag);
                tu.setIsRRProxying(relatedBranch.getIsRecordRoute());
                relatedBranch.relateTU(tu);
                relatedBranch._mainAssociatedTu = tu;
            }
            response.setTransactionUser(tu);
            branchRequest.setTransactionUser(tu);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "associateResponseWithSipSession", "associated tag = " + toTag + " tu = " + tu);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "associateResponseWithSipSession", this.getMyInfo() + "response was already associated with TU " + tu);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "associateResponseWithSipSession");
        }
    }

    private static void copyResponseHeaders(OutgoingSipServletResponse outgoingResponse, SipServletResponse response, IncomingSipServletRequest origRequest) {
        Response jainResponseIn = ((SipServletResponseImpl)response).getResponse();
        Response jainResponseOut = outgoingResponse.getResponse();
        jainResponseOut.removeHeaders("Record-Route");
        jainResponseOut.removeHeaders("Contact");
        jainResponseOut.removeHeaders("From");
        jainResponseOut.removeHeaders("To");
        HeaderIterator hIterator = jainResponseIn.getHeaders();
        if (hIterator != null) {
            while (hIterator.hasNext()) {
                try {
                    Header h = hIterator.next();
                    if (c_notCopiedResponseHeader.containsKey(h.getName())) continue;
                    jainResponseOut.addHeader(h, false);
                }
                catch (HeaderParseException e2) {
                    BranchManager.logException(e2);
                    break;
                }
                catch (NoSuchElementException e3) {
                    BranchManager.logException(e3);
                }
            }
        }
    }

    protected static OutgoingSipServletResponse createOutgoingResponse(IncomingSipServletRequest origRequest, SipServletResponse response) {
        AddressImpl to = (AddressImpl)response.getTo();
        String toTag = to.getTag();
        TransactionUserWrapper transactionUser = ((IncomingSipServletResponse)response).getTransactionUser();
        OutgoingSipServletResponse outgoingResponse = origRequest.createResponse(response.getStatus(), response.getReasonPhrase(), toTag, transactionUser);
        outgoingResponse.markAsProxyResponse();
        BranchManager.copyContent(outgoingResponse, response);
        BranchManager.copyResponseHeaders(outgoingResponse, response, origRequest);
        if (origRequest.getTransaction().isTerminated()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(BranchManager.class, "createOutgoingResponse", "This response will be sent directly over the SipStack.");
            }
            outgoingResponse.setShouldBeSentWithoutST(true);
        }
        return outgoingResponse;
    }

    private static void copyRequestHeaders(SipServletRequest origRequest, OutgoingSipServletRequest request) {
        HeaderIterator iterator = ((SipServletMessageImpl)((Object)origRequest)).getJainHeaders();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object[] args;
                try {
                    Header header = iterator.next();
                    if (c_notCopiedRequestHeader.containsKey(header.getName())) continue;
                    request.addHeader(header, false);
                }
                catch (HeaderParseException e2) {
                    if (!c_logger.isErrorEnabled()) break;
                    args = new Object[]{request};
                    c_logger.error("error.create.request", "Request", args, (Throwable)e2);
                    break;
                }
                catch (NoSuchElementException e3) {
                    if (!c_logger.isErrorEnabled()) continue;
                    args = new Object[]{request};
                    c_logger.error("error.create.request", "Request", args, (Throwable)e3);
                }
            }
        }
    }

    private static void copyContent(SipServletMessage destination, SipServletMessage source) {
        block9: {
            Message jainDest = ((SipServletMessageImpl)destination).getMessage();
            Message jainSrc = ((SipServletMessageImpl)source).getMessage();
            try {
                byte[] body = jainSrc.getBodyAsBytes();
                ContentTypeHeader contentType = jainSrc.getContentTypeHeader();
                if (null != body && null != contentType) {
                    jainDest.setBody(body, contentType);
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(BranchManager.class, "copyContent", "Unable to copy content: " + contentType + " " + Arrays.toString(body));
                }
            }
            catch (HeaderParseException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{source};
                    c_logger.error("error.forward.response", "Request", args, (Throwable)e2);
                }
            }
            catch (IllegalArgumentException e3) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{source};
                    c_logger.error("error.forward.response", "Request", args, (Throwable)e3);
                }
            }
            catch (SipParseException e4) {
                if (!c_logger.isErrorEnabled()) break block9;
                Object[] args = new Object[]{source};
                c_logger.error("error.forward.response", "Request", args, (Throwable)e4);
            }
        }
    }

    public static OutgoingSipServletRequest createOutgoingRequest(SipServletRequestImpl origRequest) {
        OutgoingSipServletRequest request = new OutgoingSipServletRequest(origRequest.getMethod(), origRequest.getFrom(), origRequest.getTo(), origRequest.getCallId(), origRequest.getSipProvider(), origRequest, true);
        BranchManager.copyContent(request, origRequest);
        request.setRequestURI(origRequest.getRequestURI());
        BranchManager.copyRequestHeaders(origRequest, request);
        request.setStateInfo(origRequest.getStateInfo());
        request.setDirective(SipApplicationRoutingDirective.CONTINUE);
        int maxForwards = origRequest.getMaxForwards();
        if (maxForwards < 0) {
            maxForwards = 70;
        } else if (maxForwards > 255) {
            maxForwards = 255;
        }
        request.setMaxForwards(maxForwards);
        request.setIbmClientAddress(origRequest.getIbmClientAddress());
        if (!BranchManager.decreaseMaxForwards(request)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(BranchManager.class, "createOutgoingRequest", "Message will not be created");
            }
            return null;
        }
        return request;
    }

    private static boolean decreaseMaxForwards(OutgoingSipServletRequest request) {
        boolean rc = true;
        Request jainRequest = request.getRequest();
        try {
            MaxForwardsHeader maxH = jainRequest.getMaxForwardsHeader();
            if (maxH == null) {
                maxH = BranchManager.getHeadersFactory().createMaxForwardsHeader(70);
                jainRequest.setHeader(maxH, true);
            } else if (maxH.getMaxForwards() > 0) {
                maxH.decrementMaxForwards();
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(BranchManager.class, "createOutgoingRequest", "Max forwards is 0!");
                }
                rc = false;
            }
        }
        catch (HeaderParseException e2) {
            BranchManager.logException(e2);
        }
        catch (SipParseException e3) {
            BranchManager.logException(e3);
        }
        catch (SipException e4) {
            BranchManager.logException(e4);
        }
        return rc;
    }

    private static final HeaderFactory getHeadersFactory() {
        return StackProperties.getInstance().getHeadersFactory();
    }

    public static void cancelRequest(SipServletRequest request, ProxyBranchImpl proxyBranch, List<ReasonHeaderImpl> reasons) {
        block7: {
            Object[] args;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(proxyBranch, "cancelRequest", "Request is " + request.getMethod());
            }
            OutgoingSipServletRequest cancel = (OutgoingSipServletRequest)request.createCancel();
            if (reasons != null) {
                for (ReasonHeaderImpl reason : reasons) {
                    cancel.addHeader(reason, true);
                }
            }
            cancel.setStateInfo(((SipServletRequestImpl)request).getStateInfo());
            cancel.setDirective(SipApplicationRoutingDirective.CONTINUE);
            try {
                cancel.send(proxyBranch);
            }
            catch (IOException e2) {
                if (c_logger.isErrorEnabled()) {
                    args = new Object[]{cancel};
                    c_logger.error("error.proxy.cancel.request", "Request", args, (Throwable)e2);
                }
            }
            catch (IllegalArgumentException e3) {
                if (!c_logger.isErrorEnabled()) break block7;
                args = new Object[]{cancel};
                c_logger.error("error.proxy.cancel.request", "Request", args, (Throwable)e3);
            }
        }
    }

    private static String getSchemeFromDestination(SipServletRequestImpl req) {
        Request request = req.getRequest();
        String topRouteScheme = null;
        String requestUriScheme = req.getRequestURI().getScheme();
        if ("sips".equalsIgnoreCase(requestUriScheme)) {
            return "sips";
        }
        try {
            NameAddressHeader route;
            jain.protocol.ip.sip.address.URI topRouteURI;
            Header topRoute = request.getHeader("Route", true);
            if (topRoute != null && (topRouteURI = (route = (NameAddressHeader)topRoute).getNameAddress().getAddress()) instanceof SipURL) {
                SipURL topRouteSipURL = (SipURL)topRouteURI;
                topRouteScheme = topRouteSipURL.getScheme();
            }
            if ("sips".equalsIgnoreCase(topRouteScheme)) {
                return "sips";
            }
        }
        catch (HeaderParseException e1) {
            BranchManager.logException(e1);
        }
        catch (IllegalArgumentException e2) {
            BranchManager.logException(e2);
        }
        return "sip";
    }

    private static void setSchemeAccordingToDestination(SipServletRequestImpl req, SipURI uri) {
        if ("sips".equalsIgnoreCase(BranchManager.getSchemeFromDestination(req))) {
            if ("tls".equalsIgnoreCase(uri.getTransportParam())) {
                uri.removeParameter("transport");
            }
            uri.setSecure(true);
        }
    }

    private static void convertToCanonicalSipsURI(SipURI uri) {
        String transportParam = uri.getParameter("transport");
        if ("tls".equalsIgnoreCase(transportParam)) {
            uri.removeParameter("transport");
            uri.setSecure(true);
        }
    }

    public static void logException(Exception e2) {
        if (c_logger.isErrorEnabled()) {
            c_logger.error("error.exception", "Request", null, (Throwable)e2);
        }
    }

    public OutboundInterface getOutboundInterface(InetSocketAddress address) {
        int preferedOutBoundIfaceIdxTLS;
        int preferedOutBoundIfaceIdxTCP;
        OutboundInterface outboundIf = null;
        if (address == null) {
            throw new IllegalArgumentException("Invalid address = null");
        }
        boolean isSet = false;
        int preferedOutBoundIfaceIdxUDP = SipProxyInfo.getInstance().getIndexOfIface(address, "udp");
        if (preferedOutBoundIfaceIdxUDP != -1) {
            isSet = true;
        }
        if ((preferedOutBoundIfaceIdxTCP = SipProxyInfo.getInstance().getIndexOfIface(address, "tcp")) != -1) {
            isSet = true;
        }
        if ((preferedOutBoundIfaceIdxTLS = SipProxyInfo.getInstance().getIndexOfIface(address, "tls")) != -1) {
            isSet = true;
        }
        if (isSet) {
            outboundIf = new OutboundInterface(preferedOutBoundIfaceIdxUDP, preferedOutBoundIfaceIdxTCP, preferedOutBoundIfaceIdxTLS);
        }
        return outboundIf;
    }

    static {
        c_notCopiedRequestHeader.put("To", "");
        c_notCopiedRequestHeader.put("From", "");
        c_notCopiedRequestHeader.put("Call-ID", "");
        c_notCopiedRequestHeader.put("Content-Length", "");
        c_notCopiedRequestHeader.put("CSeq", "");
        c_notCopiedRequestHeader.put("Content-Type", "");
        c_notCopiedRequestHeader.put("Max-Forwards", "");
        c_notCopiedResponseHeader.put("Call-ID", "");
        c_notCopiedResponseHeader.put("Content-Length", "");
        c_notCopiedResponseHeader.put("CSeq", "");
        c_notCopiedResponseHeader.put("Via", "");
        c_notCopiedResponseHeader.put("Content-Type", "");
        c_notCopiedResponseHeader.put("Route", "");
    }
}

