/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.IBMSipSession;
import com.ibm.ws.sip.container.SipContainerMBean;
import com.ibm.ws.sip.container.appqueue.MessageDispatcher;
import com.ibm.ws.sip.container.events.TasksInvoker;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.protocol.SipProtocolLayer;
import com.ibm.ws.sip.container.router.SipAppDescManager;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.servlets.WASXHttpSessionListener;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.was.WASHttpSessionListener;
import com.ibm.ws.sip.container.was.WASXTasksInvoker;
import com.ibm.ws.sip.container.was.WebsphereInvoker;
import com.ibm.ws.sip.security.auth.SipSecurityManager;
import jain.protocol.ip.sip.SipPeerUnavailableException;
import java.util.Iterator;
import java.util.List;

public class SipContainer {
    private static final LogMgr c_logger = Log.get(SipContainer.class);
    private static final String TCP_OUTBOUND_CHAIN_NAME = "TcpOutboundChain_0";
    private SipProtocolLayer m_msgReceiver;
    private SipRouter m_router = SipRouter.getInstance();
    private MessageDispatcher _messageDispatcher = new MessageDispatcher();
    private boolean m_enableSysHeadersModify = false;
    private static SipContainer c_sipContainer = new SipContainer();
    private SipContainerMBean m_sipContainerMBean;
    private boolean m_isUsingExternalRouter = false;
    private static TasksInvoker s_tasksInvoker = new WASXTasksInvoker();
    private static WASHttpSessionListener s_httpSessionListener = null;
    private SipSecurityManager m_securityManager = new SipSecurityManager();
    private boolean s_isInQuiesce = false;
    private boolean _isInitialized = false;

    private SipContainer() {
    }

    public synchronized void init() {
        block6: {
            if (this._isInitialized) {
                return;
            }
            WebsphereInvoker invoker = WebsphereInvoker.getInstance();
            this.getRouter().setInvoker(invoker);
            try {
                this.initialize();
                this._isInitialized = true;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipContainer init container");
                }
            }
            catch (IllegalStateException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.sip.container.initialization.failed", e2.getLocalizedMessage());
                    return;
                }
            }
            catch (SipPeerUnavailableException e3) {
                if (!c_logger.isErrorEnabled()) break block6;
                c_logger.error("error.sip.container.initialization.failed", e3.getLocalizedMessage());
                return;
            }
        }
    }

    private void initialize() throws IllegalStateException, SipPeerUnavailableException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "initialize");
        }
        this.m_msgReceiver = SipProtocolLayer.getInstance();
        this.m_msgReceiver.init();
        s_httpSessionListener = new WASXHttpSessionListener();
        if (c_logger.isInfoEnabled()) {
            c_logger.info("info.container.initialized", (Object)"Start", null);
            Object[] args = new String[]{this.getVersion()};
            c_logger.info("info.container.version", (Object)"Start", args);
        }
        this.m_sipContainerMBean = new SipContainerMBean();
        this.m_enableSysHeadersModify = PropertiesStore.getInstance().getProperties().getBoolean("enableSystemHeadersModify");
        this.m_securityManager.onContainerStarted();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "initialize", "System headers modification is enabled: " + this.m_enableSysHeadersModify);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "initialize");
        }
    }

    private void loadChannelFrameworkTcp() {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "loadChannelFrameworkTcp", "switching to system class loader from current class loader: " + currentThreadClassLoader);
        }
    }

    private String getVersion() {
        String version = "Version: 8.0";
        return version;
    }

    public void stop() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "stop");
        }
        if (this._isInitialized) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "stop", "Sip container was initialized, going to notify SipSession on passivation");
            }
            this.notifyOnSessionsPassivation();
        }
        if (null != this._messageDispatcher) {
            this._messageDispatcher.stop();
        }
        if (null != this.m_router) {
            this.m_router.stop();
        }
        if (null != this.m_msgReceiver) {
            this.m_msgReceiver.stop();
            this.m_msgReceiver = null;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(this, "stop");
        }
    }

    private void notifyOnSessionsPassivation() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "notifyOnSessionsPassivation");
        }
        List tempList = SessionRepository.getInstance().getAllTuWrappers();
        for (int i = 0; i < tempList.size(); ++i) {
            List<IBMSipSession> sipSessions = ((TransactionUserWrapper)tempList.get(i)).getAllSipSessions();
            for (int j = 0; j < sipSessions.size(); ++j) {
                SipSessionImplementation sipSession = (SipSessionImplementation)sipSessions.get(j);
                if (sipSession == null) continue;
                sipSession.notifyOnActivationOrPassivation(false);
            }
        }
        List<SipApplicationSessionImpl> appSessions = SessionRepository.getInstance().getAllAppSessions();
        for (SipApplicationSessionImpl sipApplicationSession : appSessions) {
            sipApplicationSession.notifyOnActivationOrPassivation(false);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(this, "notifyOnSessionsPassivation");
        }
    }

    public void unloadAppConfiguration(String appName) {
        this.m_router.unloadAppConfiguration(appName);
    }

    public int getNumOfRunningApplications() {
        return SipAppDescManager.getInstance().getSipAppDescs().size();
    }

    public SipAppDesc getSipApp(String name) {
        return this.m_router.getSipApp(name);
    }

    public static SipContainer getInstance() {
        return c_sipContainer;
    }

    public MessageDispatcher getMessageDispatcher() {
        return this._messageDispatcher;
    }

    public SipRouter getRouter() {
        return this.m_router;
    }

    public SipContainerMBean getMBean() {
        return this.m_sipContainerMBean;
    }

    public Iterator getListeningPoints() {
        return this.m_msgReceiver.getListeningPoints();
    }

    private static void logException(Exception e2) {
        if (c_logger.isErrorEnabled()) {
            c_logger.error("error.exception", "Request", null, (Throwable)e2);
        }
    }

    public boolean canModifySysHeaders() {
        return this.m_enableSysHeadersModify;
    }

    public boolean isUsingExternalRouter() {
        return this.m_isUsingExternalRouter;
    }

    public void setUsingExternalRouter(boolean usingExternalRouter) {
        this.m_isUsingExternalRouter = usingExternalRouter;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setUsingExternalRouter", usingExternalRouter ? "true" : "false");
        }
    }

    public static void setTasksInvoker(TasksInvoker tasksInvoker) {
        s_tasksInvoker = tasksInvoker;
    }

    public static TasksInvoker getTasksInvoker() {
        return s_tasksInvoker;
    }

    public static void setHttpSessionListener(WASHttpSessionListener listener) {
        s_httpSessionListener = listener;
    }

    public static WASHttpSessionListener getHttpSessionListener() {
        return s_httpSessionListener;
    }

    public SipSecurityManager getSecurityManager() {
        return this.m_securityManager;
    }

    public boolean isInQuiesce() {
        return this.s_isInQuiesce;
    }

    public void setQuiesceAttribute(boolean inQuiesce) {
        this.s_isInQuiesce = inQuiesce;
        if (c_logger.isInfoEnabled()) {
            if (inQuiesce) {
                c_logger.info("info.sip.container.quiesce.on", "Stop.STOP INITIATED");
            } else {
                c_logger.info("info.sip.container.quiesce.off", "Start");
            }
        }
    }
}

