/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HashUtils {
    private static final TraceComponent tc = Tr.register(HashUtils.class, null, null);
    private static String DEFAULT_ALGORITHM = "SHA-256";
    private static String DEFAULT_CHARSET = "UTF-8";
    static final long serialVersionUID = 5053324933446195904L;

    public static String digest(String input) {
        return HashUtils.digest(input, DEFAULT_ALGORITHM);
    }

    protected static String digest(String input, String algorithm) {
        return HashUtils.digest(input, algorithm, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    protected static String digest(String input, String algorithm, String charset) {
        String output = null;
        if (input != null && input.length() > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                md.update(input.getBytes(charset));
                output = Base64Coder.toString((byte[])Base64Coder.base64Encode((byte[])md.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                void nsae;
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.oauth20.util.HashUtils", (String)"57", null, (Object[])new Object[]{input, algorithm, charset});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception instanciating MessageDigest. The algorithm is " + algorithm + nsae), (Object[])new Object[0]);
                }
                throw new RuntimeException("Exception instanciating MessageDigest : " + nsae);
            }
            catch (UnsupportedEncodingException nsae) {
                void uee;
                FFDCFilter.processException((Throwable)nsae, (String)"com.ibm.ws.security.oauth20.util.HashUtils", (String)"62", null, (Object[])new Object[]{input, algorithm, charset});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception converting String object : " + uee), (Object[])new Object[0]);
                }
                throw new RuntimeException("Exception converting String object : " + uee);
            }
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    public static String encodedDigest(String code_verifier, String algorithm, String charset) {
        String output = null;
        if (code_verifier != null && code_verifier.length() > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                md.update(code_verifier.getBytes(charset));
                output = HashUtils.convertToBase64(md.digest());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                void nsae;
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.oauth20.util.HashUtils", (String)"85", null, (Object[])new Object[]{code_verifier, algorithm, charset});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception instanciating MessageDigest. The algorithm is " + algorithm + nsae), (Object[])new Object[0]);
                }
                throw new RuntimeException("Exception instantiating MessageDigest : " + nsae);
            }
            catch (UnsupportedEncodingException nsae) {
                void uee;
                FFDCFilter.processException((Throwable)nsae, (String)"com.ibm.ws.security.oauth20.util.HashUtils", (String)"90", null, (Object[])new Object[]{code_verifier, algorithm, charset});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception converting String object : " + uee), (Object[])new Object[0]);
                }
                throw new RuntimeException("Exception converting String object : " + uee);
            }
        }
        return output;
    }

    public static String convertToBase64(byte[] source) {
        return Base64.encodeBase64URLSafeString((byte[])source);
    }
}

