/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;

@NoJSR250Annotations
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyLoggingOutInterceptor
extends LoggingOutInterceptor {
    private static final Logger LOG = LogUtils.getLogger(LoggingOutInterceptor.class);
    private static final String LOG_SETUP = LoggingOutInterceptor.class.getName() + ".log-setup";
    private static final TraceComponent tc = Tr.register(LibertyLoggingOutInterceptor.class, null);
    public static final LibertyLoggingOutInterceptor INSTANCE = new LibertyLoggingOutInterceptor();
    private static boolean loggingInterceptorConfigProp = false;
    static final long serialVersionUID = -2589764592270516970L;

    public LibertyLoggingOutInterceptor(String phase) {
        super(phase);
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    public LibertyLoggingOutInterceptor() {
        this("pre-stream");
    }

    public LibertyLoggingOutInterceptor(int lim) {
        this();
        this.limit = lim;
    }

    public LibertyLoggingOutInterceptor(PrintWriter w) {
        this();
        this.writer = w;
    }

    public LibertyLoggingOutInterceptor(boolean loggingInterceptorConfigProp) {
        this();
        LibertyLoggingOutInterceptor.loggingInterceptorConfigProp = loggingInterceptorConfigProp;
    }

    public void handleMessage(Message message) throws Fault {
        boolean hasLogged;
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        Writer iowriter = (Writer)message.getContent(Writer.class);
        if (os == null && iowriter == null) {
            return;
        }
        Logger logger = this.getMessageLogger(message);
        if (tc.isDebugEnabled()) {
            boolean hasLogged2;
            if ((logger.isLoggable(Level.INFO) || this.writer != null) && !(hasLogged2 = message.containsKey((Object)LOG_SETUP))) {
                message.put((Object)LOG_SETUP, (Object)Boolean.TRUE);
                if (os != null) {
                    CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
                    if (this.threshold > 0L) {
                        newOut.setThreshold(this.threshold);
                    }
                    message.setContent(OutputStream.class, (Object)newOut);
                    newOut.registerCallback((CachedOutputStreamCallback)new LoggingCallback(logger, message, os));
                } else {
                    message.setContent(Writer.class, (Object)new LogWriter(logger, message, iowriter));
                }
            }
        } else if (loggingInterceptorConfigProp && (logger.isLoggable(Level.INFO) || this.writer != null) && !(hasLogged = message.containsKey((Object)LOG_SETUP))) {
            message.put((Object)LOG_SETUP, (Object)Boolean.TRUE);
            if (os != null) {
                CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
                if (this.threshold > 0L) {
                    newOut.setThreshold(this.threshold);
                }
                message.setContent(OutputStream.class, (Object)newOut);
                newOut.registerCallback((CachedOutputStreamCallback)new LoggingCallback(logger, message, os));
            } else {
                message.setContent(Writer.class, (Object)new LogWriter(logger, message, iowriter));
            }
        }
    }

    private LoggingMessage setupBuffer(Message message) {
        Object headers;
        String ct;
        String address;
        String httpMethod;
        String encoding;
        String id = (String)message.getExchange().get((Object)LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)LoggingMessage.ID_KEY, (Object)id);
        }
        LoggingMessage buffer = new LoggingMessage("Outbound Message\n---------------------------", id);
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get((Object)Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get((Object)"org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((address = (String)message.get((Object)Message.ENDPOINT_ADDRESS)) != null) {
            buffer.getAddress().append(address);
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        return buffer;
    }

    protected String formatLoggingMessage(LoggingMessage buffer) {
        return buffer.toString();
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void setEnableLoggingProp(boolean loggingInterceptorConfigProp) {
        LibertyLoggingOutInterceptor.loggingInterceptorConfigProp = loggingInterceptorConfigProp;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class LoggingCallback
    implements CachedOutputStreamCallback {
        private final Message message;
        private final OutputStream origStream;
        private final Logger logger;
        static final long serialVersionUID = -6321087786821749445L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public LoggingCallback(Logger logger, Message msg, OutputStream os) {
            this.logger = logger;
            this.message = msg;
            this.origStream = os;
        }

        @Trivial
        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            LoggingMessage buffer = LibertyLoggingOutInterceptor.this.setupBuffer(this.message);
            String ct = (String)this.message.get((Object)"Content-Type");
            if (!LibertyLoggingOutInterceptor.this.isShowBinaryContent() && LibertyLoggingOutInterceptor.this.isBinaryContent(ct)) {
                buffer.getMessage().append("--- Binary Content ---").append('\n');
                LibertyLoggingOutInterceptor.this.log(this.logger, LibertyLoggingOutInterceptor.this.formatLoggingMessage(buffer));
                return;
            }
            if (cos.getTempFile() == null) {
                if (cos.size() > (long)LibertyLoggingOutInterceptor.this.limit) {
                    buffer.getMessage().append("(message truncated to " + LibertyLoggingOutInterceptor.this.limit + " bytes)\n");
                }
            } else {
                buffer.getMessage().append("Outbound Message (saved to tmp file):\n");
                buffer.getMessage().append("Filename: " + cos.getTempFile().getAbsolutePath() + "\n");
                if (cos.size() > (long)LibertyLoggingOutInterceptor.this.limit) {
                    buffer.getMessage().append("(message truncated to " + LibertyLoggingOutInterceptor.this.limit + " bytes)\n");
                }
            }
            try {
                String encoding = (String)this.message.get((Object)Message.ENCODING);
                LibertyLoggingOutInterceptor.this.writePayload(buffer.getPayload(), cos, encoding, ct);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.support.LibertyLoggingOutInterceptor$LoggingCallback", (String)"270", (Object)this, (Object[])new Object[]{cos});
            }
            LibertyLoggingOutInterceptor.this.log(this.logger, LibertyLoggingOutInterceptor.this.formatLoggingMessage(buffer));
            try {
                cos.lockOutputStream();
                cos.resetOut(null, false);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.support.LibertyLoggingOutInterceptor$LoggingCallback", (String)"279", (Object)this, (Object[])new Object[]{cos});
            }
            this.message.setContent(OutputStream.class, (Object)this.origStream);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.support.LibertyLoggingOutInterceptor$LoggingCallback", LoggingCallback.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class LogWriter
    extends FilterWriter {
        StringWriter out2;
        int count;
        Logger logger;
        Message message;
        static final long serialVersionUID = 245374302647852485L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public LogWriter(Logger logger, Message message, Writer writer) {
            super(writer);
            this.logger = logger;
            this.message = message;
            if (!(writer instanceof StringWriter)) {
                this.out2 = new StringWriter();
            }
        }

        @Override
        public void write(int c) throws IOException {
            super.write(c);
            if (this.out2 != null && this.count < LibertyLoggingOutInterceptor.this.limit) {
                this.out2.write(c);
            }
            ++this.count;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            super.write(cbuf, off, len);
            if (this.out2 != null && this.count < LibertyLoggingOutInterceptor.this.limit) {
                this.out2.write(cbuf, off, len);
            }
            this.count += len;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            super.write(str, off, len);
            if (this.out2 != null && this.count < LibertyLoggingOutInterceptor.this.limit) {
                this.out2.write(str, off, len);
            }
            this.count += len;
        }

        @Override
        public void close() throws IOException {
            StringWriter w2;
            LoggingMessage buffer = LibertyLoggingOutInterceptor.this.setupBuffer(this.message);
            if (this.count >= LibertyLoggingOutInterceptor.this.limit) {
                buffer.getMessage().append("(message truncated to " + LibertyLoggingOutInterceptor.this.limit + " bytes)\n");
            }
            if ((w2 = this.out2) == null) {
                w2 = (StringWriter)this.out;
            }
            String ct = (String)this.message.get((Object)"Content-Type");
            try {
                LibertyLoggingOutInterceptor.this.writePayload(buffer.getPayload(), w2, ct);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.support.LibertyLoggingOutInterceptor$LogWriter", (String)"215", (Object)this, (Object[])new Object[0]);
            }
            LibertyLoggingOutInterceptor.this.log(this.logger, buffer.toString());
            this.message.setContent(Writer.class, (Object)this.out);
            super.close();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.support.LibertyLoggingOutInterceptor$LogWriter", LogWriter.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
        }
    }
}

