/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.StaxUtils;

@NoJSR250Annotations
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyLoggingInInterceptor
extends LoggingInInterceptor {
    public static final LibertyLoggingInInterceptor INSTANCE = new LibertyLoggingInInterceptor();
    private static final Logger LOG = LogUtils.getLogger(LoggingInInterceptor.class);
    private static final TraceComponent tc = Tr.register(LibertyLoggingInInterceptor.class, null);
    private static boolean loggingInterceptorConfigProp = false;
    static final long serialVersionUID = -189789664512445178L;

    public LibertyLoggingInInterceptor() {
        super("receive");
    }

    public LibertyLoggingInInterceptor(String phase) {
        super(phase);
    }

    public LibertyLoggingInInterceptor(String id, String phase) {
        super(id, phase);
    }

    public LibertyLoggingInInterceptor(int lim) {
        this();
        this.limit = lim;
    }

    public LibertyLoggingInInterceptor(String id, int lim) {
        this(id, "receive");
        this.limit = lim;
    }

    public LibertyLoggingInInterceptor(PrintWriter w) {
        this();
        this.writer = w;
    }

    public LibertyLoggingInInterceptor(String id, PrintWriter w) {
        this(id, "receive");
        this.writer = w;
    }

    public LibertyLoggingInInterceptor(boolean loggingInterceptorConfigProp) {
        this();
        LibertyLoggingInInterceptor.loggingInterceptorConfigProp = loggingInterceptorConfigProp;
    }

    public void handleMessage(Message message) throws Fault {
        Boolean validate = MessageUtils.isTrue((Object)message.getContextualProperty("cxf.enable.schema.validation"));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Property cxf.enable.schema.validation is set to: " + validate), (Object[])new Object[0]);
        }
        Logger logger = this.getMessageLogger(message);
        if (tc.isDebugEnabled()) {
            if (logger.isLoggable(Level.INFO) || this.writer != null) {
                this.newlogging(logger, message, validate);
            }
        } else if (loggingInterceptorConfigProp) {
            if (logger.isLoggable(Level.INFO) || this.writer != null) {
                this.newlogging(logger, message, validate);
            }
        } else if (validate.booleanValue()) {
            this.validatelogging(logger, message);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void newlogging(Logger logger, Message message, Boolean validateXml) throws Fault {
        String uri;
        Object headers;
        String ct;
        String httpMethod;
        String encoding;
        if (message.containsKey((Object)LoggingMessage.ID_KEY)) {
            return;
        }
        String id = (String)message.getExchange().get((Object)LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)LoggingMessage.ID_KEY, (Object)id);
        }
        message.put((Object)LoggingMessage.ID_KEY, (Object)id);
        LoggingMessage buffer = new LoggingMessage("Inbound Message\n----------------------------", id);
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get((Object)Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get((Object)"org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        if ((uri = (String)message.get((Object)"org.apache.cxf.request.url")) != null) {
            buffer.getAddress().append(uri);
            String query = (String)message.get((Object)Message.QUERY_STRING);
            if (query != null) {
                buffer.getAddress().append("?").append(query);
            }
        }
        if (!this.isShowBinaryContent() && this.isBinaryContent(ct)) {
            buffer.getMessage().append("--- Binary Content ---").append('\n');
            this.log(logger, buffer.toString());
            return;
        }
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (is != null) {
            CachedOutputStream bos = new CachedOutputStream();
            if (this.threshold > 0L) {
                bos.setThreshold(this.threshold);
            }
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                bos.flush();
                is.close();
                message.setContent(InputStream.class, (Object)bos.getInputStream());
                if (bos.getTempFile() != null) {
                    buffer.getMessage().append("\nMessage (saved to tmp file):\n");
                    buffer.getMessage().append("Filename: " + bos.getTempFile().getAbsolutePath() + "\n");
                }
                if (bos.size() > (long)this.limit) {
                    buffer.getMessage().append("(message truncated to " + this.limit + " bytes)\n");
                }
                this.writePayload(buffer.getPayload(), bos, encoding, ct);
                bos.close();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"191", (Object)((Object)this), (Object[])new Object[]{logger, message, validateXml});
                throw new Fault((Throwable)e);
            }
        }
        Reader reader = (Reader)message.getContent(Reader.class);
        if (reader != null) {
            try {
                BufferedReader r = new BufferedReader(reader, this.limit);
                r.mark(this.limit);
                char[] b = new char[this.limit];
                int i = r.read(b);
                buffer.getPayload().append(b, 0, i);
                r.reset();
                message.setContent(Reader.class, (Object)r);
            }
            catch (Exception r) {
                void e;
                FFDCFilter.processException((Throwable)r, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"205", (Object)((Object)this), (Object[])new Object[]{logger, message, validateXml});
                throw new Fault((Throwable)e);
            }
        }
        if (validateXml.booleanValue()) {
            ByteArrayInputStream paybais = null;
            XMLStreamReader xmlReader1 = null;
            try {
                paybais = new ByteArrayInputStream(buffer.getPayload().toString().getBytes());
                xmlReader1 = StaxUtils.createXMLStreamReader((InputStream)paybais);
                if (xmlReader1 != null) {
                    while (xmlReader1.hasNext()) {
                        xmlReader1.next();
                    }
                }
            }
            catch (Exception b) {
                try {
                    void e1;
                    FFDCFilter.processException((Throwable)b, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"226", (Object)((Object)this), (Object[])new Object[]{logger, message, validateXml});
                    if (!tc.isDebugEnabled()) throw new Fault((Throwable)e1);
                    Tr.debug((TraceComponent)tc, (String)("Exception occurred validating XML: " + e1), (Object[])new Object[0]);
                    throw new Fault((Throwable)e1);
                }
                catch (Throwable throwable) {
                    try {
                        if (xmlReader1 != null) {
                            xmlReader1.close();
                        }
                        if (paybais == null) throw throwable;
                        paybais.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"241", (Object)((Object)this), (Object[])new Object[]{logger, message, validateXml});
                    }
                    throw throwable;
                }
            }
            try {
                if (xmlReader1 != null) {
                    xmlReader1.close();
                }
                if (paybais != null) {
                    paybais.close();
                }
            }
            catch (Exception b) {
                FFDCFilter.processException((Throwable)b, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"241", (Object)((Object)this), (Object[])new Object[]{logger, message, validateXml});
            }
        }
        this.log(logger, this.formatLoggingMessage(buffer));
    }

    protected void logging(Logger logger, Message message) throws Fault {
        this.newlogging(logger, message, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void validatelogging(Logger logger, Message message) throws Fault {
        LoggingMessage buffer = new LoggingMessage("0", "1");
        String ct = (String)message.get((Object)"Content-Type");
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (!this.isShowBinaryContent() && this.isBinaryContent(ct)) {
            return;
        }
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (is != null) {
            CachedOutputStream bos = new CachedOutputStream();
            if (this.threshold > 0L) {
                bos.setThreshold(this.threshold);
            }
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                bos.flush();
                is.close();
                message.setContent(InputStream.class, (Object)bos.getInputStream());
                if (bos.getTempFile() != null) {
                    buffer.getMessage().append("\nMessage (saved to tmp file):\n");
                    buffer.getMessage().append("Filename: " + bos.getTempFile().getAbsolutePath() + "\n");
                }
                if (bos.size() > (long)this.limit) {
                    buffer.getMessage().append("(message truncated to " + this.limit + " bytes)\n");
                }
                this.writePayload(buffer.getPayload(), bos, encoding, ct);
                bos.close();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"293", (Object)((Object)this), (Object[])new Object[]{logger, message});
                throw new Fault((Throwable)e);
            }
        }
        Reader reader = (Reader)message.getContent(Reader.class);
        if (reader != null) {
            try {
                BufferedReader r = new BufferedReader(reader, this.limit);
                r.mark(this.limit);
                char[] b = new char[this.limit];
                int i = r.read(b);
                buffer.getPayload().append(b, 0, i);
                r.reset();
                message.setContent(Reader.class, (Object)r);
            }
            catch (Exception r) {
                void e;
                FFDCFilter.processException((Throwable)r, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"307", (Object)((Object)this), (Object[])new Object[]{logger, message});
                throw new Fault((Throwable)e);
            }
        }
        ByteArrayInputStream paybais = null;
        XMLStreamReader xmlReader1 = null;
        try {
            paybais = new ByteArrayInputStream(buffer.getPayload().toString().getBytes());
            xmlReader1 = StaxUtils.createXMLStreamReader((InputStream)paybais);
            if (xmlReader1 != null) {
                while (xmlReader1.hasNext()) {
                    xmlReader1.next();
                }
            }
        }
        catch (Exception b) {
            try {
                void e1;
                FFDCFilter.processException((Throwable)b, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"326", (Object)((Object)this), (Object[])new Object[]{logger, message});
                throw new Fault((Throwable)e1);
            }
            catch (Throwable throwable) {
                try {
                    if (xmlReader1 != null) {
                        xmlReader1.close();
                    }
                    if (paybais == null) throw throwable;
                    paybais.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"338", (Object)((Object)this), (Object[])new Object[]{logger, message});
                }
                throw throwable;
            }
        }
        try {
            if (xmlReader1 != null) {
                xmlReader1.close();
            }
            if (paybais == null) return;
            paybais.close();
            return;
        }
        catch (Exception b) {
            FFDCFilter.processException((Throwable)b, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"338", (Object)((Object)this), (Object[])new Object[]{logger, message});
            return;
        }
    }

    protected String formatLoggingMessage(LoggingMessage loggingMessage) {
        return loggingMessage.toString();
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void setEnableLoggingProp(boolean loggingInterceptorConfigProp) {
        LibertyLoggingInInterceptor.loggingInterceptorConfigProp = loggingInterceptorConfigProp;
    }
}

