/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.validation.ValidatorUtils;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuthFlowValidator
extends TypeValidator<OAuthFlow> {
    private static final TraceComponent tc = Tr.register(OAuthFlowValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final OAuthFlowValidator INSTANCE = new OAuthFlowValidator();
    static final long serialVersionUID = -2301556083646250793L;

    public static OAuthFlowValidator getInstance() {
        return INSTANCE;
    }

    private OAuthFlowValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, OAuthFlow t) {
        if (t != null) {
            String message;
            if (t.getAuthorizationUrl() != null && !ValidatorUtils.isValidURI(t.getAuthorizationUrl())) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"oAuthFlowInvalidURL", (Object[])new Object[]{t.getAuthorizationUrl()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("authorizationUrl"), message));
            }
            if (t.getTokenUrl() != null && !ValidatorUtils.isValidURI(t.getTokenUrl())) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"oAuthFlowInvalidURL", (Object[])new Object[]{t.getTokenUrl()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("tokenUrl"), message));
            }
            if (t.getRefreshUrl() != null && !ValidatorUtils.isValidURI(t.getRefreshUrl())) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"oAuthFlowInvalidURL", (Object[])new Object[]{t.getRefreshUrl()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("refreshUrl"), message));
            }
            ValidatorUtils.validateRequiredField(t.getScopes(), context, "scopes").ifPresent(helper::addValidationEvent);
        }
    }
}

