/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.validation.ValidatorUtils;
import org.eclipse.microprofile.openapi.models.info.License;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LicenseValidator
extends TypeValidator<License> {
    private static final TraceComponent tc = Tr.register(LicenseValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final LicenseValidator INSTANCE = new LicenseValidator();
    static final long serialVersionUID = -641512459837497736L;

    public static LicenseValidator getInstance() {
        return INSTANCE;
    }

    private LicenseValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, License t) {
        if (t != null) {
            ValidatorUtils.validateRequiredField(t.getName(), context, "name").ifPresent(helper::addValidationEvent);
            if (t.getUrl() != null && !ValidatorUtils.isValidURI(t.getUrl())) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"licenseInvalidURL", (Object[])new Object[]{t.getUrl()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }
}

