/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.rs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.SAMLResponseTAI;
import com.ibm.ws.security.saml.sso20.rs.RsSamlHandler;
import com.ibm.wsspi.security.tai.TAIResult;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SamlInboundService {
    public static final TraceComponent tc = Tr.register(SamlInboundService.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    public static final String KEY_TYPE = "type";
    public static final String TYPE = "RsSaml";
    public static final String VERSION = "v1.0";
    protected static final String KEY_SERVICE_PID = "service.pid";
    protected static final String KEY_PROVIDER_ID = "id";
    protected static final String KEY_ID = "id";
    static final long serialVersionUID = 4914438983794533129L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        SAMLResponseTAI.setActivatedInboundService(this);
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }

    /*
     * WARNING - void declaration
     */
    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest req, HttpServletResponse resp, SsoSamlService ssoSamlService) throws WebTrustAssociationFailedException {
        String requestUrl = req.getRequestURL().toString();
        if (ssoSamlService == null) {
            throw new WebTrustAssociationFailedException(SamlException.formatMessage("RS_SAML_SERVER_INTERNAL_LOG_ERROR", null, new Object[]{requestUrl, "", ""}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ssoSamlServiceId:" + ssoSamlService.getProviderId() + "\nssoSamlService:" + ssoSamlService + "\nrequestUrl:" + requestUrl + "\nheaders:" + ssoSamlService.getConfig().getHeaderName()), (Object[])new Object[0]);
        }
        try {
            return this.callRsSaml(req, resp, ssoSamlService);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.SamlInboundService", (String)"86", (Object)this, (Object[])new Object[]{req, resp, ssoSamlService});
            this.setErrorHeader(resp, 401, "invalid_token");
            throw new WebTrustAssociationFailedException(e.getMessage());
        }
    }

    public String getUserName(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<Principal> principals = subject.getPrincipals();
        Iterator<Principal> principalsIterator = principals.iterator();
        if (principalsIterator.hasNext()) {
            Principal principal = principalsIterator.next();
            return principal.getName();
        }
        return null;
    }

    TAIResult callRsSaml(HttpServletRequest req, HttpServletResponse resp, SsoSamlService ssoSamlService) throws Exception {
        RsSamlHandler rsSamlHandler = new RsSamlHandler(req, resp, ssoSamlService);
        Map<String, Object> results = rsSamlHandler.handleRequest();
        TAIResult taiResult = (TAIResult)results.get(TAIResult.class.getName());
        if (taiResult == null) {
            this.setErrorHeader(resp, 401, "invalid_token");
            return TAIResult.create((int)401);
        }
        if (taiResult.getStatus() != 200) {
            String errorMessage = (String)results.get(SamlException.class.getName());
            if (errorMessage != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" hits SamlException and error message:" + errorMessage), (Object[])new Object[0]);
                }
            } else {
                Exception e = (Exception)results.get(Exception.class.getName());
                if (e != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RsSamlHandler hits Exception and error message:" + e), (Object[])new Object[0]);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RsSamlHandler hits unknown error Results:" + results), (Object[])new Object[0]);
                }
            }
            this.setErrorHeader(resp, 401, "invalid_token");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TAIResult:" + taiResult + " \nSubject:" + taiResult.getSubject()), (Object[])new Object[0]);
        }
        return taiResult;
    }

    private void setErrorHeader(HttpServletResponse response, int status, String error) {
        response.setStatus(status);
    }
}

