/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.binding;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.Cache;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.InitialRequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.UserData;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.encryption.ChainingEncryptedKeyResolver;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.opensaml.xml.encryption.InlineEncryptedKeyResolver;
import org.opensaml.xml.encryption.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.StaticKeyInfoCredentialResolver;
import org.opensaml.xml.util.DatatypeHelper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BasicMessageContext<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject>
extends BasicSAMLMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> {
    public static final TraceComponent tc = Tr.register(BasicMessageContext.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    SsoConfig ssoConfig;
    SsoSamlService ssoService;
    IDPSSODescriptor idpSsoDescriptor;
    QName peerEntityRole;
    EntityDescriptor peerEntityMetadata;
    String inboundSAMLProtocol;
    Assertion validatedAssertion;
    Decrypter decrypter;
    String externalRelayState;
    SsoRequest samlRequest;
    HttpRequestInfo cachedRequestInfo;
    boolean bSetIDPSSODescriptor = false;
    Status logoutResponseStatus;
    String inResponseTo;
    HttpServletRequest request;
    HttpServletResponse response;
    InitialRequestUtil irUtil = new InitialRequestUtil();
    static ChainingEncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver();
    private SecurityPolicyResolver idpSecurityPolicyResolver;
    static final long serialVersionUID = 5868612116434424473L;

    public BasicMessageContext(SsoSamlService ssoService) {
        this.ssoService = ssoService;
        this.ssoConfig = ssoService.getConfig();
    }

    public BasicMessageContext(SsoSamlService ssoService, HttpServletRequest request, HttpServletResponse response) {
        this.ssoService = ssoService;
        this.ssoConfig = ssoService.getConfig();
        this.request = request;
        this.response = response;
    }

    public SsoSamlService getSsoService() {
        return this.ssoService;
    }

    public HttpServletRequest getHttpServletRequest() {
        HttpServletRequestAdapter requestAdapter = (HttpServletRequestAdapter)this.getInboundMessageTransport();
        return requestAdapter.getWrappedRequest();
    }

    public Status getSLOResponseStatus() {
        return this.logoutResponseStatus;
    }

    public void setSLOResponseStatus(Status status) {
        this.logoutResponseStatus = status;
    }

    public void setPeerEntityRole(QName role) {
        this.peerEntityRole = role;
    }

    public QName getPeerEntityRole() {
        if (this.peerEntityRole == null) {
            if (!this.bSetIDPSSODescriptor) {
                this.setIDPSSODescriptor();
            }
            if (this.idpSsoDescriptor != null) {
                this.peerEntityRole = this.idpSsoDescriptor.getElementQName();
            }
        }
        if (this.peerEntityRole == null) {
            this.peerEntityRole = IDPSSODescriptor.DEFAULT_ELEMENT_NAME;
        }
        return this.peerEntityRole;
    }

    public EntityDescriptor getPeerEntityMetadata() {
        if (!this.bSetIDPSSODescriptor) {
            this.setIDPSSODescriptor();
        }
        return this.peerEntityMetadata;
    }

    /*
     * WARNING - void declaration
     */
    void setIDPSSODescriptor() {
        block13: {
            this.bSetIDPSSODescriptor = true;
            SAMLObject samlMsg = this.getInboundSAMLMessage();
            if (samlMsg != null && (samlMsg instanceof Response || samlMsg instanceof LogoutResponse || samlMsg instanceof LogoutRequest)) {
                String issuer = null;
                if (samlMsg instanceof Response) {
                    Response samlResponse = (Response)samlMsg;
                    issuer = samlResponse.getIssuer().getValue();
                } else if (samlMsg instanceof LogoutResponse) {
                    LogoutResponse sloResponse = (LogoutResponse)samlMsg;
                    issuer = sloResponse.getIssuer().getValue();
                } else if (samlMsg instanceof LogoutRequest) {
                    LogoutRequest sloRequest = (LogoutRequest)samlMsg;
                    issuer = sloRequest.getIssuer().getValue();
                }
                MetadataProvider metadataProvider = this.getMetadataProvider();
                if (metadataProvider != null) {
                    try {
                        EntityDescriptor entityDescriptor = metadataProvider.getEntityDescriptor(issuer);
                        if (entityDescriptor == null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Can not find a valid IDP Metadata for issuer:" + issuer), (Object[])new Object[0]);
                            }
                            break block13;
                        }
                        this.peerEntityMetadata = entityDescriptor;
                        this.idpSsoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
                    }
                    catch (MetadataProviderException entityDescriptor) {
                        FFDCFilter.processException((Throwable)entityDescriptor, (String)"com.ibm.ws.security.saml.sso20.binding.BasicMessageContext", (String)"219", (Object)((Object)this), (Object[])new Object[0]);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            void e;
                            Tr.debug((TraceComponent)tc, (String)"setIDPSSODescriptor hit  MetadataProviderException", (Object[])new Object[]{e});
                        }
                        break block13;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No IdP metadata exists. Need to fall down to local trust store.", (Object[])new Object[0]);
                }
            }
        }
    }

    public void setInboundSAMLProtocol(String protocol) {
        this.inboundSAMLProtocol = DatatypeHelper.safeTrimOrNullString((String)protocol);
    }

    public String getInboundSAMLProtocol() {
        SAMLObject samlMsg;
        if (this.inboundSAMLProtocol == null && (samlMsg = this.getInboundSAMLMessage()) != null && samlMsg instanceof Response) {
            Response samlResponse = (Response)samlMsg;
            this.inboundSAMLProtocol = samlResponse.getElementQName().getNamespaceURI();
        }
        return this.inboundSAMLProtocol;
    }

    public SecurityPolicyResolver getIdpSecurityPolicyResolver() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getSecurityPolicyResolver(mc):" + this.idpSecurityPolicyResolver), (Object[])new Object[0]);
        }
        return this.idpSecurityPolicyResolver;
    }

    public void setIdpSecurityPolicyResolver(SecurityPolicyResolver resolver) {
        this.idpSecurityPolicyResolver = resolver;
    }

    public Assertion getValidatedAssertion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getValidatedAssertion(mc):" + this.validatedAssertion), (Object[])new Object[0]);
        }
        return this.validatedAssertion;
    }

    public void setValidatedAssertion(Assertion validatedAssertion) {
        this.validatedAssertion = validatedAssertion;
    }

    public UserData getUserDataIfReady() throws SamlException {
        if (this.validatedAssertion != null) {
            return new UserData(this.validatedAssertion, this.ssoService.getProviderId());
        }
        return null;
    }

    public void setDecrypter() throws SamlException {
        if (this.decrypter == null) {
            Credential decryptingCredential = RequestUtil.getDecryptingCredential(this.ssoService);
            StaticKeyInfoCredentialResolver resolver = new StaticKeyInfoCredentialResolver(decryptingCredential);
            this.decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, (EncryptedKeyResolver)encryptedKeyResolver);
            this.decrypter.setRootInNewDocument(true);
        }
    }

    public Decrypter getDecrypter() throws SamlException {
        if (this.decrypter == null) {
            this.setDecrypter();
        }
        return this.decrypter;
    }

    /*
     * WARNING - void declaration
     */
    public void setAndRemoveCachedRequestInfo(String externalRelayState, SsoRequest samlRequest) throws SamlException {
        this.externalRelayState = externalRelayState;
        this.samlRequest = samlRequest;
        if (externalRelayState != null) {
            Cache cache = this.ssoService.getAcsCookieCache(samlRequest.getProviderName());
            String cacheKey = externalRelayState.substring("sp_initial_".length());
            this.cachedRequestInfo = (HttpRequestInfo)cache.get(cacheKey);
            if (this.cachedRequestInfo == null) {
                try {
                    this.cachedRequestInfo = this.irUtil.recreateHttpRequestInfo(externalRelayState, this.request, this.response, this.ssoService);
                }
                catch (SamlException samlException) {
                    void e;
                    FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.binding.BasicMessageContext", (String)"325", (Object)((Object)this), (Object[])new Object[]{externalRelayState, samlRequest});
                    Tr.debug((TraceComponent)tc, (String)"cannot recreate HttpRequestInfo using InitialRequest cookie", (Object[])new Object[]{e});
                    throw e;
                }
                if (this.cachedRequestInfo == null) {
                    throw new SamlException("SAML20_POTENTIAL_REPLAY_ATTACK", null, new Object[]{externalRelayState});
                }
            } else {
                cache.remove((Object)cacheKey);
                this.irUtil.removeCookie(externalRelayState, this.request, this.response);
            }
        }
    }

    public void setCachedRequestInfo(HttpRequestInfo requestInfo) {
        this.cachedRequestInfo = requestInfo;
    }

    public HttpRequestInfo getCachedRequestInfo() {
        return this.cachedRequestInfo;
    }

    public String getExternalRelayState() {
        return this.externalRelayState;
    }

    public SsoConfig getSsoConfig() {
        return this.ssoConfig;
    }

    public void setInResponseTo(String id) {
        this.inResponseTo = id;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        encryptedKeyResolver.getResolverChain().add(new InlineEncryptedKeyResolver());
        encryptedKeyResolver.getResolverChain().add(new EncryptedElementTypeEncryptedKeyResolver());
        encryptedKeyResolver.getResolverChain().add(new SimpleRetrievalMethodEncryptedKeyResolver());
    }
}

