/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.servlet.event.ServletErrorEvent;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.websphere.servlet.filter.ChainedResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http2.upgrade.H2Exception;
import com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor;
import com.ibm.ws.webcontainer.servlet.IServletWrapperInternal;
import com.ibm.ws.webcontainer.srt.SRTOutputStream;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.ws.webcontainer.webapp.WebAppServletInvocationEvent;
import com.ibm.wsspi.webcontainer.IPlatformHelper;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.ServletReferenceListener;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import com.ibm.wsspi.webcontainer.util.WSServletOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class FileServletWrapper
implements IServletWrapper,
IServletWrapperInternal {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.servlet");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.servlet.FileServletWrapper";
    protected static final TraceNLS nls = TraceNLS.getTraceNLS(FileServletWrapper.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    private boolean notifyInvocationListeners = false;
    private ArrayList listeners;
    private long lasAccessedTime = -1L;
    protected WebApp context;
    protected DefaultExtensionProcessor parentProcessor;
    private ICollaboratorHelper collabHelper;
    private IWebAppSecurityCollaborator secCollab;
    private IPlatformHelper platformHelper;
    private int nServicing = 0;
    protected boolean isZip;
    private int optimizeFileServingSize;
    protected WebAppEventSource evtSource;
    private ServletEvent event;
    private boolean wrapperInitialized;
    private StringBuffer servletAndFileName = new StringBuffer();
    private boolean sessionSecurityIntegrationEnabled = false;
    private static boolean fileWrapperEvents = WCCustomProperties.FILE_WRAPPER_EVENTS;
    private static boolean fileWrapperEventsLessDetail = WCCustomProperties.FILE_WRAPPER_EVENTS_LESS_DETAIL;
    private static boolean useOriginalRequestState = WCCustomProperties.USE_ORIGINAL_REQUEST_STATE;
    private static boolean handlingRequestWithOverridenPath = WCCustomProperties.HANDLING_REQUEST_WITH_OVERRIDDEN_PATH;
    private boolean warningStatusSet = false;
    private int contentLength = -1;
    private static boolean invokeFlushAfterServiceForStaticFile = WCCustomProperties.INVOKE_FLUSH_AFTER_SERVICE_FOR_STATIC_FILE;
    private static boolean invokeFlushAfterServiceForStaticFileResponseWrapper = WCCustomProperties.INVOKE_FLUSH_AFTER_SERVICE_FOR_STATIC_FILE_RESPONSE_WRAPPER;

    public FileServletWrapper(IServletContext parent, DefaultExtensionProcessor parentProcessor) {
        this.context = (WebApp)parent;
        this.parentProcessor = parentProcessor;
        this.collabHelper = this.context.getCollaboratorHelper();
        this.secCollab = this.collabHelper.getSecurityCollaborator();
        this.sessionSecurityIntegrationEnabled = this.context.getSessionContext().getIntegrateWASSecurity();
        this.platformHelper = WebContainer.getWebContainer().getPlatformHelper();
        this.optimizeFileServingSize = parentProcessor.getOptimizeFileServingSize();
        if (fileWrapperEventsLessDetail) {
            fileWrapperEvents = true;
        }
        this.evtSource = (WebAppEventSource)this.context.getServletContextEventSource();
        boolean bl = this.notifyInvocationListeners = this.evtSource.hasServletInvocationListeners() && fileWrapperEvents;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "<init>", "FileServletWrapper created : " + this.evtSource.hasServletInvocationListeners() + ", do file servlet wrapper events->" + fileWrapperEvents + ", file servlet wrapper events with less detail ->" + fileWrapperEventsLessDetail);
        }
    }

    @Override
    public synchronized void addServletReferenceListener(ServletReferenceListener wrapper) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "destroy " + this.toString());
        }
        for (int i = 0; this.nServicing > 0 && i < WCCustomProperties.SERVLET_DESTROY_WAIT_TIME; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.FileServletWrapper.destroy", "377", this);
            }
        }
        if (this.notifyInvocationListeners) {
            this.evtSource.onServletStartDestroy(this.getServletEvent());
        }
        FileServletWrapper fileServletWrapper = this;
        synchronized (fileServletWrapper) {
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ServletReferenceListener listener = (ServletReferenceListener)this.listeners.get(i);
                    listener.invalidate();
                }
                this.listeners = null;
            }
        }
        if (this.notifyInvocationListeners) {
            this.evtSource.onServletFinishDestroy(this.getServletEvent());
            this.evtSource.onServletUnloaded(this.getServletEvent());
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "destroy");
        }
    }

    @Override
    public long getLastAccessTime() {
        return this.lasAccessedTime;
    }

    @Override
    public IServletConfig getServletConfig() {
        return null;
    }

    @Override
    public String getServletName() {
        return "File wrapper";
    }

    @Override
    public Servlet getTarget() {
        return null;
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return null;
    }

    @Override
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        WebContainerRequestState reqStateSaveRequestResponse;
        ServletRequest httpreq = null;
        if (useOriginalRequestState && (reqStateSaveRequestResponse = WebContainerRequestState.getInstance(false)) != null) {
            httpreq = (ServletRequest)reqStateSaveRequestResponse.getAttribute("unFilteredRequestObject");
        }
        if (httpreq == null) {
            httpreq = req;
        }
        IExtendedRequest wasreq = ServletUtil.unwrapRequest(httpreq);
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)wasreq.getWebAppDispatcherContext();
        this.handleRequest(req, res, dispatchContext);
    }

    /*
     * Exception decompiling
     */
    public void handleRequest(ServletRequest req, ServletResponse res, WebAppDispatcherContext dispatchContext) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getFileName() {
        return null;
    }

    @Override
    public ServletContext getServletContext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res, WebAppServletInvocationEvent evt) throws IOException, ServletException {
        WebContainerRequestState reqStateSaveFilteredRequest;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "service " + this.toString());
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest httpRequest = null;
        IExtendedRequest wasreq = null;
        if (useOriginalRequestState && (reqStateSaveFilteredRequest = WebContainerRequestState.getInstance(false)) != null) {
            httpRequest = (HttpServletRequest)reqStateSaveFilteredRequest.getAttribute("unFilteredRequestObject");
            reqStateSaveFilteredRequest.removeAttribute("unFilteredRequestObject");
            if (httpRequest != null) {
                wasreq = ServletUtil.unwrapRequest((ServletRequest)httpRequest);
            }
        }
        if (httpRequest == null) {
            wasreq = ServletUtil.unwrapRequest((ServletRequest)request);
        }
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)wasreq.getWebAppDispatcherContext();
        boolean writeResponseBody = true;
        boolean notify = this.notifyInvocationListeners && evt != null;
        long curLastAccessTime = 0L;
        long endTime = 0L;
        if (notify) {
            this.evtSource.onServletStartService(evt);
            curLastAccessTime = System.currentTimeMillis();
        }
        try {
            FileServletWrapper fileServletWrapper = this;
            synchronized (fileServletWrapper) {
                ++this.nServicing;
            }
            boolean isInclude = dispatchContext.isInclude();
            if (!isInclude) {
                writeResponseBody = this.setResponseHeaders(request, response);
            }
            if (writeResponseBody) {
                this.writeResponseToClient(request, response, wasreq);
            }
            if (notify) {
                endTime = System.currentTimeMillis();
                evt.setResponseTime(endTime - curLastAccessTime);
                this.evtSource.onServletFinishService(evt);
            }
        }
        catch (Throwable e) {
            if (notify) {
                if (endTime == 0L) {
                    endTime = System.currentTimeMillis();
                    evt.setResponseTime(endTime - curLastAccessTime);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "service", "Notify onServletFinishService : response time " + (endTime - curLastAccessTime) + " milliseconds");
                    }
                    this.evtSource.onServletFinishService(evt);
                }
                ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), "FileServletWrapper", e);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "service", "Notify onServletServiceError : " + errorEvent.toString());
                }
                this.evtSource.onServletServiceError(errorEvent);
            }
            throw new ServletException(e);
        }
        finally {
            FileServletWrapper isInclude = this;
            synchronized (isInclude) {
                --this.nServicing;
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "service");
            }
        }
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract RandomAccessFile getRandomAccessFile() throws IOException;

    protected abstract long getLastModified();

    protected int getContentLength(boolean update) {
        if (update) {
            this.contentLength = (int)this.getFileSize(update);
            return this.contentLength;
        }
        if (this.contentLength == -1) {
            this.contentLength = (int)this.getFileSize(update);
            return this.contentLength;
        }
        return this.contentLength;
    }

    protected int getContentLength() {
        return this.getContentLength(true);
    }

    protected abstract long getFileSize(boolean var1);

    private boolean setResponseHeaders(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setResponseHeaders");
        }
        resp.setDateHeader("Date", System.currentTimeMillis());
        String matchString = req.getRequestURI();
        String type = this.context.getMimeType(matchString);
        EncodingUtils.setContentTypeByCustomProperty(type, matchString, resp);
        String esiControl = this.parentProcessor.getEsiControl();
        if (esiControl != null && req.getHeader("Surrogate-Capability") != null && req.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested") == null && !resp.containsHeader("Surrogate-Control") && req.getAuthType() == null) {
            resp.addHeader("Surrogate-Control", esiControl);
        }
        long ModifiedSince = -1L;
        try {
            ModifiedSince = req.getDateHeader("If-Modified-Since");
        }
        catch (IllegalArgumentException iae) {
            ModifiedSince = -1L;
        }
        long FileModified = this.getLastModified();
        if (FileModified == 0L && !this.isAvailable()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setResponseHeaders", "isAvailable false, setting 404 status");
            }
            resp.sendError(404, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), this.servletAndFileName));
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setResponseHeaders", "file not found");
            }
            return false;
        }
        resp.setDateHeader("last-modified", FileModified);
        long systemTime = System.currentTimeMillis();
        if (ModifiedSince != -1L) {
            if (ModifiedSince / 1000L == FileModified / 1000L) {
                resp.setStatus(304);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setResponseHeaders", "file not modified");
                }
                return false;
            }
            if (WCCustomProperties.IFMODIFIEDSINCE_NEWER_THAN_FILEMODIFIED_TIMESTAMP && systemTime >= ModifiedSince && ModifiedSince > FileModified) {
                resp.setStatus(304);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setResponseHeaders", "The requested variant has not been modified. ");
                }
                return false;
            }
            if (systemTime < ModifiedSince && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setResponseHeaders", "The IfModifiedSince date is later than the server's current time so it is invalid, ignore. ");
            }
        } else {
            ServletResponse wasres = ServletUtil.unwrapResponse((ServletResponse)resp);
            if (!(wasres instanceof IExtendedResponse && ((IExtendedResponse)wasres).isOutputWritten() || this.getFileSize(true) > Integer.MAX_VALUE)) {
                resp.setContentLength(this.getContentLength());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setResponseHeaders");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResponseToClient(HttpServletRequest request, HttpServletResponse resp, IExtendedRequest wasreq) throws ServletException, IOException {
        boolean isWritten = false;
        boolean rethrowIOException = false;
        try {
            ServletOutputStream os = resp.getOutputStream();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "writeResponseToClient", "optimizeFileServingSize->" + this.optimizeFileServingSize + " contentLength->" + this.getContentLength(false) + ", fileSize->" + this.getFileSize(false) + ", isZip->" + this.isZip);
            }
            if (!this.isZip && os instanceof WSServletOutputStream) {
                WSServletOutputStream wsos = (WSServletOutputStream)os;
                int bufferSize = wsos.getBufferSize();
                int totalWritten = ((WSServletOutputStream)os).getTotal();
                long fileSize = this.getFileSize(false);
                RandomAccessFile raf = null;
                AbstractInterruptibleChannel channel = null;
                try {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "writeResponseToClient", "totalWritten->" + totalWritten + " bufferSize->" + bufferSize + ", actual file size->" + fileSize + ", isTransferToOS->" + this.platformHelper.isTransferToOS());
                    }
                    if (totalWritten == 0 && (long)bufferSize < fileSize && bufferSize == 4096 && this.optimizeFileServingSize != -1 && fileSize >= (long)this.optimizeFileServingSize && this.platformHelper.isTransferToOS() && request.getProtocol().equalsIgnoreCase("http")) {
                        WebAppDispatcherContext dispatchCtx = (WebAppDispatcherContext)wasreq.getWebAppDispatcherContext();
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "writeResponseToClient", "isInclude->" + dispatchCtx.isInclude() + " isForward->" + dispatchCtx.isForward());
                        }
                        if (!dispatchCtx.isInclude() && this.getRandomAccessFile() != null) {
                            raf = this.getRandomAccessFile();
                            channel = raf.getChannel();
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "writeResponseToClient", "writing using File Channel Byte Buffer Wrapper");
                            }
                            isWritten = true;
                            ((SRTOutputStream)os).write((FileChannel)channel);
                        }
                    }
                }
                finally {
                    if (channel != null) {
                        channel.close();
                    }
                    if (raf != null) {
                        raf.close();
                    }
                }
            }
            if (!isWritten) {
                isWritten = true;
                rethrowIOException = true;
                this.writeByBytes(resp, os);
            }
        }
        catch (IllegalStateException isEx) {
            if (!isWritten) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "writeResponseToClient", "going to try to use the response writer");
                }
                isWritten = true;
                this.writeByBytes(resp, null);
            } else {
                FFDCWrapper.processException(isEx, "com.ibm.ws.webcontainer.servlet.FileServletWrapper.writeResponseToClient", "689", this);
            }
        }
        catch (IOException ioexp) {
            if (ioexp.getCause() instanceof H2Exception) {
                return;
            }
            if (rethrowIOException) {
                throw ioexp;
            }
            FFDCWrapper.processException(ioexp, "com.ibm.ws.webcontainer.servlet.FileServletWrapper.writeResponseToClient", "304", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeByBytes(HttpServletResponse resp, ServletOutputStream os) throws IOException {
        block13: {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "writeByBytes", "resp->" + resp + " os->" + os);
            }
            try (InputStream in = null;){
                in = this.getInputStream();
                if (os != null) {
                    int bufferSize = this.parentProcessor.getDefaultBufferSize();
                    if (in instanceof FileInputStream) {
                        FileChannel channel = ((FileInputStream)in).getChannel();
                        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
                        int readSize = channel.read(buffer);
                        while (readSize != -1) {
                            os.write(buffer.array(), 0, readSize);
                            readSize = channel.read(buffer);
                            buffer.flip();
                        }
                        channel.close();
                    } else {
                        byte[] buf = new byte[bufferSize];
                        int readSize = in.read(buf);
                        while (readSize != -1) {
                            os.write(buf, 0, readSize);
                            readSize = in.read(buf);
                        }
                    }
                    break block13;
                }
                PrintWriter writer = resp.getWriter();
                char[] buf = new char[this.parentProcessor.getDefaultBufferSize()];
                InputStreamReader isIn = new InputStreamReader(in, resp.getCharacterEncoding());
                int numRead = isIn.read(buf);
                try {
                    while (numRead != -1) {
                        writer.write(buf, 0, numRead);
                        numRead = isIn.read(buf);
                    }
                }
                catch (IOException ioex) {
                    FFDCWrapper.processException(ioex, "com.ibm.ws.webcontainer.servlet.FileServletWrapper.writeByBytes", "298", this);
                }
            }
        }
    }

    @Override
    public void initialize(IServletConfig config) throws Exception {
        if (!this.wrapperInitialized && this.notifyInvocationListeners) {
            this.wrapperInitialized = true;
            this.evtSource.onServletStartInit(this.getServletEvent());
            this.evtSource.onServletFinishInit(this.getServletEvent());
            this.evtSource.onServletAvailableForService(this.getServletEvent());
        }
    }

    @Override
    public void prepareForReload() {
    }

    @Override
    public void setTarget(Servlet target) {
    }

    @Override
    public void setTargetClassLoader(ClassLoader loader) {
    }

    private IServletWrapper getMimeFilterWrapper(String mimeType) {
        try {
            if (mimeType.indexOf(";") != -1) {
                mimeType = mimeType.substring(0, mimeType.indexOf(";"));
            }
            return this.context.getMimeFilterWrapper(mimeType);
        }
        catch (ServletException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.servlet.FileServletWrapper.getMimeFilterWrapper", (String)"834", (Object)this);
            this.context.logError("Failed to load filter for mime-type: " + mimeType, e);
            return null;
        }
    }

    private void transferHeadersFromPrevChainedResp(ChainedResponse current, ChainedResponse previous) {
        Collection headers = previous.getHeaderNames();
        for (String name : headers) {
            String value = previous.getHeader(name);
            current.setHeader(name, value);
        }
        Cookie[] theCookies = previous.getCookies();
        for (int i = 0; i < theCookies.length; ++i) {
            Cookie currCookie = theCookies[i];
            current.addCookie(currCookie);
        }
    }

    @Override
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        WebAppServletInvocationEvent evt = null;
        if (this.notifyInvocationListeners) {
            evt = new WebAppServletInvocationEvent(this, this.getServletContext(), this.getServletAndFileName(), this.getFileName(), (ServletRequest)((HttpServletRequest)request), (ServletResponse)((HttpServletResponse)response));
        }
        this.service(request, response, evt);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    private ServletEvent getServletEvent() {
        if (this.event == null) {
            this.event = new ServletEvent(this, this.getServletContext(), this.getServletAndFileName(), this.getFileName());
        }
        return this.event;
    }

    private String getServletAndFileName() {
        if (!fileWrapperEventsLessDetail && this.servletAndFileName.length() > 0) {
            return this.servletAndFileName.toString();
        }
        return this.getServletName();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public void loadOnStartupCheck() throws Exception {
    }

    @Override
    public void load() throws Exception {
    }

    @Override
    public void modifyTarget(Servlet s) {
    }

    @Override
    public boolean hitWarningStatus() {
        if (!this.warningStatusSet) {
            this.warningStatusSet = true;
            return true;
        }
        return false;
    }
}

