/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.context;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import graphql.ExecutionInput;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.SelectedField;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.context.DataFetchingNotActiveException;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SmallRyeContext
implements Context {
    private static Schema schema;
    private static final ThreadLocal<SmallRyeContext> current;
    private final Parser parser = new Parser();
    private final JsonObject jsonObject;
    private DataFetchingEnvironment dfe;
    private ExecutionInput executionInput;
    private volatile Supplier<Document> documentSupplier;
    private Field field;
    private static final JsonBuilderFactory jsonbuilder;
    static final long serialVersionUID = 4764186904473223222L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void register(JsonObject jsonInput) {
        SmallRyeContext registry = new SmallRyeContext(jsonInput);
        current.set(registry);
    }

    public static void setSchema(Schema schema) {
        SmallRyeContext.schema = schema;
    }

    public static Context getContext() {
        return current.get();
    }

    public static void setDataFromExecution(ExecutionInput executionInput) {
        SmallRyeContext context = current.get();
        if (context != null) {
            context.setExecutionInput(executionInput);
        }
    }

    public static void setDataFromFetcher(DataFetchingEnvironment dfe, Field field) {
        SmallRyeContext context = current.get();
        if (context != null) {
            context.dfe = dfe;
            context.field = field;
        }
    }

    public static void remove() {
        current.remove();
    }

    @Override
    public JsonObject getRequest() {
        return this.jsonObject;
    }

    @Override
    public <T> T unwrap(Class<T> wrappedType) {
        if (wrappedType.equals(DataFetchingEnvironment.class)) {
            return (T)this.dfe;
        }
        if (wrappedType.equals(ExecutionInput.class)) {
            return (T)this.executionInput;
        }
        throw SmallRyeGraphQLServerMessages.msg.unsupportedWrappedClass(wrappedType.getName());
    }

    @Override
    public boolean hasArgument(String name) {
        if (this.dfe != null) {
            return this.dfe.containsArgument(name);
        }
        throw new DataFetchingNotActiveException();
    }

    @Override
    public <T> T getArgument(String name) {
        if (this.dfe != null) {
            return (T)this.dfe.getArgument(name);
        }
        throw new DataFetchingNotActiveException();
    }

    @Override
    public Map<String, Object> getArguments() {
        if (this.dfe != null) {
            return this.dfe.getArguments();
        }
        throw new DataFetchingNotActiveException();
    }

    @Override
    public String getPath() {
        if (this.dfe != null) {
            return this.dfe.getExecutionStepInfo().getPath().toString();
        }
        throw new DataFetchingNotActiveException();
    }

    @Override
    public String getExecutionId() {
        if (this.dfe != null) {
            return this.dfe.getExecutionId().toString();
        }
        if (this.executionInput != null) {
            return this.executionInput.getExecutionId().toString();
        }
        throw new DataFetchingNotActiveException();
    }

    @Override
    public String getFieldName() {
        if (this.dfe != null) {
            return this.dfe.getField().getName();
        }
        throw new DataFetchingNotActiveException();
    }

    @Override
    public <T> T getSource() {
        if (this.dfe != null) {
            return (T)this.dfe.getSource();
        }
        throw new DataFetchingNotActiveException();
    }

    @Override
    public JsonArray getSelectedFields(boolean includeSourceFields) {
        if (this.dfe != null) {
            DataFetchingFieldSelectionSet selectionSet = this.dfe.getSelectionSet();
            List fields = selectionSet.getFields();
            return this.toJsonArrayBuilder(fields, includeSourceFields).build();
        }
        throw new DataFetchingNotActiveException();
    }

    @Override
    public Context.OperationType getOperationType() {
        if (this.dfe != null) {
            return this.getOperationTypeFromDefinition(this.dfe.getOperationDefinition(), this.dfe.getSource());
        }
        throw new DataFetchingNotActiveException();
    }

    @Override
    public List<Context.OperationType> getRequestedOperationTypes() {
        ArrayList<Context.OperationType> allRequestedTypes = new ArrayList<Context.OperationType>();
        if (this.documentSupplier != null) {
            Document document = this.documentSupplier.get();
            this.documentSupplier = () -> document;
            List definitions = document.getDefinitionsOfType(OperationDefinition.class);
            for (OperationDefinition definition : definitions) {
                Context.OperationType operationType = this.getOperationTypeFromDefinition(definition);
                if (allRequestedTypes.contains((Object)operationType)) continue;
                allRequestedTypes.add(operationType);
            }
        }
        return allRequestedTypes;
    }

    @Override
    public Optional<String> getParentTypeName() {
        if (this.dfe != null) {
            return this.getName(this.dfe.getParentType());
        }
        return Optional.empty();
    }

    private Optional<String> getName(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLNamedType) {
            return Optional.of(((GraphQLNamedType)graphQLType).getName());
        }
        if (graphQLType instanceof GraphQLNonNull) {
            return this.getName(((GraphQLNonNull)graphQLType).getWrappedType());
        }
        if (graphQLType instanceof GraphQLList) {
            return this.getName(((GraphQLList)graphQLType).getWrappedType());
        }
        return Optional.empty();
    }

    private <T> Context.OperationType getOperationTypeFromDefinition(OperationDefinition definition) {
        return this.getOperationTypeFromDefinition(definition, null);
    }

    private <T> Context.OperationType getOperationTypeFromDefinition(OperationDefinition definition, T source) {
        if (definition.getOperation().equals((Object)OperationDefinition.Operation.MUTATION)) {
            return Context.OperationType.Mutation;
        }
        if (definition.getOperation().equals((Object)OperationDefinition.Operation.SUBSCRIPTION)) {
            return Context.OperationType.Subscription;
        }
        if (definition.getOperation().equals((Object)OperationDefinition.Operation.QUERY) && source != null) {
            return Context.OperationType.Source;
        }
        return Context.OperationType.Query;
    }

    private SmallRyeContext(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    private void setExecutionInput(ExecutionInput executionInput) {
        this.executionInput = executionInput;
        try {
            this.documentSupplier = () -> this.parser.parseDocument(executionInput.getQuery());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"io.smallrye.graphql.execution.context.SmallRyeContext", (String)"240", (Object)this, (Object[])new Object[]{executionInput});
        }
    }

    private JsonArrayBuilder toJsonArrayBuilder(List<SelectedField> fields, boolean includeSourceFields) {
        JsonArrayBuilder builder = jsonbuilder.createArrayBuilder();
        for (SelectedField field : fields) {
            if (this.isFlattenScalar(field) || !includeSourceFields && this.isSourceField(field)) continue;
            if (this.isScalar(field)) {
                builder = builder.add(field.getName());
                continue;
            }
            builder = builder.add(this.toJsonObjectBuilder(field, includeSourceFields));
        }
        return builder;
    }

    private JsonObjectBuilder toJsonObjectBuilder(SelectedField selectedField, boolean includeSourceFields) {
        JsonObjectBuilder builder = jsonbuilder.createObjectBuilder();
        builder = builder.add(selectedField.getName(), this.toJsonArrayBuilder(selectedField.getSelectionSet().getFields(), includeSourceFields));
        return builder;
    }

    private boolean isSourceField(SelectedField selectedField) {
        if (this.field.getReference().getType().equals((Object)ReferenceType.TYPE)) {
            Type type = schema.getTypes().get(this.field.getReference().getName());
            return type.hasOperation(selectedField.getName());
        }
        return false;
    }

    private boolean isScalar(SelectedField field) {
        GraphQLType graphQLType = this.unwrapGraphQLType((GraphQLType)field.getFieldDefinition().getType());
        return this.isScalar(graphQLType);
    }

    private boolean isScalar(GraphQLType gqlt) {
        return GraphQLScalarType.class.isAssignableFrom(gqlt.getClass());
    }

    private GraphQLType unwrapGraphQLType(GraphQLType gqlt) {
        if (this.isNonNull(gqlt)) {
            GraphQLNonNull graphQLNonNull = (GraphQLNonNull)gqlt;
            return this.unwrapGraphQLType(graphQLNonNull.getWrappedType());
        }
        if (this.isList(gqlt)) {
            GraphQLList graphQLList = (GraphQLList)gqlt;
            return this.unwrapGraphQLType(graphQLList.getWrappedType());
        }
        return gqlt;
    }

    private boolean isNonNull(GraphQLType gqlt) {
        return GraphQLNonNull.class.isAssignableFrom(gqlt.getClass());
    }

    private boolean isList(GraphQLType gqlt) {
        return GraphQLList.class.isAssignableFrom(gqlt.getClass());
    }

    private boolean isFlattenScalar(SelectedField field) {
        return field.getQualifiedName().contains("/");
    }

    public String toString() {
        return "SmallRyeContext {\nexecutionId = " + this.getExecutionId() + ",\nrequest = " + this.getRequest() + ",\noperationName = " + (String)this.getOperationName().orElse(null) + ",\noperationTypes = " + this.getRequestedOperationTypes() + ",\nparentTypeName = " + (String)this.getParentTypeName().orElse(null) + ",\nvariables = " + this.getVariables().orElse(null) + ",\nquery = " + this.getQuery() + ",\nfieldName = " + this.getFieldName() + ",\nselectedFields = " + this.getSelectedFields() + ",\nsource = " + this.getSource() + ",\narguments = " + this.getArguments() + ",\nfieldName = " + this.getFieldName() + ",\npath = " + this.getPath() + "\n}";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.smallrye.graphql.execution.context.SmallRyeContext", SmallRyeContext.class, null, null);
        current = new ThreadLocal();
        jsonbuilder = Json.createBuilderFactory(null);
    }
}

