/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.MutationExecutionStrategy;
import io.smallrye.graphql.execution.QueryCache;
import io.smallrye.graphql.execution.QueryExecutionStrategy;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.error.ExceptionHandler;
import io.smallrye.graphql.execution.error.ExecutionErrorsService;
import io.smallrye.graphql.execution.event.EventEmitter;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import org.dataloader.DataLoaderRegistry;

public class ExecutionService {
    private static final JsonBuilderFactory jsonObjectFactory = Json.createBuilderFactory(null);
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    private static final Jsonb jsonB = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.TRUE).withFormatting(Boolean.TRUE));
    private final String executionIdPrefix;
    private final AtomicLong executionId = new AtomicLong();
    private final ExecutionErrorsService errorsService = new ExecutionErrorsService();
    private final Config config;
    private final GraphQLSchema graphQLSchema;
    private final DataLoaderRegistry dataLoaderRegistry;
    private final EventEmitter eventEmitter;
    private GraphQL graphQL;
    private static final String DATA = "data";
    private static final String ERRORS = "errors";

    public ExecutionService(Config config, GraphQLSchema graphQLSchema) {
        this(config, graphQLSchema, null);
    }

    public ExecutionService(Config config, GraphQLSchema graphQLSchema, DataLoaderRegistry dataLoaderRegistry) {
        this.config = config;
        this.graphQLSchema = graphQLSchema;
        this.dataLoaderRegistry = dataLoaderRegistry;
        this.eventEmitter = new EventEmitter(config);
        this.executionIdPrefix = Integer.toString(Objects.hashCode(graphQLSchema));
    }

    public JsonObject execute(JsonObject jsonInput) {
        SmallRyeContext.register(jsonInput);
        ExecutionId finalExecutionId = ExecutionId.from((String)(this.executionIdPrefix + this.executionId.getAndIncrement()));
        try {
            GraphQL g;
            Context context = SmallRyeContext.getContext();
            String query = context.getQuery();
            if (this.config.logPayload()) {
                SmallRyeGraphQLServerLogging.log.payloadIn(query);
            }
            if ((g = this.getGraphQL()) != null) {
                ExecutionInput.Builder executionBuilder = ExecutionInput.newExecutionInput().query(query).executionId(finalExecutionId);
                context.getVariables().ifPresent(arg_0 -> ((ExecutionInput.Builder)executionBuilder).variables(arg_0));
                context.getOperationName().ifPresent(arg_0 -> ((ExecutionInput.Builder)executionBuilder).operationName(arg_0));
                executionBuilder.context((Object)this.toGraphQLContext(context));
                if (this.dataLoaderRegistry != null) {
                    executionBuilder.dataLoaderRegistry(this.dataLoaderRegistry);
                }
                ExecutionInput executionInput = executionBuilder.build();
                SmallRyeContext.setDataFromExecution(executionInput);
                this.eventEmitter.fireBeforeExecute();
                ExecutionResult executionResult = g.execute(executionInput);
                this.eventEmitter.fireAfterExecute();
                JsonObjectBuilder returnObjectBuilder = jsonObjectFactory.createObjectBuilder();
                returnObjectBuilder = this.addErrorsToResponse(returnObjectBuilder, executionResult);
                returnObjectBuilder = this.addDataToResponse(returnObjectBuilder, executionResult);
                JsonObject jsonResponse = returnObjectBuilder.build();
                if (this.config.logPayload()) {
                    SmallRyeGraphQLServerLogging.log.payloadOut(jsonResponse.toString());
                }
                JsonObject jsonObject = jsonResponse;
                return jsonObject;
            }
            SmallRyeGraphQLServerLogging.log.noGraphQLMethodsFound();
            JsonObject jsonObject = null;
            return jsonObject;
        }
        catch (Throwable t) {
            this.eventEmitter.fireOnExecuteError(finalExecutionId.toString(), t);
            throw t;
        }
        finally {
            SmallRyeContext.remove();
        }
    }

    private GraphQLContext toGraphQLContext(Context context) {
        GraphQLContext.Builder builder = GraphQLContext.newContext();
        builder = builder.of((Object)"context", (Object)context);
        return builder.build();
    }

    private JsonObjectBuilder addDataToResponse(JsonObjectBuilder returnObjectBuilder, ExecutionResult executionResult) {
        Object pojoData = executionResult.getData();
        return this.addDataToResponse(returnObjectBuilder, pojoData);
    }

    private JsonObjectBuilder addDataToResponse(JsonObjectBuilder returnObjectBuilder, Object pojoData) {
        if (pojoData != null) {
            JsonValue data = this.toJsonValue(pojoData);
            return returnObjectBuilder.add(DATA, data);
        }
        return returnObjectBuilder.addNull(DATA);
    }

    private JsonObjectBuilder addErrorsToResponse(JsonObjectBuilder returnObjectBuilder, ExecutionResult executionResult) {
        List errors = executionResult.getErrors();
        if (errors != null) {
            JsonArray jsonArray = this.errorsService.toJsonErrors(errors);
            if (!jsonArray.isEmpty()) {
                returnObjectBuilder = returnObjectBuilder.add(ERRORS, (JsonValue)jsonArray);
            }
            return returnObjectBuilder;
        }
        return returnObjectBuilder;
    }

    /*
     * Exception decompiling
     */
    private JsonValue toJsonValue(Object pojo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private GraphQL getGraphQL() {
        if (this.graphQL == null) {
            ExceptionHandler exceptionHandler = new ExceptionHandler(this.config);
            if (this.graphQLSchema != null) {
                QueryCache queryCache = new QueryCache();
                this.graphQL = GraphQL.newGraphQL((GraphQLSchema)this.graphQLSchema).queryExecutionStrategy((ExecutionStrategy)new QueryExecutionStrategy(exceptionHandler)).mutationExecutionStrategy((ExecutionStrategy)new MutationExecutionStrategy(exceptionHandler)).instrumentation((Instrumentation)queryCache).preparsedDocumentProvider((PreparsedDocumentProvider)queryCache).build();
            } else {
                SmallRyeGraphQLServerLogging.log.noGraphQLMethodsFound();
            }
        }
        return this.graphQL;
    }
}

