/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.validation;

import io.smallrye.graphql.cdi.validation.BeanValidationException;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.spi.EventingService;
import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;

public class ValidationService
implements EventingService {
    private static final ValidatorFactory VALIDATOR_FACTORY = Validation.buildDefaultValidatorFactory();

    @Override
    public void beforeInvoke(InvokeInfo invokeInfo) throws Exception {
        Object declaringObject = invokeInfo.getOperationInstance();
        Method method = invokeInfo.getOperationMethod();
        Object[] arguments = invokeInfo.getOperationTransformedArguments();
        Set violations = VALIDATOR_FACTORY.getValidator().forExecutables().validateParameters(declaringObject, method, arguments, new Class[0]);
        if (!violations.isEmpty()) {
            throw new BeanValidationException(violations, method);
        }
    }

    @Override
    public String getConfigKey() {
        return "smallrye.graphql.validation.enabled";
    }
}

