/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.TypeResolver;
import graphql.schema.visibility.BlockedFields;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.schema.visibility.NoIntrospectionGraphqlFieldVisibility;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.bootstrap.BootstrapedResult;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.execution.batchloader.SourceBatchLoader;
import io.smallrye.graphql.execution.batchloader.SourceBatchLoaderHelper;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.BatchDataFetcher;
import io.smallrye.graphql.execution.datafetcher.CollectionCreator;
import io.smallrye.graphql.execution.datafetcher.PropertyDataFetcher;
import io.smallrye.graphql.execution.datafetcher.ReflectionDataFetcher;
import io.smallrye.graphql.execution.error.ErrorInfoMap;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.execution.resolver.InterfaceOutputRegistry;
import io.smallrye.graphql.execution.resolver.InterfaceResolver;
import io.smallrye.graphql.json.JsonInputRegistry;
import io.smallrye.graphql.scalar.GraphQLScalarTypes;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Array;
import io.smallrye.graphql.schema.model.EnumType;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.InterfaceType;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.spi.ClassloadingService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonReaderFactory;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;

public class Bootstrap {
    private final Schema schema;
    private final Config config;
    private final EventEmitter eventEmitter;
    private final Map<String, GraphQLEnumType> enumMap = new HashMap<String, GraphQLEnumType>();
    private final Map<String, GraphQLInterfaceType> interfaceMap = new HashMap<String, GraphQLInterfaceType>();
    private final Map<String, GraphQLInputObjectType> inputMap = new HashMap<String, GraphQLInputObjectType>();
    private final Map<String, GraphQLObjectType> typeMap = new HashMap<String, GraphQLObjectType>();
    private GraphQLSchema graphQLSchema;
    private final DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();
    private final GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry();
    private final ClassloadingService classloadingService = ClassloadingService.get();
    private static final String QUERY = "Query";
    private static final String MUTATION = "Mutation";
    private static final String COMMA = ",";
    private static final Jsonb JSONB = JsonbBuilder.create();
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);

    public static BootstrapedResult bootstrap(Schema schema) {
        return Bootstrap.bootstrap(schema, null);
    }

    public static BootstrapedResult bootstrap(Schema schema, Config config) {
        if (schema != null && (schema.hasQueries() || schema.hasMutations())) {
            Bootstrap bootstrap = new Bootstrap(schema, config);
            bootstrap.generateGraphQLSchema();
            return new BootstrapedResult(bootstrap.graphQLSchema, bootstrap.dataLoaderRegistry);
        }
        SmallRyeGraphQLServerLogging.log.emptyOrNullSchema();
        return new BootstrapedResult();
    }

    private Bootstrap(Schema schema, Config config) {
        this.schema = schema;
        this.config = config;
        this.eventEmitter = new EventEmitter(config);
        SmallRyeContext.setSchema(schema);
    }

    private void generateGraphQLSchema() {
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        this.createGraphQLEnumTypes();
        this.createGraphQLInterfaceTypes();
        this.createGraphQLObjectTypes();
        this.createGraphQLInputObjectTypes();
        this.addQueries(schemaBuilder);
        this.addMutations(schemaBuilder);
        schemaBuilder.additionalTypes(new HashSet<GraphQLEnumType>(this.enumMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLInterfaceType>(this.interfaceMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLObjectType>(this.typeMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLInputObjectType>(this.inputMap.values()));
        this.codeRegistryBuilder.fieldVisibility(this.getGraphqlFieldVisibility());
        schemaBuilder = schemaBuilder.codeRegistry(this.codeRegistryBuilder.build());
        ErrorInfoMap.register(this.schema.getErrors());
        schemaBuilder = this.eventEmitter.fireBeforeSchemaBuild(schemaBuilder);
        this.graphQLSchema = schemaBuilder.build();
    }

    private void addQueries(GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType.Builder queryBuilder = GraphQLObjectType.newObject().name(QUERY).description("Query root");
        if (this.schema.hasQueries()) {
            Set<Operation> queries = this.schema.getQueries();
            for (Operation queryOperation : queries) {
                queryOperation = this.eventEmitter.fireCreateOperation(queryOperation);
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(QUERY, queryOperation);
                queryBuilder = queryBuilder.field(graphQLFieldDefinition);
            }
        }
        GraphQLObjectType query = queryBuilder.build();
        schemaBuilder.query(query);
    }

    private void addMutations(GraphQLSchema.Builder schemaBuilder) {
        if (this.schema.hasMutations()) {
            GraphQLObjectType.Builder mutationBuilder = GraphQLObjectType.newObject().name(MUTATION).description("Mutation root");
            Set<Operation> mutations = this.schema.getMutations();
            for (Operation mutationOperation : mutations) {
                mutationOperation = this.eventEmitter.fireCreateOperation(mutationOperation);
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(MUTATION, mutationOperation);
                mutationBuilder = mutationBuilder.field(graphQLFieldDefinition);
            }
            GraphQLObjectType mutation = mutationBuilder.build();
            if (mutation.getFieldDefinitions() != null && !mutation.getFieldDefinitions().isEmpty()) {
                schemaBuilder.mutation(mutation);
            }
        }
    }

    private void createGraphQLEnumTypes() {
        if (this.schema.hasEnums()) {
            for (EnumType enumType : this.schema.getEnums().values()) {
                this.createGraphQLEnumType(enumType);
            }
        }
    }

    private void createGraphQLEnumType(EnumType enumType) {
        GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(enumType.getName()).description(enumType.getDescription());
        for (String value : enumType.getValues()) {
            enumBuilder = enumBuilder.value(value);
        }
        GraphQLEnumType graphQLEnumType = enumBuilder.build();
        this.enumMap.put(enumType.getClassName(), graphQLEnumType);
    }

    private void createGraphQLInterfaceTypes() {
        if (this.schema.hasInterfaces()) {
            for (InterfaceType interfaceType : this.schema.getInterfaces().values()) {
                this.createGraphQLInterfaceType(interfaceType);
            }
        }
    }

    private void createGraphQLInterfaceType(InterfaceType interfaceType) {
        GraphQLInterfaceType.Builder interfaceTypeBuilder = GraphQLInterfaceType.newInterface().name(interfaceType.getName()).description(interfaceType.getDescription());
        if (interfaceType.hasFields()) {
            interfaceTypeBuilder = interfaceTypeBuilder.fields(this.createGraphQLFieldDefinitionsFromFields(interfaceType.getName(), interfaceType.getFields().values()));
        }
        if (interfaceType.hasInterfaces()) {
            Set<Reference> interfaces = interfaceType.getInterfaces();
            for (Reference i : interfaces) {
                interfaceTypeBuilder = interfaceTypeBuilder.withInterface(GraphQLTypeReference.typeRef((String)i.getName()));
            }
        }
        GraphQLInterfaceType graphQLInterfaceType = interfaceTypeBuilder.build();
        this.codeRegistryBuilder.typeResolver(graphQLInterfaceType, (TypeResolver)new InterfaceResolver(interfaceType));
        this.interfaceMap.put(interfaceType.getClassName(), graphQLInterfaceType);
    }

    private void createGraphQLInputObjectTypes() {
        if (this.schema.hasInputs()) {
            for (InputType inputType : this.schema.getInputs().values()) {
                this.createGraphQLInputObjectType(inputType);
            }
        }
    }

    private void createGraphQLInputObjectType(InputType inputType) {
        GraphQLInputObjectType.Builder inputObjectTypeBuilder = GraphQLInputObjectType.newInputObject().name(inputType.getName()).description(inputType.getDescription());
        if (inputType.hasFields()) {
            inputObjectTypeBuilder = inputObjectTypeBuilder.fields(this.createGraphQLInputObjectFieldsFromFields(inputType.getFields().values()));
            JsonInputRegistry.register(inputType);
        }
        GraphQLInputObjectType graphQLInputObjectType = inputObjectTypeBuilder.build();
        this.inputMap.put(inputType.getClassName(), graphQLInputObjectType);
    }

    private void createGraphQLObjectTypes() {
        if (this.schema.hasTypes()) {
            for (Type type : this.schema.getTypes().values()) {
                this.createGraphQLObjectType(type);
            }
        }
    }

    private void createGraphQLObjectType(Type type) {
        GraphQLObjectType.Builder objectTypeBuilder = GraphQLObjectType.newObject().name(type.getName()).description(type.getDescription());
        if (type.hasFields()) {
            objectTypeBuilder = objectTypeBuilder.fields(this.createGraphQLFieldDefinitionsFromFields(type.getName(), type.getFields().values()));
        }
        if (type.hasOperations()) {
            for (Operation operation : type.getOperations().values()) {
                String name = operation.getName();
                if (!type.hasBatchOperation(name)) {
                    operation = this.eventEmitter.fireCreateOperation(operation);
                    GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(type.getName(), operation);
                    objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
                    continue;
                }
                SmallRyeGraphQLServerLogging.log.duplicateOperation(operation.getName());
            }
        }
        if (type.hasBatchOperations()) {
            for (Operation operation : type.getBatchOperations().values()) {
                operation = this.eventEmitter.fireCreateOperation(operation);
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromBatchOperation(type.getName(), operation);
                objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
            }
        }
        if (type.hasInterfaces()) {
            Set<Reference> interfaces = type.getInterfaces();
            for (Reference i : interfaces) {
                if (!this.interfaceMap.containsKey(i.getClassName())) continue;
                GraphQLInterfaceType graphQLInterfaceType = this.interfaceMap.get(i.getClassName());
                objectTypeBuilder = objectTypeBuilder.withInterface(graphQLInterfaceType);
            }
        }
        GraphQLObjectType graphQLObjectType = objectTypeBuilder.build();
        this.typeMap.put(type.getClassName(), graphQLObjectType);
        InterfaceOutputRegistry.register(type, graphQLObjectType);
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromBatchOperation(String operationTypeName, Operation operation) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType(operation));
        if (operation.hasArguments()) {
            fieldBuilder = fieldBuilder.arguments(this.createGraphQLArguments(operation.getArguments()));
        }
        this.registerBatchLoader(operation, this.config);
        BatchDataFetcher datafetcher = new BatchDataFetcher(operation, this.config);
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)operationTypeName, (String)graphQLFieldDefinition.getName()), datafetcher);
        return graphQLFieldDefinition;
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromOperation(String operationTypeName, Operation operation) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType(operation));
        if (operation.hasArguments()) {
            fieldBuilder = fieldBuilder.arguments(this.createGraphQLArguments(operation.getArguments()));
        }
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        ReflectionDataFetcher datafetcher = new ReflectionDataFetcher(operation, this.config);
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)operationTypeName, (String)graphQLFieldDefinition.getName()), datafetcher);
        return graphQLFieldDefinition;
    }

    private List<GraphQLFieldDefinition> createGraphQLFieldDefinitionsFromFields(String ownerName, Collection<Field> fields) {
        ArrayList<GraphQLFieldDefinition> graphQLFieldDefinitions = new ArrayList<GraphQLFieldDefinition>();
        for (Field field : fields) {
            graphQLFieldDefinitions.add(this.createGraphQLFieldDefinitionFromField(ownerName, field));
        }
        return graphQLFieldDefinitions;
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromField(String ownerName, Field field) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(field.getName()).description(field.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType(field));
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        PropertyDataFetcher datafetcher = new PropertyDataFetcher(field);
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)ownerName, (String)graphQLFieldDefinition.getName()), (DataFetcher)datafetcher);
        return graphQLFieldDefinition;
    }

    private List<GraphQLInputObjectField> createGraphQLInputObjectFieldsFromFields(Collection<Field> fields) {
        ArrayList<GraphQLInputObjectField> graphQLInputObjectFields = new ArrayList<GraphQLInputObjectField>();
        for (Field field : fields) {
            graphQLInputObjectFields.add(this.createGraphQLInputObjectFieldFromField(field));
        }
        return graphQLInputObjectFields;
    }

    private GraphQLInputObjectField createGraphQLInputObjectFieldFromField(Field field) {
        GraphQLInputObjectField.Builder inputFieldBuilder = GraphQLInputObjectField.newInputObjectField().name(field.getName()).description(field.getDescription());
        inputFieldBuilder = inputFieldBuilder.type(this.createGraphQLInputType(field));
        inputFieldBuilder = inputFieldBuilder.defaultValue(this.sanitizeDefaultValue(field));
        return inputFieldBuilder.build();
    }

    private GraphQLInputType createGraphQLInputType(Field field) {
        GraphQLInputType graphQLInputType = this.referenceGraphQLInputType(field);
        if (field.hasArray()) {
            Array array = field.getArray();
            if (array.isNotEmpty()) {
                graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
            }
            for (int i = 0; i < array.getDepth(); ++i) {
                graphQLInputType = GraphQLList.list((GraphQLType)graphQLInputType);
            }
        }
        if (field.isNotNull()) {
            graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
        }
        return graphQLInputType;
    }

    private GraphQLOutputType createGraphQLOutputType(Field field) {
        GraphQLOutputType graphQLOutputType = this.referenceGraphQLOutputType(field);
        if (field.hasArray()) {
            Array array = field.getArray();
            if (array.isNotEmpty()) {
                graphQLOutputType = GraphQLNonNull.nonNull((GraphQLType)graphQLOutputType);
            }
            for (int i = 0; i < array.getDepth(); ++i) {
                graphQLOutputType = GraphQLList.list((GraphQLType)graphQLOutputType);
            }
        }
        if (field.isNotNull()) {
            graphQLOutputType = GraphQLNonNull.nonNull((GraphQLType)graphQLOutputType);
        }
        return graphQLOutputType;
    }

    private GraphQLOutputType referenceGraphQLOutputType(Field field) {
        Reference reference = this.getCorrectFieldReference(field);
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        String name = reference.getName();
        switch (type) {
            case SCALAR: {
                return this.getCorrectScalarType(reference);
            }
            case ENUM: {
                return (GraphQLOutputType)this.enumMap.get(className);
            }
        }
        return GraphQLTypeReference.typeRef((String)name);
    }

    private GraphQLInputType referenceGraphQLInputType(Field field) {
        Reference reference = this.getCorrectFieldReference(field);
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        String name = reference.getName();
        switch (type) {
            case SCALAR: {
                return this.getCorrectScalarType(reference);
            }
            case ENUM: {
                return (GraphQLInputType)this.enumMap.get(className);
            }
        }
        return GraphQLTypeReference.typeRef((String)name);
    }

    private Reference getCorrectFieldReference(Field field) {
        if (field.getReference().hasMappingInfo()) {
            return field.getReference().getMappingInfo().getReference();
        }
        if (field.hasMappingInfo()) {
            return field.getMappingInfo().getReference();
        }
        return field.getReference();
    }

    private GraphQLScalarType getCorrectScalarType(Reference fieldReference) {
        return GraphQLScalarTypes.getScalarByName(fieldReference.getName());
    }

    private List<GraphQLArgument> createGraphQLArguments(List<Argument> arguments) {
        ArrayList<GraphQLArgument> graphQLArguments = new ArrayList<GraphQLArgument>();
        for (Argument argument : arguments) {
            if (argument.isSourceArgument()) continue;
            graphQLArguments.add(this.createGraphQLArgument(argument));
        }
        return graphQLArguments;
    }

    private GraphQLArgument createGraphQLArgument(Argument argument) {
        GraphQLArgument.Builder argumentBuilder = GraphQLArgument.newArgument().name(argument.getName()).description(argument.getDescription()).defaultValue(this.sanitizeDefaultValue(argument));
        GraphQLInputType graphQLInputType = this.referenceGraphQLInputType(argument);
        if (argument.hasArray()) {
            Array array = argument.getArray();
            if (array.isNotEmpty()) {
                graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
            }
            for (int i = 0; i < array.getDepth(); ++i) {
                graphQLInputType = GraphQLList.list((GraphQLType)graphQLInputType);
            }
        }
        if (argument.isNotNull()) {
            graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
        }
        argumentBuilder = argumentBuilder.type(graphQLInputType);
        return argumentBuilder.build();
    }

    private Object sanitizeDefaultValue(Field field) {
        String jsonString = field.getDefaultValue();
        if (jsonString == null) {
            return null;
        }
        if (this.isJsonString(jsonString)) {
            Class<?> type;
            if (field.hasArray()) {
                type = this.classloadingService.loadClass(field.getArray().getClassName());
                if (Collection.class.isAssignableFrom(type)) {
                    type = CollectionCreator.newCollection(field.getArray().getClassName()).getClass();
                }
            } else {
                type = this.classloadingService.loadClass(field.getReference().getClassName());
            }
            return JSONB.fromJson(jsonString, type);
        }
        if (Classes.isNumberLikeType(field.getReference().getGraphQlClassName())) {
            return new BigDecimal(jsonString);
        }
        if (Classes.isBoolean(field.getReference().getGraphQlClassName())) {
            return Boolean.parseBoolean(jsonString);
        }
        return jsonString;
    }

    /*
     * Exception decompiling
     */
    private boolean isJsonString(String string) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private GraphqlFieldVisibility getGraphqlFieldVisibility() {
        String fieldVisibility;
        if (this.config != null && (fieldVisibility = this.config.getFieldVisibility()) != null && !fieldVisibility.isEmpty()) {
            if (fieldVisibility.equals("no-introspection")) {
                return NoIntrospectionGraphqlFieldVisibility.NO_INTROSPECTION_FIELD_VISIBILITY;
            }
            String[] patterns = fieldVisibility.split(COMMA);
            BlockedFields.Builder blockedFields = BlockedFields.newBlock();
            for (String pattern : patterns) {
                blockedFields = blockedFields.addPattern(pattern);
            }
            return blockedFields.build();
        }
        return DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
    }

    public void registerBatchLoader(Operation operation, Config config) {
        SourceBatchLoader batchLoader = new SourceBatchLoader(operation, config);
        this.dataLoaderRegistry.register(SourceBatchLoaderHelper.getName(operation), DataLoader.newDataLoader((BatchLoaderWithContext)batchLoader));
    }

    public void registerDataLoader(String name, DataLoader<?, ?> dataLoader) {
        this.dataLoaderRegistry.register(name, dataLoader);
    }
}

