/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.CancelException;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.EventManager;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.Product;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDirector {
    static final String DEFAULT_TO_EXTENSION = "default";
    Product product;
    EventManager eventManager;
    Logger logger = null;
    boolean enableEvent = true;

    AbstractDirector(Product product, EventManager eventManager, Logger logger) {
        this.product = product;
        this.eventManager = eventManager;
        this.logger = logger;
    }

    void fireProgressEvent(int state, int progress, String message) {
        try {
            this.fireProgressEvent(state, progress, message, false);
        }
        catch (InstallException installException) {
            // empty catch block
        }
    }

    void fireProgressEvent(int state, int progress, String message, boolean allowCancel) throws InstallException {
        this.log(Level.FINEST, message);
        if (this.enableEvent) {
            try {
                this.eventManager.fireProgressEvent(state, progress, message);
            }
            catch (CancelException ce) {
                if (allowCancel) {
                    throw ce;
                }
                this.log(Level.FINEST, "fireProgressEvent caught cancel exception: " + ce.getMessage());
            }
            catch (Exception e) {
                this.log(Level.FINEST, "fireProgressEvent caught exception: " + e.getMessage());
            }
        }
    }

    void log(Level level, String msg) {
        if (msg != null && !msg.isEmpty()) {
            this.logger.log(level, msg);
        }
    }

    void log(Level level, String msg, Exception e) {
        if (e != null) {
            this.logger.log(level, msg, e);
        }
    }

    boolean isEmpty(Map<String, List<List<RepositoryResource>>> installResources) {
        if (installResources == null) {
            return true;
        }
        for (List<List<RepositoryResource>> targetList : installResources.values()) {
            for (List<RepositoryResource> mrList : targetList) {
                if (mrList.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    boolean isEmpty(List<List<RepositoryResource>> installResources) {
        if (installResources == null) {
            return true;
        }
        for (List<RepositoryResource> mrList : installResources) {
            if (mrList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    boolean containFeature(Map<String, ProvisioningFeatureDefinition> installedFeatures, String feature) {
        if (installedFeatures.containsKey(feature)) {
            return true;
        }
        for (ProvisioningFeatureDefinition pfd : installedFeatures.values()) {
            String shortName = InstallUtils.getShortName(pfd);
            if (shortName == null || !shortName.equalsIgnoreCase(feature)) continue;
            return true;
        }
        return false;
    }

    Collection<String> getFeaturesToInstall(Collection<String> requiredFeatures, boolean download) {
        ArrayList<String> featuresToInstall = new ArrayList<String>(requiredFeatures.size());
        if (!requiredFeatures.isEmpty()) {
            Map<String, ProvisioningFeatureDefinition> installedFeatures = this.product.getFeatureDefinitions();
            for (String feature : requiredFeatures) {
                if (!download && this.containFeature(installedFeatures, feature)) continue;
                featuresToInstall.add(feature);
            }
        }
        return featuresToInstall;
    }

    boolean containScript(List<File> filesInstalled) {
        for (File f : filesInstalled) {
            String path = f.getAbsolutePath().toLowerCase();
            if (!path.contains("/bin/") && !path.contains("\\bin\\")) continue;
            return true;
        }
        return false;
    }
}

