/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.CacheMap;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.Try;
import org.dataloader.impl.Assertions;
import org.dataloader.impl.CompletableFutureKit;
import org.dataloader.stats.StatisticsCollector;

class DataLoaderHelper<K, V> {
    private final DataLoader<K, V> dataLoader;
    private final Object batchLoadFunction;
    private final DataLoaderOptions loaderOptions;
    private final CacheMap<Object, CompletableFuture<V>> futureCache;
    private final List<LoaderQueueEntry<K, CompletableFuture<V>>> loaderQueue;
    private final StatisticsCollector stats;

    DataLoaderHelper(DataLoader<K, V> dataLoader, Object batchLoadFunction, DataLoaderOptions loaderOptions, CacheMap<Object, CompletableFuture<V>> futureCache, StatisticsCollector stats) {
        this.dataLoader = dataLoader;
        this.batchLoadFunction = batchLoadFunction;
        this.loaderOptions = loaderOptions;
        this.futureCache = futureCache;
        this.loaderQueue = new ArrayList<LoaderQueueEntry<K, CompletableFuture<V>>>();
        this.stats = stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<V> load(K key, Object loadContext) {
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            Object cacheKey = this.getCacheKey(Assertions.nonNull(key));
            this.stats.incrementLoadCount();
            boolean batchingEnabled = this.loaderOptions.batchingEnabled();
            boolean cachingEnabled = this.loaderOptions.cachingEnabled();
            if (cachingEnabled && this.futureCache.containsKey(cacheKey)) {
                this.stats.incrementCacheHitCount();
                return this.futureCache.get(cacheKey);
            }
            CompletableFuture<Object> future = new CompletableFuture();
            if (batchingEnabled) {
                this.loaderQueue.add(new LoaderQueueEntry(key, future, loadContext));
            } else {
                this.stats.incrementBatchLoadCountBy(1L);
                future = this.invokeLoaderImmediately(key, loadContext);
            }
            if (cachingEnabled) {
                this.futureCache.set(cacheKey, future);
            }
            return future;
        }
    }

    Object getCacheKey(K key) {
        return this.loaderOptions.cacheKeyFunction().isPresent() ? this.loaderOptions.cacheKeyFunction().get().getKey(key) : key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<List<V>> dispatch() {
        boolean batchingEnabled = this.loaderOptions.batchingEnabled();
        ArrayList keys = new ArrayList();
        ArrayList<Object> callContexts = new ArrayList<Object>();
        ArrayList queuedFutures = new ArrayList();
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            this.loaderQueue.forEach(entry -> {
                keys.add(entry.getKey());
                queuedFutures.add((CompletableFuture)entry.getValue());
                callContexts.add(entry.getCallContext());
            });
            this.loaderQueue.clear();
        }
        if (!batchingEnabled || keys.size() == 0) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        int maxBatchSize = this.loaderOptions.maxBatchSize();
        if (maxBatchSize > 0 && maxBatchSize < keys.size()) {
            return this.sliceIntoBatchesOfBatches(keys, queuedFutures, callContexts, maxBatchSize);
        }
        return this.dispatchQueueBatch(keys, callContexts, queuedFutures);
    }

    private CompletableFuture<List<V>> sliceIntoBatchesOfBatches(List<K> keys, List<CompletableFuture<V>> queuedFutures, List<Object> callContexts, int maxBatchSize) {
        ArrayList allBatches = new ArrayList();
        int len = keys.size();
        int batchCount = (int)Math.ceil((double)len / (double)maxBatchSize);
        for (int i = 0; i < batchCount; ++i) {
            int fromIndex = i * maxBatchSize;
            int toIndex = Math.min((i + 1) * maxBatchSize, len);
            List<K> subKeys = keys.subList(fromIndex, toIndex);
            List<CompletableFuture<V>> subFutures = queuedFutures.subList(fromIndex, toIndex);
            List<Object> subCallContexts = callContexts.subList(fromIndex, toIndex);
            allBatches.add(this.dispatchQueueBatch(subKeys, subCallContexts, subFutures));
        }
        return CompletableFuture.allOf(allBatches.toArray(new CompletableFuture[allBatches.size()])).thenApply(v -> allBatches.stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private CompletableFuture<List<V>> dispatchQueueBatch(List<K> keys, List<Object> callContexts, List<CompletableFuture<V>> queuedFutures) {
        this.stats.incrementBatchLoadCountBy(keys.size());
        CompletionStage<List<V>> batchLoad = this.invokeLoader(keys, callContexts);
        return ((CompletableFuture)batchLoad.toCompletableFuture().thenApply(values -> {
            this.assertResultSize(keys, (List<V>)values);
            for (int idx = 0; idx < queuedFutures.size(); ++idx) {
                Object value = values.get(idx);
                CompletableFuture future = (CompletableFuture)queuedFutures.get(idx);
                if (value instanceof Throwable) {
                    this.stats.incrementLoadErrorCount();
                    future.completeExceptionally((Throwable)value);
                    continue;
                }
                if (value instanceof Try) {
                    Try tryValue = (Try)value;
                    if (tryValue.isSuccess()) {
                        future.complete(tryValue.get());
                        continue;
                    }
                    this.stats.incrementLoadErrorCount();
                    future.completeExceptionally(tryValue.getThrowable());
                    continue;
                }
                Object val = value;
                future.complete(val);
            }
            return values;
        })).exceptionally(ex -> {
            this.stats.incrementBatchLoadExceptionCount();
            for (int idx = 0; idx < queuedFutures.size(); ++idx) {
                Object key = keys.get(idx);
                CompletableFuture future = (CompletableFuture)queuedFutures.get(idx);
                future.completeExceptionally((Throwable)ex);
                this.dataLoader.clear(key);
            }
            return Collections.emptyList();
        });
    }

    private void assertResultSize(List<K> keys, List<V> values) {
        Assertions.assertState(keys.size() == values.size(), "The size of the promised values MUST be the same size as the key list");
    }

    CompletableFuture<V> invokeLoaderImmediately(K key, Object keyContext) {
        List<K> keys = Collections.singletonList(key);
        try {
            Object context = this.loaderOptions.getBatchLoaderContextProvider().getContext();
            BatchLoaderEnvironment environment = BatchLoaderEnvironment.newBatchLoaderEnvironment().context(context).keyContexts(keys, Collections.singletonList(keyContext)).build();
            CompletionStage<Object> singleLoadCall = this.isMapLoader() ? this.invokeMapBatchLoader(keys, environment).thenApply(list -> list.get(0)) : this.invokeListBatchLoader(keys, environment).thenApply(list -> list.get(0));
            return singleLoadCall.toCompletableFuture();
        }
        catch (Exception e) {
            return CompletableFutureKit.failedFuture(e);
        }
    }

    CompletionStage<List<V>> invokeLoader(List<K> keys, List<Object> keyContexts) {
        CompletionStage<List<V>> batchLoad;
        try {
            Object context = this.loaderOptions.getBatchLoaderContextProvider().getContext();
            BatchLoaderEnvironment environment = BatchLoaderEnvironment.newBatchLoaderEnvironment().context(context).keyContexts(keys, keyContexts).build();
            batchLoad = this.isMapLoader() ? this.invokeMapBatchLoader(keys, environment) : this.invokeListBatchLoader(keys, environment);
        }
        catch (Exception e) {
            batchLoad = CompletableFutureKit.failedFuture(e);
        }
        return batchLoad;
    }

    private CompletionStage<List<V>> invokeListBatchLoader(List<K> keys, BatchLoaderEnvironment environment) {
        CompletionStage loadResult = this.batchLoadFunction instanceof BatchLoaderWithContext ? ((BatchLoaderWithContext)this.batchLoadFunction).load(keys, environment) : ((BatchLoader)this.batchLoadFunction).load(keys);
        return Assertions.nonNull(loadResult, "Your batch loader function MUST return a non null CompletionStage promise");
    }

    private CompletionStage<List<V>> invokeMapBatchLoader(List<K> keys, BatchLoaderEnvironment environment) {
        LinkedHashSet<K> setOfKeys = new LinkedHashSet<K>(keys);
        CompletionStage loadResult = this.batchLoadFunction instanceof MappedBatchLoaderWithContext ? ((MappedBatchLoaderWithContext)this.batchLoadFunction).load(setOfKeys, environment) : ((MappedBatchLoader)this.batchLoadFunction).load(setOfKeys);
        CompletionStage mapBatchLoad = Assertions.nonNull(loadResult, "Your batch loader function MUST return a non null CompletionStage promise");
        return mapBatchLoad.thenApply(map -> {
            ArrayList values = new ArrayList();
            for (Object key : keys) {
                Object value = map.get(key);
                values.add(value);
            }
            return values;
        });
    }

    private boolean isMapLoader() {
        return this.batchLoadFunction instanceof MappedBatchLoader || this.batchLoadFunction instanceof MappedBatchLoaderWithContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int dispatchDepth() {
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            return this.loaderQueue.size();
        }
    }

    class LoaderQueueEntry<K, V> {
        final K key;
        final V value;
        final Object callContext;

        public LoaderQueueEntry(K key, V value, Object callContext) {
            this.key = key;
            this.value = value;
            this.callContext = callContext;
        }

        K getKey() {
            return this.key;
        }

        V getValue() {
            return this.value;
        }

        Object getCallContext() {
            return this.callContext;
        }
    }
}

