/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.IgnoredChars;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.ScalarValue;
import graphql.language.SourceLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class BooleanValue
extends AbstractNode<BooleanValue>
implements ScalarValue<BooleanValue> {
    private final boolean value;

    @Internal
    protected BooleanValue(boolean value, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData);
        this.value = value;
    }

    public BooleanValue(boolean value) {
        this(value, null, new ArrayList<Comment>(), IgnoredChars.EMPTY, Collections.emptyMap());
    }

    public boolean isValue() {
        return this.value;
    }

    @Override
    public List<Node> getChildren() {
        return new ArrayList<Node>();
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().build();
    }

    @Override
    public BooleanValue withNewChildren(NodeChildrenContainer newChildren) {
        NodeUtil.assertNewChildrenAreEmpty(newChildren);
        return this;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanValue that = (BooleanValue)o;
        return this.value == that.value;
    }

    @Override
    public BooleanValue deepCopy() {
        return new BooleanValue(this.value, this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "BooleanValue{value=" + this.value + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitBooleanValue(this, context);
    }

    public static Builder newBooleanValue() {
        return new Builder();
    }

    public static Builder newBooleanValue(boolean value) {
        return new Builder().value(value);
    }

    public BooleanValue transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private boolean value;
        private List<Comment> comments = new ArrayList<Comment>();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(BooleanValue existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.value = existing.isValue();
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public Builder value(boolean value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public BooleanValue build() {
            return new BooleanValue(this.value, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

