/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.parameters;

import graphql.ExecutionInput;
import graphql.PublicApi;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.schema.GraphQLSchema;
import java.util.Collections;
import java.util.Map;

@PublicApi
public class InstrumentationExecutionParameters {
    private final ExecutionInput executionInput;
    private final String query;
    private final String operation;
    private final Object context;
    private final Map<String, Object> variables;
    private final InstrumentationState instrumentationState;
    private final GraphQLSchema schema;

    public InstrumentationExecutionParameters(ExecutionInput executionInput, GraphQLSchema schema, InstrumentationState instrumentationState) {
        this.executionInput = executionInput;
        this.query = executionInput.getQuery();
        this.operation = executionInput.getOperationName();
        this.context = executionInput.getContext();
        this.variables = executionInput.getVariables() != null ? executionInput.getVariables() : Collections.emptyMap();
        this.instrumentationState = instrumentationState;
        this.schema = schema;
    }

    public InstrumentationExecutionParameters withNewState(InstrumentationState instrumentationState) {
        return new InstrumentationExecutionParameters(this.getExecutionInput(), this.schema, instrumentationState);
    }

    public ExecutionInput getExecutionInput() {
        return this.executionInput;
    }

    public String getQuery() {
        return this.query;
    }

    public String getOperation() {
        return this.operation;
    }

    public <T> T getContext() {
        return (T)this.context;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public <T extends InstrumentationState> T getInstrumentationState() {
        return (T)this.instrumentationState;
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }
}

