/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Internal;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.execution.NonNullableFieldWasNullException;

@Internal
public class NonNullableFieldValidator {
    private final ExecutionContext executionContext;
    private final ExecutionStepInfo executionStepInfo;

    public NonNullableFieldValidator(ExecutionContext executionContext, ExecutionStepInfo executionStepInfo) {
        this.executionContext = executionContext;
        this.executionStepInfo = executionStepInfo;
    }

    public <T> T validate(ExecutionPath path, T result) throws NonNullableFieldWasNullException {
        if (result == null && this.executionStepInfo.isNonNullType()) {
            NonNullableFieldWasNullException nonNullException = new NonNullableFieldWasNullException(this.executionStepInfo, path);
            this.executionContext.addError(new NonNullableFieldWasNullError(nonNullException), path);
            throw nonNullException;
        }
        return result;
    }
}

