/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TimedMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 4496813777386763606L;
    private static final TraceComponent _tc = SibTr.register(TimedMap.class, "SIBUtils", null);
    private long _timeout;
    private Map<K, TimedValue<V>> _realMap = new HashMap<K, TimedValue<V>>();

    public TimedMap(long timeout) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "TimedMap", timeout);
        }
        this._timeout = timeout;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "TimedMap", this);
        }
    }

    @Override
    public V get(Object arg0) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "get", arg0);
        }
        TimedValue<V> obj = this._realMap.get(arg0);
        V value = null;
        if (obj != null) {
            if (obj.hasExipred()) {
                this._realMap.remove(arg0);
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    SibTr.debug(_tc, "The value with the key " + arg0 + " has expired");
                }
            } else {
                value = obj.get();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "get", value);
        }
        return value;
    }

    @Override
    public V put(K arg0, V arg1) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "put", new Object[]{arg0, arg1});
        }
        TimedValue<V> newValue = new TimedValue<V>(arg1, this._timeout);
        TimedValue<V> oldValue = this._realMap.put(arg0, newValue);
        V value = null;
        if (oldValue != null && !oldValue.hasExipred()) {
            value = oldValue.get();
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "put", value);
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> arg0) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "putAll", arg0);
        }
        for (Map.Entry<K, V> entry : arg0.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "putAll");
        }
    }

    @Override
    public Collection<V> values() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "values");
        }
        UnsupportedOperationException uoe = new UnsupportedOperationException();
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "values", uoe);
        }
        throw uoe;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "entrySet");
        }
        UnsupportedOperationException uoe = new UnsupportedOperationException();
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "entrySet", uoe);
        }
        throw uoe;
    }

    @Override
    public boolean containsValue(Object value) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "containsValue", value);
        }
        this.purge();
        boolean result = false;
        result = this._realMap.containsValue(new TimedValue<Object>(value, this._timeout));
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "containsValue", result);
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "remove", key);
        }
        TimedValue<V> value = this._realMap.remove(key);
        V deadValue = null;
        if (value != null) {
            deadValue = value.get();
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "remove", deadValue);
        }
        return deadValue;
    }

    @Override
    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "clear");
        }
        this._realMap.clear();
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "clear");
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "containsKey", key);
        }
        this.purge();
        boolean result = this._realMap.containsKey(key);
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "containsKey", result);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "isEmpty");
        }
        this.purge();
        boolean result = this._realMap.isEmpty();
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "isEmpty", result);
        }
        return result;
    }

    @Override
    public Set<K> keySet() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "keySet");
        }
        UnsupportedOperationException uoe = new UnsupportedOperationException();
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "keySet", uoe);
        }
        throw uoe;
    }

    @Override
    public int size() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "size");
        }
        this.purge();
        int size = this._realMap.size();
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "size", size);
        }
        return size;
    }

    private void purge() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry(this, _tc, "purge");
        }
        Iterator<Map.Entry<K, TimedValue<V>>> it = this._realMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, TimedValue<V>> entry = it.next();
            TimedValue<V> value = entry.getValue();
            if (!value.hasExipred()) continue;
            it.remove();
            if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) continue;
            SibTr.debug(_tc, "The value with the key " + entry.getKey() + " has expired");
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit(this, _tc, "purge");
        }
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public static final class TimedMapEntry<K, V>
    implements Map.Entry<K, V> {
        private K _key;
        private TimedValue<V> _value;
        private long _timeout;
        private static final int PRIME = 10003;
        private static final TraceComponent _tc2 = SibTr.register(TimedMapEntry.class, null, null);

        public TimedMapEntry(K key, long timeout, TimedValue<V> value) {
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.entry(this, _tc2, "TimedMapEntry", new Object[]{key, timeout, value});
            }
            this._key = key;
            this._value = value;
            this._timeout = timeout;
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.exit(this, _tc2, "TimedMapEntry", this);
            }
        }

        @Override
        public K getKey() {
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.entry(this, _tc2, "getKey");
            }
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.exit(this, _tc2, "getKey", this._key);
            }
            return this._key;
        }

        @Override
        public V getValue() {
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.entry(this, _tc2, "getValue");
            }
            V result = this._value.get();
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.exit(this, _tc2, "getValue", result);
            }
            return result;
        }

        @Override
        public V setValue(V value) {
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.entry(this, _tc2, "setValue", value);
            }
            V oldValue = this._value.get();
            this._value.set(value, this._timeout);
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.exit(this, _tc2, "setValue", oldValue);
            }
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            TimedMapEntry entry;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof TimedMapEntry && this._key.equals((entry = (TimedMapEntry)obj).getKey())) {
                V thisValue = this._value.get();
                V otherValue = entry._value.get();
                if (thisValue == null && otherValue == null) {
                    return true;
                }
                if (thisValue == null || otherValue == null) {
                    return false;
                }
                if (thisValue == otherValue) {
                    return true;
                }
                return thisValue.equals(otherValue);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = this._key.hashCode();
            hash = hash * 10003 + this._value.hashCode();
            return hash;
        }
    }

    private static final class TimedValue<V> {
        private long _expireTime;
        private V _value;
        private static final TraceComponent _tc2 = SibTr.register(TimedValue.class, null, null);

        public TimedValue(V obj, long timeout) {
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.entry(this, _tc2, "TimedValue", new Object[]{obj, timeout});
            }
            this.set(obj, timeout);
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.exit(this, _tc2, "TimedValue", this);
            }
        }

        public V get() {
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.entry(this, _tc2, "get");
            }
            V value = null;
            if (!this.hasExipred()) {
                value = this._value;
            }
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.exit(this, _tc2, "get", value);
            }
            return value;
        }

        public void set(V obj, long timeout) {
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.entry(this, _tc2, "set", new Object[]{obj, timeout});
            }
            this._value = obj;
            this._expireTime = timeout + System.currentTimeMillis();
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.exit(this, _tc2, "set");
            }
        }

        public boolean hasExipred() {
            long currentTime;
            boolean result;
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.entry(this, _tc2, "hasExipred");
            }
            boolean bl = result = (currentTime = System.currentTimeMillis()) > this._expireTime;
            if (TraceComponent.isAnyTracingEnabled() && _tc2.isEntryEnabled()) {
                SibTr.exit(this, _tc2, "hasExipred", result);
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof TimedValue) {
                return this._value.equals(((TimedValue)obj)._value);
            }
            return false;
        }

        public int hashCode() {
            return this._value.hashCode();
        }
    }
}

