/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.file;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.ArtifactListenerSelector;
import com.ibm.ws.artifact.file.ContainerFactoryHolder;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.artifact.DefaultArtifactNotification;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileArtifactNotifier
implements ArtifactNotifier {
    private final ArtifactContainer root;
    private final ContainerFactoryHolder cfh;
    private final Hashtable<String, Object> serviceProperties = new Hashtable();
    private ServiceRegistration<FileMonitor> service = null;
    private ServiceRegistration<FileMonitor> nonRecurseService = null;
    private final Hashtable<String, Object> nonRecurseServiceProperties = new Hashtable();
    private final Map<String, Collection<ArtifactListenerSelector>> listeners;
    private final Map<String, Collection<ArtifactListenerSelector>> nonRecurselisteners;
    private final Set<String> pathsBeingMonitored;
    private final Set<String> nonRecursePathsBeingMonitored;
    private final String rootAbsolutePath;
    private Long interval;
    private String notificationType;
    private final FileArtifactMonitor nonRecurseMonitor = new FileArtifactMonitor(this, false);
    private final FileArtifactMonitor recurseMonitor = new FileArtifactMonitor(this, true);
    static final long serialVersionUID = -423938483708516951L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FileArtifactNotifier(ArtifactContainer root, ContainerFactoryHolder cfh, String absPath) {
        this.root = root;
        this.rootAbsolutePath = PathUtils.fixPathString((String)absPath);
        this.cfh = cfh;
        this.listeners = new ConcurrentHashMap<String, Collection<ArtifactListenerSelector>>();
        this.nonRecurselisteners = new ConcurrentHashMap<String, Collection<ArtifactListenerSelector>>();
        this.pathsBeingMonitored = new HashSet<String>();
        this.nonRecursePathsBeingMonitored = new HashSet<String>();
    }

    private void verifyTargets(ArtifactNotifier.ArtifactNotification target) throws IllegalArgumentException {
        if (target.getContainer().getRoot() != this.root) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized boolean registerForNotifications(ArtifactNotifier.ArtifactNotification targets, ArtifactNotifier.ArtifactListener callbackObject) throws IllegalArgumentException {
        this.verifyTargets(targets);
        HashSet<String> pathsToMonitor = new HashSet<String>();
        HashSet<String> nonRecursePathsToMonitor = new HashSet<String>();
        for (String path : targets.getPaths()) {
            ArtifactListenerSelector artifactSelectorCallback = new ArtifactListenerSelector(callbackObject);
            this.addTarget(path, artifactSelectorCallback, pathsToMonitor, nonRecursePathsToMonitor);
        }
        this.updateMonitoredPaths(pathsToMonitor, null, nonRecursePathsToMonitor, null);
        return true;
    }

    public synchronized boolean removeListener(ArtifactNotifier.ArtifactListener callbackObject) {
        ArtifactListenerSelector listenerSelectorCallbackObject = new ArtifactListenerSelector(callbackObject);
        boolean success = false;
        HashSet<String> pathsToRemove = new HashSet<String>();
        for (Map.Entry<String, Collection<ArtifactListenerSelector>> entry : this.listeners.entrySet()) {
            for (ArtifactListenerSelector artifactListenerSelector : entry.getValue()) {
                if (!artifactListenerSelector.equals((Object)listenerSelectorCallbackObject)) continue;
                pathsToRemove.add(entry.getKey());
            }
        }
        HashSet<String> pathsToReallyRemove = new HashSet<String>(pathsToRemove.size());
        for (String string : pathsToRemove) {
            Collection<ArtifactListenerSelector> collection = this.listeners.get(string);
            if (collection == null) continue;
            if (collection.size() == 1) {
                this.listeners.remove(string);
                pathsToReallyRemove.add(string);
                continue;
            }
            collection.remove(listenerSelectorCallbackObject);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, Collection<ArtifactListenerSelector>> entry : this.nonRecurselisteners.entrySet()) {
            for (ArtifactListenerSelector listener : entry.getValue()) {
                if (!listener.equals((Object)listenerSelectorCallbackObject)) continue;
                hashSet.add(entry.getKey());
            }
        }
        HashSet<String> hashSet2 = new HashSet<String>(pathsToRemove.size());
        for (String path : hashSet) {
            Collection<ArtifactListenerSelector> listenersForPath = this.nonRecurselisteners.get(path);
            if (listenersForPath == null) continue;
            if (listenersForPath.size() == 1) {
                this.nonRecurselisteners.remove(path);
                hashSet2.add(path);
                continue;
            }
            listenersForPath.remove(listenerSelectorCallbackObject);
        }
        this.updateMonitoredPaths(null, pathsToReallyRemove, null, hashSet2);
        if (pathsToRemove.size() > 0 || hashSet2.size() > 0) {
            success = true;
        }
        return success;
    }

    private void addTarget(String path, ArtifactListenerSelector listener, Set<String> pathsToMonitor, Set<String> nonRecursePathsToMonitor) {
        Map<String, Collection<ArtifactListenerSelector>> l = this.listeners;
        boolean nonRecurse = false;
        if (path.startsWith("!")) {
            path = path.substring(1);
            nonRecurse = true;
            l = this.nonRecurselisteners;
        }
        boolean pathIsNew = true;
        for (String lpath : l.keySet()) {
            if (!path.equals(lpath) && (nonRecurse || !path.startsWith(lpath + "/"))) continue;
            pathIsNew = false;
        }
        Collection<ArtifactListenerSelector> list = l.get(path);
        if (list == null) {
            list = new ConcurrentLinkedQueue<ArtifactListenerSelector>();
            l.put(path, list);
        }
        list.add(listener);
        if (pathIsNew) {
            if (nonRecurse) {
                nonRecursePathsToMonitor.add(path);
            } else {
                pathsToMonitor.add(path);
            }
        }
    }

    private void rebuildPaths() {
        this.pathsBeingMonitored.clear();
        this.pathsBeingMonitored.addAll(this.listeners.keySet());
    }

    private void updateMonitoredPaths(Set<String> pathsToAdd, Set<String> pathsToRemove, Set<String> nonRecursePathsToAdd, Set<String> nonRecursePathsToRemove) {
        boolean updateNeeded = false;
        if (pathsToAdd != null && !pathsToAdd.isEmpty()) {
            this.pathsBeingMonitored.addAll(pathsToAdd);
            updateNeeded = true;
        }
        if (pathsToRemove != null && !pathsToRemove.isEmpty()) {
            this.rebuildPaths();
            this.pathsBeingMonitored.removeAll(pathsToRemove);
            updateNeeded = true;
        }
        if (updateNeeded) {
            this.collapsePaths();
            this.updateFileMonitorService();
        }
        boolean recurseUpdateNeeded = false;
        if (nonRecursePathsToAdd != null && !nonRecursePathsToAdd.isEmpty() && this.nonRecursePathsBeingMonitored.addAll(nonRecursePathsToAdd)) {
            recurseUpdateNeeded = true;
        }
        if (nonRecursePathsToRemove != null && !nonRecursePathsToRemove.isEmpty() && this.nonRecursePathsBeingMonitored.removeAll(nonRecursePathsToRemove)) {
            recurseUpdateNeeded = true;
        }
        if (recurseUpdateNeeded) {
            this.updateNonRecurseFileMonitorService();
        }
    }

    private void collapsePaths() {
        HashSet<String> subPathsToRemove = new HashSet<String>();
        for (String path : this.pathsBeingMonitored) {
            if (subPathsToRemove.contains(path)) continue;
            for (String testAgainst : this.pathsBeingMonitored) {
                String pathToCompare;
                if (subPathsToRemove.contains(testAgainst)) continue;
                String string = pathToCompare = path.equals("/") ? "/" : path + "/";
                if (path == testAgainst || path.length() == testAgainst.length() || !testAgainst.startsWith(pathToCompare)) continue;
                subPathsToRemove.add(testAgainst);
            }
        }
        this.pathsBeingMonitored.removeAll(subPathsToRemove);
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private synchronized void updateFileMonitorService() {
        if (this.service == null) {
            if (FrameworkState.isStopping()) {
                return;
            }
            this.serviceProperties.put("service.vendor", "IBM");
            this.serviceProperties.put("monitor.identification", "com.ibm.ws.kernel.monitor.artifact");
            Long newInterval = 5000L;
            if (this.interval != null) {
                newInterval = this.interval;
            }
            this.serviceProperties.put("monitor.interval", "" + newInterval + "ms");
            String type = this.notificationType;
            if (type == null) {
                type = "timed";
            }
            this.serviceProperties.put("monitor.type", type);
            HashSet<String> absDirPathsToMonitor = new HashSet<String>(this.pathsBeingMonitored.size());
            HashSet<String> absFilePathsToMonitor = new HashSet<String>(this.pathsBeingMonitored.size());
            for (String path : this.pathsBeingMonitored) {
                String absPath = PathUtils.fixPathString((File)new File(this.rootAbsolutePath, path));
                String filePath = absPath.endsWith(File.separator) ? absPath.substring(0, absPath.length() - 1) : absPath;
                absDirPathsToMonitor.add(absPath);
                absFilePathsToMonitor.add(filePath);
            }
            this.serviceProperties.put("monitor.directories", absDirPathsToMonitor);
            this.serviceProperties.put("monitor.files", absFilePathsToMonitor);
            this.serviceProperties.put("monitor.recurse", true);
            this.serviceProperties.put("monitor.includeself", true);
            this.serviceProperties.put("monitor.filter", ".*");
            try {
                BundleContext ctx = this.cfh.getBundleContext();
                this.service = ctx.registerService(FileMonitor.class, (Object)this.recurseMonitor, this.serviceProperties);
            }
            catch (IllegalStateException ctx) {}
        } else if (this.pathsBeingMonitored.size() > 0) {
            HashSet<String> absDirPathsToMonitor = new HashSet<String>(this.pathsBeingMonitored.size());
            HashSet<String> absFilePathsToMonitor = new HashSet<String>(this.pathsBeingMonitored.size());
            for (String path : this.pathsBeingMonitored) {
                String absPath = PathUtils.fixPathString((File)new File(this.rootAbsolutePath, path));
                String filePath = absPath.endsWith(File.separator) ? absPath.substring(0, absPath.length() - 1) : absPath;
                absDirPathsToMonitor.add(absPath);
                absFilePathsToMonitor.add(filePath);
            }
            this.serviceProperties.put("monitor.directories", absDirPathsToMonitor);
            this.serviceProperties.put("monitor.files", absFilePathsToMonitor);
            this.service.setProperties(this.serviceProperties);
        } else {
            try {
                this.service.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.service = null;
        }
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private synchronized void updateNonRecurseFileMonitorService() {
        if (this.nonRecurseService == null) {
            if (FrameworkState.isStopping()) {
                return;
            }
            BundleContext ctx = this.cfh.getBundleContext();
            this.nonRecurseServiceProperties.put("service.vendor", "IBM");
            this.nonRecurseServiceProperties.put("monitor.identification", "com.ibm.ws.kernel.monitor.artifact");
            Long newInterval = 5000L;
            if (this.interval != null) {
                newInterval = this.interval;
            }
            this.nonRecurseServiceProperties.put("monitor.interval", "" + newInterval + "ms");
            String type = this.notificationType;
            if (type == null) {
                type = "timed";
            }
            this.nonRecurseServiceProperties.put("monitor.type", type);
            HashSet<String> absDirPathsToMonitor = new HashSet<String>(this.nonRecursePathsBeingMonitored.size());
            HashSet<String> absFilePathsToMonitor = new HashSet<String>(this.nonRecursePathsBeingMonitored.size());
            for (String path : this.nonRecursePathsBeingMonitored) {
                String absPath = PathUtils.fixPathString((File)new File(this.rootAbsolutePath, path));
                String filePath = absPath.endsWith(File.separator) ? absPath.substring(0, absPath.length() - 1) : absPath;
                absDirPathsToMonitor.add(absPath);
                absFilePathsToMonitor.add(filePath);
            }
            this.nonRecurseServiceProperties.put("monitor.directories", absDirPathsToMonitor);
            this.nonRecurseServiceProperties.put("monitor.files", absFilePathsToMonitor);
            this.nonRecurseServiceProperties.put("monitor.recurse", false);
            this.nonRecurseServiceProperties.put("monitor.includeself", true);
            this.nonRecurseServiceProperties.put("monitor.filter", ".*");
            try {
                this.nonRecurseService = ctx.registerService(FileMonitor.class, (Object)this.nonRecurseMonitor, this.nonRecurseServiceProperties);
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (this.pathsBeingMonitored.size() > 0) {
            HashSet<String> absDirPathsToMonitor = new HashSet<String>(this.nonRecursePathsBeingMonitored.size());
            HashSet<String> absFilePathsToMonitor = new HashSet<String>(this.nonRecursePathsBeingMonitored.size());
            for (String path : this.pathsBeingMonitored) {
                String absPath = PathUtils.fixPathString((File)new File(this.rootAbsolutePath, path));
                String filePath = absPath.endsWith(File.separator) ? absPath.substring(0, absPath.length() - 1) : absPath;
                absDirPathsToMonitor.add(absPath);
                absFilePathsToMonitor.add(filePath);
            }
            this.nonRecurseServiceProperties.put("monitor.directories", absDirPathsToMonitor);
            this.nonRecurseServiceProperties.put("monitor.files", absFilePathsToMonitor);
            this.nonRecurseService.setProperties(this.nonRecurseServiceProperties);
        } else {
            try {
                this.nonRecurseService.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.nonRecurseService = null;
        }
    }

    public void initComplete(Collection<File> baseline, boolean recurse) {
    }

    private Set<String> convertAbsToRelative(Collection<File> files) {
        HashSet<String> result = new HashSet<String>();
        for (File f : files) {
            String fAbsPath = PathUtils.fixPathString((File)f);
            if (fAbsPath.startsWith(this.rootAbsolutePath)) {
                String absPath = fAbsPath;
                absPath = absPath.substring(this.rootAbsolutePath.length());
                if ("\\".equals(File.separator)) {
                    absPath = absPath.replace('\\', '/');
                }
                if (absPath.length() == 0) {
                    absPath = "/";
                }
                result.add(absPath);
                continue;
            }
            throw new IllegalStateException(fAbsPath + " " + this.rootAbsolutePath);
        }
        return result;
    }

    private ArtifactNotifier.ArtifactNotification collectNotificationsForPrefix(String prefix, Set<String> paths) {
        HashSet<String> gatheredPaths = new HashSet<String>();
        if ("/".equals(prefix)) {
            gatheredPaths.addAll(paths);
        } else {
            for (String path : paths) {
                if (!path.startsWith(prefix + "/") && !path.equals(prefix)) continue;
                gatheredPaths.add(path);
            }
        }
        return new DefaultArtifactNotification(this.root, gatheredPaths);
    }

    public void scanComplete(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles, boolean recurse) {
        this.scanComplete(createdFiles, modifiedFiles, deletedFiles, recurse, null);
    }

    public void scanComplete(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles, boolean recurse, String filter) {
        Map<String, Collection<ArtifactListenerSelector>> l = recurse ? this.listeners : this.nonRecurselisteners;
        Set<String> created = this.convertAbsToRelative(createdFiles);
        Set<String> modified = this.convertAbsToRelative(modifiedFiles);
        Set<String> deleted = this.convertAbsToRelative(deletedFiles);
        for (Map.Entry<String, Collection<ArtifactListenerSelector>> listenersForPath : l.entrySet()) {
            String path = listenersForPath.getKey();
            ArtifactNotifier.ArtifactNotification createdForPath = this.collectNotificationsForPrefix(path, created);
            ArtifactNotifier.ArtifactNotification modifiedForPath = this.collectNotificationsForPrefix(path, modified);
            ArtifactNotifier.ArtifactNotification deletedForPath = this.collectNotificationsForPrefix(path, deleted);
            if (createdForPath.getPaths().isEmpty() && modifiedForPath.getPaths().isEmpty() && deletedForPath.getPaths().isEmpty()) continue;
            for (ArtifactListenerSelector listener : listenersForPath.getValue()) {
                listener.notifyEntryChange(createdForPath, deletedForPath, modifiedForPath, filter);
            }
        }
    }

    public synchronized boolean setNotificationOptions(long interval, boolean useMBean) {
        Long compareInterval = interval;
        if (compareInterval.equals(this.interval) && (useMBean && "external".equals(this.notificationType) || !useMBean && "timed".equals(this.notificationType))) {
            return true;
        }
        this.interval = compareInterval;
        String string = this.notificationType = useMBean ? "external" : "timed";
        if (this.service != null) {
            this.updateFileMonitorService();
            this.updateNonRecurseFileMonitorService();
        }
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.file.FileArtifactNotifier", FileArtifactNotifier.class, (String)"archive.artifact.file", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class FileArtifactMonitor
    implements com.ibm.ws.kernel.filemonitor.FileMonitor {
        FileArtifactNotifier owner;
        boolean recurse;
        static final long serialVersionUID = -822232955625155676L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FileArtifactMonitor(FileArtifactNotifier owner, boolean recurse) {
            this.owner = owner;
            this.recurse = recurse;
        }

        public void onBaseline(Collection<File> baseline) {
            this.owner.initComplete(baseline, this.recurse);
        }

        public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
            this.owner.scanComplete(createdFiles, modifiedFiles, deletedFiles, this.recurse);
        }

        public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles, String filter) {
            this.owner.scanComplete(createdFiles, modifiedFiles, deletedFiles, this.recurse, filter);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.file.FileArtifactNotifier$FileArtifactMonitor", FileArtifactMonitor.class, (String)"archive.artifact.file", null);
        }
    }
}

