/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config14.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TimedCache<K, V> {
    private static final TraceComponent tc = Tr.register(TimedCache.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config14.resources.Config14");
    private static final Object NULL_VALUE = new CachedNullValue();
    private final ScheduledExecutorService executor;
    private final boolean localExecutor;
    private final long delay;
    private final TimeUnit unit;
    private volatile ConcurrentHashMap<K, Object> cache = new ConcurrentHashMap();
    private final AtomicBoolean invalidationPending = new AtomicBoolean(false);
    private volatile Future<?> invalidationFuture = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    static final long serialVersionUID = 3544978558827198282L;

    public TimedCache(ScheduledExecutorService executor, long delay, TimeUnit unit) {
        if (executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.localExecutor = true;
        } else {
            this.executor = executor;
            this.localExecutor = false;
        }
        this.delay = delay;
        this.unit = unit;
    }

    public V get(K key, Function<K, V> lookupFunction) {
        if (this.delay <= 0L) {
            return lookupFunction.apply(key);
        }
        Object cacheValue = this.cache.get(key);
        if (cacheValue == null) {
            cacheValue = this.toCacheValue(lookupFunction.apply(key));
            this.cache.put(key, cacheValue);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Item added to timed cache", (Object[])new Object[]{key, cacheValue});
            }
            this.requestInvalidation();
        }
        return this.fromCacheValue(cacheValue);
    }

    @Trivial
    private Object toCacheValue(V value) {
        return value == null ? NULL_VALUE : value;
    }

    @Trivial
    private V fromCacheValue(Object cacheValue) {
        return (V)(cacheValue == NULL_VALUE ? null : cacheValue);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={RejectedExecutionException.class})
    private void requestInvalidation() {
        if (this.closed.get()) {
            return;
        }
        if (this.invalidationPending.compareAndSet(false, true)) {
            try {
                this.invalidationFuture = this.executor.schedule(this::invalidate, this.delay, this.unit);
                if (this.closed.get()) {
                    this.invalidationFuture.cancel(false);
                    this.invalidationPending.compareAndSet(true, false);
                }
            }
            catch (RejectedExecutionException e) {
                this.invalidationPending.compareAndSet(true, false);
                if (!FrameworkState.isStopping()) {
                    Tr.error((TraceComponent)tc, (String)"failed.to.schedule.cache.invalidation.CWMCG0301E", (Object[])new Object[]{e});
                    String sourceId = TimedCache.class.getName();
                    FFDCFilter.processException((Throwable)e, (String)sourceId, (String)"requestInvalidation.rejectedExecution", (Object)this);
                }
            }
            catch (Throwable e) {
                void t;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config14.impl.TimedCache", (String)"163", (Object)this, (Object[])new Object[0]);
                this.invalidationPending.compareAndSet(true, false);
                Tr.error((TraceComponent)tc, (String)"failed.to.schedule.cache.invalidation.CWMCG0301E", (Object[])new Object[]{t});
                throw t;
            }
        }
    }

    private void invalidate() {
        this.invalidationPending.compareAndSet(true, false);
        this.cache = new ConcurrentHashMap();
    }

    public void close() {
        this.closed.set(true);
        if (this.invalidationFuture != null) {
            this.invalidationFuture.cancel(false);
        }
        if (this.localExecutor) {
            this.executor.shutdown();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class CachedNullValue {
        static final long serialVersionUID = 3553959646319250602L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private CachedNullValue() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.config14.impl.TimedCache$CachedNullValue", CachedNullValue.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config14.resources.Config14");
        }
    }
}

