/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.ltpakeyutil;

import com.ibm.ws.crypto.ltpakeyutil.LTPACrypto;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyPair;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyUtil;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPrivateKey;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPublicKey;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

final class LTPADigSignature {
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    static byte[][] testRawPubKey = null;
    static byte[][] testRawPrivKey = null;
    static MessageDigest md1 = null;
    static MessageDigest md2 = null;
    static MessageDigest md1JCE = null;
    static MessageDigest md2JCE = null;
    private static Object lockObj1 = new Object();
    private static Object lockObj2 = new Object();
    static long created = 0L;
    static long cacheHits = 0L;
    private static final String IBMJCE_NAME = "IBMJCE";

    static void generateRSAKeys(byte[][] rsaPubKey, byte[][] rsaPrivKey) {
        byte[][] rsaKey = LTPACrypto.rsaKey(128, true, true);
        rsaPrivKey[0] = rsaKey[0];
        rsaPrivKey[2] = rsaKey[2];
        rsaPrivKey[4] = rsaKey[3];
        rsaPrivKey[3] = rsaKey[4];
        rsaPrivKey[5] = rsaKey[5];
        rsaPrivKey[6] = rsaKey[6];
        rsaPrivKey[7] = rsaKey[7];
        rsaPubKey[0] = rsaKey[0];
        rsaPubKey[1] = rsaKey[2];
    }

    static byte[] sign(byte[] mesg, LTPAPrivateKey privKey) throws Exception {
        return LTPADigSignature.sign(mesg, privKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sign(byte[] mesg, LTPAPrivateKey privKey, boolean useJCE) throws Exception {
        byte[] data;
        byte[][] rsaPrivKey = privKey.getRawKey();
        Object object = lockObj1;
        synchronized (object) {
            data = useJCE ? md1JCE.digest(mesg) : md1.digest(mesg);
        }
        LTPACrypto.setRSAKey(rsaPrivKey);
        byte[] signature = LTPACrypto.signISO9796(rsaPrivKey, data, 0, data.length);
        return signature;
    }

    static boolean verify(byte[] mesg, byte[] signature, LTPAPublicKey pubKey) throws Exception {
        return LTPADigSignature.verify(mesg, signature, pubKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean verify(byte[] mesg, byte[] signature, LTPAPublicKey pubKey, boolean useJCE) throws Exception {
        byte[] data;
        byte[][] rsaPubKey = pubKey.getRawKey();
        Object object = lockObj2;
        synchronized (object) {
            data = useJCE ? md2JCE.digest(mesg) : md2.digest(mesg);
        }
        return LTPACrypto.verifyISO9796(rsaPubKey, data, 0, data.length, signature, 0, signature.length);
    }

    static LTPAKeyPair generateLTPAKeyPair() {
        byte[][] rsaPubKey = new byte[2][];
        byte[][] rsaPrivKey = new byte[8][];
        LTPADigSignature.generateRSAKeys(rsaPubKey, rsaPrivKey);
        LTPAPublicKey pubKey = new LTPAPublicKey(rsaPubKey);
        LTPAPrivateKey privKey = new LTPAPrivateKey(rsaPrivKey);
        return new LTPAKeyPair(pubKey, privKey);
    }

    static {
        try {
            if (LTPAKeyUtil.isIBMJCEAvailable()) {
                md1JCE = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, IBMJCE_NAME);
                md2JCE = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, IBMJCE_NAME);
                md1 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, IBMJCE_NAME);
                md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, IBMJCE_NAME);
            } else {
                md1JCE = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
                md2JCE = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
                md1 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
                md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }
}

