/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.websphere.logging.hpel.reader.LogRecordFilter;
import com.ibm.websphere.logging.hpel.reader.LogRecordHeaderFilter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import com.ibm.ws.logging.hpel.LogRecordSerializer;
import com.ibm.ws.logging.hpel.LogRepositoryBrowser;
import com.ibm.ws.logging.hpel.impl.OneLogFileRecordIterator;
import com.ibm.ws.logging.object.hpel.RemoteRepositoryCache;
import com.ibm.ws.logging.object.hpel.RepositoryLogRecordImpl;
import com.ibm.ws.logging.object.hpel.RepositoryPointerImpl;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogRecordBrowser {
    private static final String BUNDLE_NAME = "com.ibm.ws.logging.hpel.resources.HpelMessages";
    private static final String className = LogRecordBrowser.class.getName();
    private static final Logger logger = Logger.getLogger(className, "com.ibm.ws.logging.hpel.resources.HpelMessages");
    private final LogRepositoryBrowser fileBrowser;

    public LogRecordBrowser(LogRepositoryBrowser fileBrowser) {
        this.fileBrowser = fileBrowser;
    }

    public OnePidRecordListImpl recordsInProcess(long min, long max, LogRecordFilter filter) {
        return this.startRecordsInProcess(min, max, filter == null ? new AllAcceptVerifier() : new FullFilterVerifier(filter));
    }

    public OnePidRecordListImpl recordsInProcess(RepositoryPointer after, long max, LogRecordFilter filter) {
        return this.restartRecordsInProcess(after, max, filter == null ? new AllAcceptVerifier() : new FullFilterVerifier(filter));
    }

    public OnePidRecordListImpl recordsInProcess(RepositoryLogRecord after, long max, LogRecordFilter filter) {
        return this.restartRecordsInProcess(after, max, filter == null ? new AllAcceptVerifier() : new FullFilterVerifier(filter));
    }

    public OnePidRecordListImpl recordsInProcess(long min, long max, LogRecordHeaderFilter filter) {
        return this.startRecordsInProcess(min, max, filter == null ? new AllAcceptVerifier() : new HeadFilterVerifier(filter));
    }

    public OnePidRecordListImpl recordsInProcess(RepositoryPointer after, long max, LogRecordHeaderFilter filter) {
        return this.restartRecordsInProcess(after, max, filter == null ? new AllAcceptVerifier() : new HeadFilterVerifier(filter));
    }

    public OnePidRecordListImpl recordsInProcess(RepositoryLogRecord after, long max, LogRecordHeaderFilter filter) {
        return this.restartRecordsInProcess(after, max, filter == null ? new AllAcceptVerifier() : new HeadFilterVerifier(filter));
    }

    public RepositoryLogRecord getRecord(RepositoryPointer location) {
        if (!(location instanceof RepositoryPointerImpl)) {
            return null;
        }
        RepositoryPointerImpl real = (RepositoryPointerImpl)location;
        long pos = real.getRecordOffset();
        File file = this.fileBrowser.findFile(real);
        if (pos < 0L || file == null) {
            return null;
        }
        OneFileRecordIterator current = new OneFileRecordIterator(file, -1L, new AllAcceptVerifier());
        RepositoryLogRecord rec = null;
        if (current.setPosition(pos)) {
            rec = current.next();
        }
        current.close();
        if (rec != null && real.equals(rec.getRepositoryPointer())) {
            return rec;
        }
        return null;
    }

    private OnePidRecordListImpl startRecordsInProcess(long min, long max, IInternalRecordFilter recFilter) {
        File file = this.fileBrowser.findByMillis(min);
        if (file == null) {
            file = this.fileBrowser.findNext((File)null, max);
        }
        return new OnePidRecordListMintimeImpl(file, min, max, recFilter);
    }

    private OnePidRecordListImpl restartRecordsInProcess(RepositoryPointer after, long max, IInternalRecordFilter recFilter) {
        if (!(after instanceof RepositoryPointerImpl)) {
            throw new IllegalArgumentException("Specified location does not belong to this repository.");
        }
        return new OnePidRecordListLocationImpl((RepositoryPointerImpl)after, max, recFilter);
    }

    private OnePidRecordListImpl restartRecordsInProcess(RepositoryLogRecord after, long max, IInternalRecordFilter recFilter) {
        if (!(after instanceof RepositoryLogRecordImpl)) {
            throw new IllegalArgumentException("Specified location does not belong to this repository.");
        }
        RepositoryLogRecordImpl real = (RepositoryLogRecordImpl)after;
        File file = this.fileBrowser.findByMillis(real.getMillis());
        if (file == null) {
            file = this.fileBrowser.findNext((File)null, max);
        }
        return new OnePidRecordListRecordImpl(file, real, max, recFilter);
    }

    private class OnePidRecordListRecordImpl
    extends OnePidRecordListImpl {
        private final File file;
        private final RepositoryLogRecordImpl record;

        OnePidRecordListRecordImpl(File file, RepositoryLogRecordImpl record, long max, IInternalRecordFilter recFilter) {
            super(max, recFilter);
            this.file = file;
            this.record = record;
        }

        @Override
        protected OneFileRecordIterator getFirstIterator() {
            if (this.file != null) {
                return new OneFileRecordIterator(this.file, this.max, this.recFilter){

                    @Override
                    protected boolean verifyMin(RepositoryLogRecordImpl nextRecord) {
                        return OnePidRecordListRecordImpl.this.record.getInternalSeqNumber() < nextRecord.getInternalSeqNumber();
                    }
                };
            }
            return null;
        }

        @Override
        public long getTimestamp() {
            return LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(this.file);
        }
    }

    private class OnePidRecordListLocationImpl
    extends OnePidRecordListImpl {
        private final RepositoryPointerImpl location;

        OnePidRecordListLocationImpl(RepositoryPointerImpl location, long max, IInternalRecordFilter recFilter) {
            super(max, recFilter);
            this.location = location;
        }

        @Override
        protected OneFileRecordIterator getFirstIterator() {
            long pos = this.location.getRecordOffset();
            File file = LogRecordBrowser.this.fileBrowser.findFile(this.location);
            if (file == null) {
                file = LogRecordBrowser.this.fileBrowser.findNext(this.location, this.max);
                pos = -1L;
            }
            if (file != null) {
                OneFileRecordIterator current = new OneFileRecordIterator(file, this.max, this.recFilter);
                if (pos > 0L) {
                    RepositoryLogRecord rec = null;
                    if (current.setPosition(pos)) {
                        rec = current.next();
                    }
                    if (rec == null || !this.location.equals(rec.getRepositoryPointer())) {
                        logger.logp(Level.WARNING, className, "getFirstIterator", "HPEL_NoRecordAtLocation");
                        current.close();
                        return null;
                    }
                }
                return current;
            }
            return null;
        }

        @Override
        public long getTimestamp() {
            return LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(new File(this.location.getFileId()));
        }
    }

    private class OnePidRecordListMintimeImpl
    extends OnePidRecordListImpl {
        private final File file;
        private final long min;

        OnePidRecordListMintimeImpl(File file, long min, long max, IInternalRecordFilter recFilter) {
            super(max, recFilter);
            this.file = file;
            this.min = min;
        }

        @Override
        protected OneFileRecordIterator getFirstIterator() {
            if (this.file != null) {
                return new OneFileRecordIterator(this.file, this.max, this.recFilter){

                    @Override
                    protected boolean verifyMin(RepositoryLogRecordImpl nextRecord) {
                        return OnePidRecordListMintimeImpl.this.min < 0L || OnePidRecordListMintimeImpl.this.min <= nextRecord.getMillis();
                    }
                };
            }
            return null;
        }

        @Override
        public long getTimestamp() {
            return LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(this.file);
        }
    }

    public abstract class OnePidRecordListImpl {
        protected final long max;
        protected final IInternalRecordFilter recFilter;
        protected Properties header = null;
        private final ArrayList<OneFileRecordStatistics> startList = new ArrayList();
        private final ArrayList<OneFileRecordStatistics> endList = new ArrayList();
        private int adjustment = 0;
        private int total = -1;

        OnePidRecordListImpl(long max, IInternalRecordFilter recFilter) {
            this.max = max;
            this.recFilter = recFilter;
        }

        public RemoteRepositoryCache getCache() {
            this.total();
            if (!this.startList.isEmpty()) {
                this.countNow(this.startList.get(0), this.adjustment == 0);
            }
            if (!this.endList.isEmpty() && this.total > 1) {
                this.countNow(this.endList.get(0), false);
            }
            int count = 0;
            for (OneFileRecordStatistics stat : this.startList) {
                if (!stat.allCounted) break;
                ++count;
            }
            byte[][] start = new byte[count][];
            int i = 0;
            for (OneFileRecordStatistics stat : this.startList) {
                if (!stat.allCounted) break;
                start[i++] = stat.toBytes();
            }
            count = 0;
            for (OneFileRecordStatistics stat : this.endList) {
                if (!stat.allCounted) break;
                ++count;
            }
            byte[][] end = new byte[count][];
            i = 0;
            for (OneFileRecordStatistics stat : this.endList) {
                if (!stat.allCounted) break;
                end[i++] = stat.toBytes();
            }
            return new RemoteRepositoryCache(this.total, start, end);
        }

        public void setCache(RemoteRepositoryCache cache) {
            OneFileRecordIterator it;
            this.total = cache.getTotal();
            this.startList.clear();
            for (byte[] fileCache : cache.getStart()) {
                try {
                    this.startList.add(new OneFileRecordStatistics(fileCache));
                }
                catch (IllegalArgumentException ex) {
                    --this.total;
                }
            }
            this.endList.clear();
            for (byte[] fileCache : cache.getEnd()) {
                try {
                    this.endList.add(new OneFileRecordStatistics(fileCache));
                }
                catch (IllegalArgumentException ex) {
                    --this.total;
                }
            }
            if ((this.startList.isEmpty() || this.endList.isEmpty()) && (this.total > 1 || this.total > 0 && this.startList.isEmpty() && this.endList.isEmpty())) {
                this.total = -1;
                this.total();
            }
            this.adjustment = -1;
            if (this.total > 0 && (it = this.getFirstIterator()) != null) {
                int i = 0;
                long timestamp = LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(it.file);
                for (OneFileRecordStatistics stat : this.startList) {
                    if (timestamp == LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(stat.file)) {
                        this.adjustment = i;
                        break;
                    }
                    ++i;
                }
                if (this.adjustment < 0) {
                    i = this.total - 1;
                    for (OneFileRecordStatistics stat : this.endList) {
                        if (timestamp == LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(stat.file)) {
                            this.adjustment = i;
                            break;
                        }
                        --i;
                    }
                }
                if (this.adjustment < 0) {
                    if (timestamp < LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(this.endList.get((int)(this.endList.size() - 1)).file) && timestamp > LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(this.startList.get((int)(this.startList.size() - 1)).file) && this.total > this.startList.size() + this.endList.size()) {
                        this.adjustment = this.startList.size();
                    } else {
                        this.total = -1;
                        this.total();
                    }
                }
            }
            if (this.adjustment < 0) {
                this.adjustment = 0;
            }
        }

        public Properties getHeader() {
            if (this.header == null) {
                AllAcceptVerifier filter = new AllAcceptVerifier();
                File backup = LogRecordBrowser.this.fileBrowser.findNext((File)null, -1L);
                while (backup != null && this.header == null) {
                    OneFileRecordIterator it = new OneFileRecordIterator(backup, -1L, filter);
                    this.header = it.header;
                    it.close();
                    backup = LogRecordBrowser.this.fileBrowser.findNext(backup, -1L);
                }
            }
            return this.header;
        }

        public Properties getParsedHeader() {
            int index;
            Properties result = new Properties();
            result.put("ProcessId", LogRecordBrowser.this.fileBrowser.getProcessId());
            String label = LogRecordBrowser.this.fileBrowser.getLabel();
            int n = index = label == null ? -1 : label.indexOf(95);
            if (index > 0 && index < label.length() - 1) {
                result.put("isZOS", "Y");
                result.put("jobName", label.substring(0, index));
                result.put("jobId", label.substring(index + 1));
            }
            return result;
        }

        public Iterator<RepositoryLogRecord> getNewIterator(int offset, int length) {
            OnePidRecordIterator result = new OnePidRecordIterator(this);
            this.setRange(result, offset, length);
            return result;
        }

        OneFileRecordStatistics getStatistics(int index, boolean complete) {
            OneFileRecordStatistics result;
            this.total();
            if ((index += this.adjustment) < 0 || index >= this.total) {
                return null;
            }
            if (index < (this.total + this.startList.size() - this.endList.size()) / 2) {
                long endTimestamp;
                OneFileRecordStatistics end = this.endList.isEmpty() ? null : this.endList.get(this.endList.size() - 1);
                long l = endTimestamp = end == null ? -1L : LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(end.file);
                while (index >= this.startList.size()) {
                    File file = LogRecordBrowser.this.fileBrowser.findNext(this.startList.get((int)(this.startList.size() - 1)).file, this.max);
                    if (file == null || endTimestamp > 0L && endTimestamp <= LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(file)) {
                        this.total = this.startList.size() + this.endList.size();
                        return end;
                    }
                    this.startList.add(new OneFileRecordStatistics(file));
                }
                result = this.startList.get(index);
            } else {
                long endTimestamp;
                OneFileRecordStatistics start = this.startList.isEmpty() ? null : this.startList.get(this.startList.size() - 1);
                long l = endTimestamp = start == null ? -1L : LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(start.file);
                while (this.total - index - 1 >= this.endList.size()) {
                    File file = LogRecordBrowser.this.fileBrowser.findPrev(this.endList.get((int)(this.endList.size() - 1)).file, endTimestamp);
                    if (file == null || endTimestamp == LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(file)) {
                        this.total = this.startList.size() + this.endList.size();
                        index = this.startList.size();
                        continue;
                    }
                    this.endList.add(new OneFileRecordStatistics(file));
                }
                result = this.endList.get(this.total - index - 1);
            }
            if (complete) {
                this.countNow(result, index == 0);
            }
            return result;
        }

        private void countNow(OneFileRecordStatistics result, boolean isFirst) {
            if (!result.allCounted) {
                RepositoryLogRecord record;
                OneFileRecordIterator it;
                OneFileRecordIterator oneFileRecordIterator = it = isFirst ? this.getFirstIterator() : new OneFileRecordIterator(result.file, this.max, this.recFilter);
                while ((record = it.next()) != null) {
                    result.count(record);
                }
                it.close();
                result.allCounted = true;
            }
        }

        public OneFileRecordIterator getIterator(int index) {
            OneFileRecordIterator result;
            OneFileRecordStatistics stats = this.getStatistics(index, false);
            if (stats == null) {
                return null;
            }
            OneFileRecordIterator oneFileRecordIterator = result = index == 0 ? this.getFirstIterator() : new OneFileRecordIterator(stats.file, this.max, this.recFilter);
            if (result.header == null) {
                result.header = this.getHeader();
            }
            return result;
        }

        protected abstract OneFileRecordIterator getFirstIterator();

        private int total() {
            if (this.total < 0) {
                this.startList.clear();
                this.endList.clear();
                OneFileRecordIterator it = this.getFirstIterator();
                if (it == null) {
                    this.total = 0;
                } else {
                    File last;
                    this.startList.add(new OneFileRecordStatistics(it.file));
                    File file = last = this.max < 0L ? LogRecordBrowser.this.fileBrowser.findPrev(null, -1L) : LogRecordBrowser.this.fileBrowser.findByMillis(this.max);
                    if (LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(last) == LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(it.file)) {
                        this.total = 1;
                    } else {
                        this.endList.add(new OneFileRecordStatistics(last));
                        this.total = LogRecordBrowser.this.fileBrowser.count(it.file, last);
                    }
                    if (this.header == null) {
                        this.header = it.header;
                    }
                    it.close();
                }
            }
            return this.total > 0 ? this.total - this.adjustment : this.total;
        }

        void setRange(OnePidRecordIterator it, int offset, int length) {
            OneFileRecordStatistics result;
            int index;
            if (offset == 0 && length < 0) {
                it.setRange(0, 0, -1);
                return;
            }
            int n = index = offset < 0 ? this.total() - 1 : 0;
            while ((result = this.getStatistics(index, true)) != null) {
                if (offset < 0) {
                    if (result.size >= -offset) {
                        it.setRange(index, result.size + offset, length);
                        return;
                    }
                    offset += result.size;
                    --index;
                    continue;
                }
                if (result.size > offset) {
                    it.setRange(index, offset, length);
                    return;
                }
                offset -= result.size;
                ++index;
            }
            if (offset < 0) {
                length = length > -offset ? length + offset : 0;
                it.setRange(0, 0, length);
            } else {
                it.setRange(-1, -1, -1);
            }
        }

        public abstract long getTimestamp();
    }

    private final class OneFileRecordStatistics {
        final File file;
        boolean allCounted = false;
        int size = 0;
        long firstId = -1L;
        long lastId = -1L;

        OneFileRecordStatistics(File file) {
            this.file = file;
        }

        OneFileRecordStatistics(byte[] value) throws IllegalArgumentException {
            RemoteRepositoryCache.RemoteOneFileCache result = new RemoteRepositoryCache.RemoteOneFileCache(value);
            long timestamp = result.getTimestamp();
            this.file = LogRecordBrowser.this.fileBrowser.findByMillis(timestamp);
            if (this.file == null) {
                throw new IllegalArgumentException("File with indicated timestamp is most probably purged already");
            }
            if (timestamp != LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(this.file)) {
                throw new IllegalArgumentException("Search on timestamp result in different file than expected. Most probably bytes are for different repository");
            }
            this.size = result.getSize();
            this.firstId = result.getFirstId();
            this.lastId = result.getLastId();
            this.allCounted = true;
        }

        byte[] toBytes() throws IllegalStateException {
            if (!this.allCounted) {
                throw new IllegalStateException("This method can be called only when all data is collected for the file");
            }
            RemoteRepositoryCache.RemoteOneFileCache result = new RemoteRepositoryCache.RemoteOneFileCache(LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(this.file), this.size, this.firstId, this.lastId);
            return result.toByteArray();
        }

        void update(OneFileRecordStatistics other) {
            if (!this.allCounted) {
                this.size = other.size;
                this.firstId = other.firstId;
                this.lastId = other.lastId;
                this.allCounted = true;
            }
        }

        void count(RepositoryLogRecord record) {
            ++this.size;
            this.lastId = ((RepositoryLogRecordImpl)record).getInternalSeqNumber();
            if (this.firstId < 0L) {
                this.firstId = this.lastId;
            }
        }
    }

    public class OnePidRecordIterator
    implements Iterator<RepositoryLogRecord>,
    Comparable<OnePidRecordIterator> {
        private int listIndex = -1;
        private int countDown = -1;
        private OneFileRecordIterator current = null;
        private OneFileRecordStatistics stats = null;
        private RepositoryLogRecord nextRecord = null;
        private final OnePidRecordListImpl parent;

        OnePidRecordIterator(OnePidRecordListImpl parent) {
            this.parent = parent;
        }

        public int size(int index) {
            return this.parent.getStatistics((int)index, (boolean)true).size;
        }

        public long getFirstId(int index) {
            return this.parent.getStatistics((int)index, (boolean)true).firstId;
        }

        public long getLastId(int index) {
            return this.parent.getStatistics((int)index, (boolean)true).lastId;
        }

        public int total() {
            return this.parent.total();
        }

        public void close() {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
            this.listIndex = -1;
        }

        public boolean isDone() {
            return this.listIndex < 0;
        }

        public void setRange(int index, int offset, int length) {
            if (this.current != null) {
                throw new RuntimeException("Incorrect invokation of the setRange() method. current != null.");
            }
            this.listIndex = index;
            if (index >= 0) {
                while (offset > 0 && this.next() != null) {
                    --offset;
                }
            }
            this.countDown = length;
        }

        @Override
        public boolean hasNext() {
            while (this.listIndex >= 0 && this.nextRecord == null) {
                this.nextRecord = this.getNext(-1L);
            }
            return this.nextRecord != null;
        }

        public RepositoryLogRecord findNext(long refSequenceNumber) {
            if (this.nextRecord == null) {
                this.nextRecord = this.getNext(refSequenceNumber);
            }
            RepositoryLogRecord result = this.nextRecord;
            this.nextRecord = null;
            return result;
        }

        private RepositoryLogRecord getNext(long refSequenceNumber) {
            RepositoryLogRecord result;
            if (this.current == null) {
                if (this.listIndex >= 0) {
                    this.current = this.parent.getIterator(this.listIndex);
                }
                if (this.current == null) {
                    this.close();
                    return null;
                }
                this.stats = new OneFileRecordStatistics(this.current.file);
            }
            if (this.countDown == 0) {
                this.close();
                return null;
            }
            while ((result = this.current.findNext(refSequenceNumber)) == null) {
                if (refSequenceNumber >= 0L && !this.current.isDone()) {
                    return null;
                }
                this.current.close();
                this.parent.getStatistics(this.listIndex, false).update(this.stats);
                this.current = this.parent.getIterator(++this.listIndex);
                if (this.current == null) {
                    this.close();
                    return null;
                }
                this.stats = new OneFileRecordStatistics(this.current.file);
                if (refSequenceNumber >= 0L) continue;
                return null;
            }
            this.stats.count(result);
            if (this.countDown > 0) {
                --this.countDown;
            }
            return result;
        }

        @Override
        public RepositoryLogRecord next() {
            if (this.listIndex < 0 || this.nextRecord == null && !this.hasNext()) {
                return null;
            }
            RepositoryLogRecord result = this.nextRecord;
            this.nextRecord = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method is not applicable to this class");
        }

        private long getCurrentTimestamp() {
            if (this.current == null) {
                if (this.listIndex < 0) {
                    return -1L;
                }
                return 0L;
            }
            return LogRecordBrowser.this.fileBrowser.getLogFileTimestamp(this.current.file);
        }

        @Override
        public int compareTo(OnePidRecordIterator o) {
            long otherTimestamp;
            long thisTimestamp = this.getCurrentTimestamp();
            if (thisTimestamp == (otherTimestamp = o.getCurrentTimestamp())) {
                return 0;
            }
            if (thisTimestamp < 0L) {
                return 1;
            }
            if (otherTimestamp < 0L) {
                return -1;
            }
            return thisTimestamp < otherTimestamp ? -1 : 1;
        }
    }

    private class OneFileRecordIterator
    extends OneLogFileRecordIterator {
        private OneFileRecordIterator(File file, long max, IInternalRecordFilter recFilter) {
            super(file, max, recFilter);
        }

        @Override
        protected RepositoryPointer getPointer(File file, long position) {
            return new RepositoryPointerImpl(LogRecordBrowser.this.fileBrowser.getIds(), file.getName(), position);
        }
    }

    protected static interface IInternalRecordFilter {
        public boolean filterAccepts(LogRecordSerializer var1, DataInputStream var2, RepositoryLogRecordImpl var3) throws IOException;
    }

    private static class FullFilterVerifier
    implements IInternalRecordFilter {
        private final LogRecordFilter filter;

        FullFilterVerifier(LogRecordFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean filterAccepts(LogRecordSerializer formatter, DataInputStream reader, RepositoryLogRecordImpl nextRecord) throws IOException {
            formatter.deserializeLogHead(nextRecord, reader);
            formatter.deserializeLogRecord(nextRecord, reader);
            return this.filter.accept(nextRecord);
        }
    }

    private static class HeadFilterVerifier
    implements IInternalRecordFilter {
        private final LogRecordHeaderFilter filter;

        HeadFilterVerifier(LogRecordHeaderFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean filterAccepts(LogRecordSerializer formatter, DataInputStream reader, RepositoryLogRecordImpl nextRecord) throws IOException {
            formatter.deserializeLogHead(nextRecord, reader);
            boolean result = this.filter.accept(nextRecord);
            if (result) {
                formatter.deserializeLogRecord(nextRecord, reader);
            }
            return result;
        }
    }

    private static class AllAcceptVerifier
    implements IInternalRecordFilter {
        private AllAcceptVerifier() {
        }

        @Override
        public boolean filterAccepts(LogRecordSerializer formatter, DataInputStream reader, RepositoryLogRecordImpl nextRecord) throws IOException {
            formatter.deserializeLogHead(nextRecord, reader);
            formatter.deserializeLogRecord(nextRecord, reader);
            return true;
        }
    }
}

