/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras.hpel;

import com.ibm.ejs.ras.hpel.StackFinder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private final String ivBundleName;
    private Locale ivLocale = Locale.getDefault();
    private StackFinder finder = null;
    private static final String CLASS_NAME = "com.ibm.ejs.ras.hpel.Messages";

    private Messages(String bundleName) {
        this.ivBundleName = bundleName;
    }

    public static String getStringFromBundle(String resourceBundleName, String msgKey, Locale tmpLocale, String rawMessage) {
        return Messages.getStringFromBundle(null, resourceBundleName, msgKey, tmpLocale, rawMessage);
    }

    public static String getFormattedMessageFromLocalizedMessage(String traceString, Object[] newParms, boolean b) {
        String retVal = "";
        try {
            retVal = MessageFormat.format(traceString, newParms);
            if (null == retVal && b) {
                retVal = traceString;
            }
        }
        catch (IllegalArgumentException e) {
            retVal = traceString;
        }
        return retVal;
    }

    public static String getStringFromBundle(ResourceBundle resourceBundle, String resourceBundleName, String messageKey, Locale locale, String defaultMessage) {
        if (null == resourceBundle) {
            Messages m = Messages.getTraceNLS(resourceBundleName);
            if (null != locale) {
                m.ivLocale = locale;
            }
            resourceBundle = m.getResourceBundle();
        }
        String retVal = defaultMessage;
        try {
            String tmpRetVal;
            String string = tmpRetVal = resourceBundle == null ? null : resourceBundle.getString(messageKey);
            if (null != tmpRetVal) {
                retVal = tmpRetVal;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return retVal;
    }

    public String getFormattedMessage(String messageKey, Object[] param, String defaultKey) {
        String key = this.getString(messageKey);
        String retVal = MessageFormat.format(key, param);
        return retVal;
    }

    public String getString(String messageKey) {
        String retVal = messageKey;
        ResourceBundle rb = this.getResourceBundle();
        if (null != rb) {
            try {
                String tmpRetVal = rb.getString(messageKey);
                if (null != tmpRetVal) {
                    retVal = tmpRetVal;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return retVal;
    }

    private ResourceBundle getResourceBundle() {
        ResourceBundle rb = null;
        if (null != this.ivBundleName && !"".equals(this.ivBundleName.trim())) {
            ClassLoader classLoader = null;
            try {
                classLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e.getMessage());
            }
            if (null != classLoader) {
                try {
                    rb = ResourceBundle.getBundle(this.ivBundleName, this.ivLocale, classLoader);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (null == rb) {
                rb = this.locateBundleFromCallee();
            }
            if (null == rb) {
                try {
                    rb = ResourceBundle.getBundle(this.ivBundleName, this.ivLocale);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        return rb;
    }

    private ResourceBundle locateBundleFromCallee() {
        Class<?> aClass;
        ResourceBundle rb = null;
        if (this.finder == null) {
            this.finder = StackFinder.getInstance();
        }
        if ((aClass = this.finder.getCaller()) != null) {
            ClassLoader classLoader = null;
            try {
                classLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return aClass.getClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e.getMessage());
            }
            try {
                rb = ResourceBundle.getBundle(this.ivBundleName, this.ivLocale, classLoader);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return rb;
    }

    public static Messages getTraceNLS(String string) {
        return new Messages(string);
    }
}

