/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.wsat.service.Handler;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.utils.WSATOSGIService;
import com.ibm.ws.wsat.utils.WSCoorUtil;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.ContextUtils;

public class WSATCompleteTransInterceptor
extends AbstractPhaseInterceptor<Message> {
    final TraceComponent tc = Tr.register(WSATCompleteTransInterceptor.class, (String)"WSAT", null);
    private final LibertyApplicationBus.Type busType;

    public WSATCompleteTransInterceptor(String phase, LibertyApplicationBus.Type type) {
        super(phase);
        this.busType = type;
    }

    public void handleMessage(Message message) throws Fault {
        boolean isOutbound = ContextUtils.isOutbound((Message)message);
        try {
            WSCoorUtil.checkHandlerServiceReady();
            if (!isOutbound) {
                if (this.busType == LibertyApplicationBus.Type.CLIENT) {
                    Handler handler = WSATOSGIService.getInstance().getHandlerService();
                    if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)this.tc, (String)"handleMessage", (Object[])new Object[]{"Execute handleClientResponse in Client Inbound Interceptor, " + Message.RESPONSE_CODE + "=" + message.get((Object)Message.RESPONSE_CODE)});
                    }
                    handler.handleClientResponse();
                }
            } else if (this.busType == LibertyApplicationBus.Type.SERVER) {
                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)"handleMessage", (Object[])new Object[]{"Execute handleServerResponse in Server Outbound Interceptor"});
                }
                WSATOSGIService.getInstance().getHandlerService().handleServerResponse();
            }
        }
        catch (WSATException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsat.interceptor.WSATCompleteTransInterceptor", (String)"102");
            throw new Fault((Throwable)e);
        }
        finally {
            Exchange ex = message.getExchange();
            Endpoint ep = (Endpoint)ex.get(Endpoint.class);
            if (ep != null) {
                if (this.busType == LibertyApplicationBus.Type.SERVER) {
                    ep.getOutInterceptors().remove((Object)this);
                } else if (this.busType == LibertyApplicationBus.Type.CLIENT) {
                    ep.getInInterceptors().remove((Object)this);
                }
            }
        }
    }

    public void handleFault(Message message) {
        WSCoorUtil.checkHandlerServiceReady();
        boolean isOutbound = ContextUtils.isOutbound((Message)message);
        try {
            if (!isOutbound) {
                WSATOSGIService.getInstance().getHandlerService().handleClientFault();
            } else {
                WSATOSGIService.getInstance().getHandlerService().handleServerFault();
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsat.interceptor.WSATCompleteTransInterceptor", (String)"119");
            throw new Fault(e);
        }
    }
}

