/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.tm.impl;

import com.ibm.tx.jta.DestroyXAResourceException;
import com.ibm.tx.jta.XAResourceFactory;
import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATCoordinatorTran;
import com.ibm.ws.wsat.common.impl.WSATEndpoint;
import com.ibm.ws.wsat.common.impl.WSATParticipant;
import com.ibm.ws.wsat.common.impl.WSATTransaction;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.impl.RegistrationImpl;
import com.ibm.ws.wsat.tm.impl.ParticipantResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.transaction.xa.XAResource;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"type=com.ibm.ws.wsat.Participant", "service.vendor=IBM"})
public class ParticipantFactoryService
implements XAResourceFactory {
    private static final String CLASS_NAME = ParticipantFactoryService.class.getName();
    private static final TraceComponent TC = Tr.register(ParticipantFactoryService.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private final RegistrationImpl registrationService = RegistrationImpl.getInstance();
    static final long serialVersionUID = 440123473334413399L;

    /*
     * WARNING - void declaration
     */
    public static <T extends WSATEndpoint> Serializable serialize(T endpoint) {
        ArrayList<Byte> data;
        block3: {
            data = null;
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bout);
                out.writeObject(endpoint);
                out.flush();
                out.close();
                byte[] bb = bout.toByteArray();
                data = new ArrayList<Byte>(bb.length);
                for (byte b : bb) {
                    data.add(b);
                }
            }
            catch (Exception bout) {
                void e;
                FFDCFilter.processException((Throwable)bout, (String)"com.ibm.ws.wsat.tm.impl.ParticipantFactoryService", (String)"71", null, (Object[])new Object[]{endpoint});
                if (!TC.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)TC, (String)"Serialization problem: {0}", (Object[])new Object[]{e});
            }
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends WSATEndpoint> T deserialize(Serializable key) {
        WSATEndpoint endpoint = null;
        if (key instanceof ArrayList) {
            try {
                ArrayList data = (ArrayList)key;
                byte[] bb = new byte[data.size()];
                for (int i = 0; i < data.size(); ++i) {
                    bb[i] = (Byte)data.get(i);
                }
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bb));
                endpoint = (WSATEndpoint)in.readObject();
            }
            catch (Exception data) {
                FFDCFilter.processException((Throwable)data, (String)"com.ibm.ws.wsat.tm.impl.ParticipantFactoryService", (String)"92", null, (Object[])new Object[]{key});
                if (TC.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)TC, (String)"Deserialization problem: {0}", (Object[])new Object[]{e});
                }
            }
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Incorrect resource info type: {0}", (Object[])new Object[]{key.getClass()});
        }
        return (T)endpoint;
    }

    public synchronized XAResource getXAResource(Serializable xaResInfo) throws XAResourceNotAvailableException {
        ParticipantResource xaRes = null;
        WSATParticipant part = (WSATParticipant)ParticipantFactoryService.deserialize(xaResInfo);
        if (part == null) {
            throw new XAResourceNotAvailableException((Throwable)new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"UNABLE_TO_DESERIALIZE_CWLIB0208", (Object[])new Object[0])));
        }
        WSATCoordinatorTran wsatTran = this.reconstructTran(part);
        WSATParticipant participant = this.reconstructParticipant(wsatTran, part);
        xaRes = new ParticipantResource(participant);
        return xaRes;
    }

    public synchronized void destroyXAResource(XAResource xaRes) throws DestroyXAResourceException {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Destroy XAResource: {0}", (Object[])new Object[]{xaRes});
        }
    }

    /*
     * WARNING - void declaration
     */
    private WSATCoordinatorTran reconstructTran(WSATParticipant part) throws XAResourceNotAvailableException {
        String globalId = part.getGlobalId();
        WSATCoordinatorTran wsatTran = WSATTransaction.getCoordTran(globalId);
        if (wsatTran == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Cannot locate coordinator transaction, recovering state: {0}", (Object[])new Object[]{globalId});
            }
            try {
                this.registrationService.activate(globalId, 0L, true);
                wsatTran = WSATTransaction.getCoordTran(globalId);
            }
            catch (WSATException wSATException) {
                void e;
                FFDCFilter.processException((Throwable)wSATException, (String)"com.ibm.ws.wsat.tm.impl.ParticipantFactoryService", (String)"149", (Object)this, (Object[])new Object[]{part});
                throw new XAResourceNotAvailableException((Throwable)e);
            }
        }
        return wsatTran;
    }

    private WSATParticipant reconstructParticipant(WSATCoordinatorTran wsatTran, WSATParticipant part) throws XAResourceNotAvailableException {
        WSATParticipant participant = wsatTran.getParticipant(part.getId());
        if (participant == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Cannot locate participant, recovering state: {0}", (Object[])new Object[]{part});
            }
            participant = wsatTran.addParticipant(part);
        }
        return participant;
    }
}

