/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.CacheableServlet;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.servlet.CacheHook;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentCacheProcessor;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.cache.web.config.ConfigManager;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;

public class ServletWrapper
implements CacheableServlet,
Servlet,
HttpJspPage {
    private static final long serialVersionUID = 5502601840576150659L;
    private static TraceComponent tc = Tr.register(ServletWrapper.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    Servlet proxied = null;
    boolean wrapsCacheableServlet = false;
    private HashMap<String, ConfigEntry> activeConfigEntries = new HashMap();

    public ServletWrapper(Servlet s) {
        this.proxied = s;
        this.wrapsCacheableServlet = s instanceof CacheableServlet;
    }

    public void configChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareMetadata(CacheProxyRequest request, CacheProxyResponse response) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("prepareMetadata: " + this.proxied), (Object[])new Object[0]);
        }
        FragmentInfo fragmentInfo = null;
        if (this.wrapsCacheableServlet) {
            CacheableServlet cacheableServlet = (CacheableServlet)this.proxied;
            String id = cacheableServlet.getId(request);
            int sharingPolicy = cacheableServlet.getSharingPolicy(request);
            if (id == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"cacheId is null", (Object[])new Object[0]);
                }
            } else {
                fragmentInfo = (FragmentInfo)request.getFragmentInfo();
                String requestType = request.getMethod();
                StringBuffer idBuf = new StringBuffer();
                if (id.indexOf("requestType=" + requestType) == -1 && (requestType.equals("GET") || requestType.equals("POST")) && !fragmentInfo.isIgnoreGetPost()) {
                    fragmentInfo.addDataId(id);
                    idBuf.append(id).append(':').append("requestType=" + requestType);
                    id = idBuf.toString();
                }
                fragmentInfo.setId(id);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sharingPolicy: " + sharingPolicy), (Object[])new Object[0]);
                }
                fragmentInfo.setSharingPolicy(sharingPolicy);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareMetadata");
            }
            return;
        }
        ConfigEntry configEntry = null;
        String contextRoot = request.getContextPath();
        String portletContextRoot = request._getContextPath();
        String uri = this.buildName(request);
        configEntry = ConfigManager.getInstance().getServletConfigEntry(this.proxied, uri, contextRoot);
        fragmentInfo = (FragmentInfo)request.getFragmentInfo();
        if (configEntry == null) {
            fragmentInfo.setId(null);
        } else {
            this.activeConfigEntries.put(configEntry.name, configEntry);
            FragmentCacheProcessor fcp = (FragmentCacheProcessor)ConfigManager.getInstance().getCacheProcessor(configEntry);
            try {
                ArrayList invalidations;
                JSPCache jspCache;
                fcp.execute(request, response, this.proxied);
                fragmentInfo.setId(fcp.getId());
                if (fcp.getId() != null) {
                    fcp.populateFragmentInfo(fragmentInfo);
                }
                if ((jspCache = (JSPCache)ServerCache.getJspCache((String)configEntry.instanceName)) != null && (invalidations = fcp.getInvalidationIds()) != null) {
                    int sz = invalidations.size();
                    for (int i = 0; i < sz; ++i) {
                        jspCache.invalidateById((String)invalidations.get(i), i == sz - 1);
                    }
                }
            }
            finally {
                ConfigManager.getInstance().returnCacheProcessor(fcp);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareMetadata");
        }
    }

    String buildName(CacheProxyRequest request) {
        int i;
        String s = "";
        String contextPath = request._getContextPath();
        String relativeUri = request.getRelativeUri();
        s = contextPath + relativeUri;
        if (contextPath != null && contextPath.equals("/") && relativeUri != null && relativeUri.startsWith("/")) {
            s = relativeUri;
        }
        if ((i = s.indexOf(63)) == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    @Override
    public String getId(HttpServletRequest req) {
        CacheProxyRequest request = (CacheProxyRequest)req;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getId() for " + this.proxied + " returned " + request.getFragmentInfo().getId()), (Object[])new Object[0]);
        }
        return request.getFragmentInfo().getId();
    }

    @Override
    public int getSharingPolicy(HttpServletRequest req) {
        CacheProxyRequest request = (CacheProxyRequest)req;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getSharingPolicy() for " + this.proxied + " returned " + request.getFragmentInfo().getSharingPolicy()), (Object[])new Object[0]);
        }
        return request.getFragmentInfo().getSharingPolicy();
    }

    public void destroy() {
        CacheConfig cacheConfig = ServerCache.getCacheService().getCacheConfig();
        if (!FrameworkState.isStopping()) {
            for (ConfigEntry ce : this.activeConfigEntries.values()) {
                JSPCache jspCache = (JSPCache)ServerCache.getJspCache((String)ce.instanceName);
                if (jspCache == null) continue;
                if (cacheConfig.disableTemplateInvalidation) {
                    Tr.info((TraceComponent)tc, (String)"dynacache.error", (Object[])new Object[]{"Error type=destroy warning. Skipping template invalidation for JSP " + ce.name});
                    continue;
                }
                jspCache.invalidateByTemplate(ce.name, true);
            }
        }
        this.activeConfigEntries.clear();
        this.proxied.destroy();
    }

    public ServletConfig getServletConfig() {
        return this.proxied.getServletConfig();
    }

    public String getServletInfo() {
        return this.proxied.getServletInfo();
    }

    public ServletContext getServletContext() {
        return this.proxied.getServletConfig().getServletContext();
    }

    public void init(ServletConfig sc) throws ServletException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init()", (Object[])new Object[0]);
        }
        this.proxied.init(sc);
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"service", (Object[])new Object[]{request, response});
            }
            CacheHook.handleServlet(this, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (ClassCastException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("request instanceof HttpServletRequest: " + (request instanceof HttpServletRequest)), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("response instanceof HttpServletRequest: " + (response instanceof HttpServletResponse)), (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)("Exception while calling Dynacache: " + ex.getMessage()), (Object[])new Object[0]);
            }
            this.skipCacheService(request, response);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"service");
        }
    }

    private void skipCacheService(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"skipCacheService", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Wanted a HttpServletRequest, HttpServletResponse got " + request + " and " + response + "  servicing as normal"), (Object[])new Object[0]);
        }
        this.serviceProxied(request, response);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"skipCacheService");
        }
    }

    public Servlet getProxiedServlet() {
        return this.proxied;
    }

    public void serviceProxied(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.proxied.service(request, response);
    }

    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ((HttpJspPage)this.proxied)._jspService(request, response);
    }

    public void jspInit() {
        ((HttpJspPage)this.proxied).jspInit();
    }

    public void jspDestroy() {
        ((HttpJspPage)this.proxied).jspDestroy();
    }
}

