/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.servlet.GrpcServlet;
import io.openliberty.grpc.internal.GrpcManagedObjectProvider;
import io.openliberty.grpc.internal.servlet.GrpcServletApplication;
import io.openliberty.grpc.server.monitor.GrpcMonitoringServerInterceptorService;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ApplicationStateListener.class, ServletContainerInitializer.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class GrpcServerComponent
implements ServletContainerInitializer,
ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(GrpcServerComponent.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
    private static HashMap<String, GrpcServletApplication> grpcApplications = new HashMap();
    private static Object grpcApplicationLock = new Object(){
        static final long serialVersionUID = 2138105442043872219L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.grpc.internal.servlet.GrpcServerComponent$1", 1.class, null, null);
        }
    };
    private static boolean useSecurity = false;
    private final String FEATUREPROVISIONER_REFERENCE_NAME = "featureProvisioner";
    private final String GRPC_MONITOR_NAME = "GrpcMonitoringServerInterceptorService";
    private final AtomicServiceReference<FeatureProvisioner> _featureProvisioner = new AtomicServiceReference("featureProvisioner");
    private static GrpcMonitoringServerInterceptorService monitorService = null;
    static final long serialVersionUID = -5623498481158915933L;

    @Activate
    protected void activate(ComponentContext cc) {
        this._featureProvisioner.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this._featureProvisioner.deactivate(cc);
    }

    @Reference(name="featureProvisioner", service=FeatureProvisioner.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setFeatureProvisioner(ServiceReference<FeatureProvisioner> ref) {
        this._featureProvisioner.setReference(ref);
    }

    protected void unsetFeatureProvisioner(FeatureProvisioner featureProvisioner) {
    }

    @Reference(name="GRPC_MONITOR_NAME", service=GrpcMonitoringServerInterceptorService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setMonitoringService(GrpcMonitoringServerInterceptorService service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setMonitoringService", (Object[])new Object[0]);
        }
        monitorService = service;
    }

    protected void unsetMonitoringService(GrpcMonitoringServerInterceptorService service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"unsetMonitoringService", (Object[])new Object[0]);
        }
        if (monitorService == service) {
            monitorService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartup(Set<Class<?>> ctx, ServletContext sc) throws ServletException {
        Object object = grpcApplicationLock;
        synchronized (object) {
            if (!grpcApplications.isEmpty()) {
                Set<String> services;
                GrpcServletApplication currentApp;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempting to load gRPC services for app {0}", (Object[])new Object[]{sc.getServletContextName()});
                }
                if ((currentApp = grpcApplications.get(((WebApp)sc).getApplicationName())) != null && (services = currentApp.getServiceClassNames()) != null) {
                    HashMap<String, BindableService> grpcServiceClasses = new HashMap<String, BindableService>();
                    for (String serviceClassName : services) {
                        BindableService service = this.newServiceInstanceFromClassName(currentApp, serviceClassName);
                        if (service == null) continue;
                        grpcServiceClasses.put(serviceClassName, service);
                    }
                    if (!grpcServiceClasses.isEmpty()) {
                        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                        if (cmd != null) {
                            currentApp.setAppName(cmd.getJ2EEName().getApplication());
                        }
                        for (BindableService service : grpcServiceClasses.values()) {
                            String serviceName = service.bindService().getServiceDescriptor().getName();
                            GrpcServlet grpcServlet = new GrpcServlet(new ArrayList(grpcServiceClasses.values()), ((WebApp)sc).getApplicationName());
                            ServletRegistration.Dynamic servletRegistration = sc.addServlet("grpcServlet:" + serviceName, (Servlet)grpcServlet);
                            servletRegistration.setAsyncSupported(true);
                            String urlPattern = "/" + serviceName + "/*";
                            servletRegistration.addMapping(new String[]{urlPattern});
                            currentApp.addServiceName(serviceName, sc.getContextPath(), service.getClass());
                            Tr.info((TraceComponent)tc, (String)"service.available", (Object[])new Object[]{cmd.getJ2EEName().getApplication(), urlPattern});
                        }
                        return;
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No gRPC services have been registered for app {0}", (Object[])new Object[]{sc.getServletContextName()});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private BindableService newServiceInstanceFromClassName(GrpcServletApplication grpcApp, String serviceClassName) {
        block3: {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> serviceClass = Class.forName(serviceClassName, true, cl);
                if (!Modifier.isAbstract(serviceClass.getModifiers())) {
                    ManagedObject<?> mo = GrpcManagedObjectProvider.createManagedObject(serviceClass);
                    grpcApp.addManagedObjectContext(mo.getContext());
                    return (BindableService)mo.getObject();
                }
            }
            catch (ManagedObjectException | ClassNotFoundException | IllegalArgumentException | SecurityException cl) {
                void e;
                FFDCFilter.processException((Throwable)cl, (String)"io.openliberty.grpc.internal.servlet.GrpcServerComponent", (String)"217", (Object)this, (Object[])new Object[]{grpcApp, serviceClassName});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"The following class extended io.grpc.BindableService but could not be loaded: {0} due to {1}", (Object[])new Object[]{serviceClassName, e});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGrpcServices(ApplicationInfo appInfo) {
        block6: {
            try {
                WebAnnotations webAnno = AnnotationsBetaHelper.getWebAnnotations((Container)appInfo.getContainer());
                AnnotationTargets_Targets annoTargets = webAnno.getAnnotationTargets();
                Set services = annoTargets.getAllImplementorsOf("io.grpc.BindableService");
                if (services == null || services.isEmpty() || services.isEmpty()) break block6;
                GrpcServletApplication currentApplication = new GrpcServletApplication();
                Object object = grpcApplicationLock;
                synchronized (object) {
                    for (String name : services) {
                        currentApplication.addServiceClassName(name);
                    }
                    grpcApplications.put(appInfo.getName(), currentApplication);
                }
            }
            catch (UnableToAdaptException unableToAdaptException) {
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"io.openliberty.grpc.internal.servlet.GrpcServerComponent", (String)"251", (Object)this, (Object[])new Object[]{appInfo});
            }
        }
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        this.setSecurityEnabled();
        this.initGrpcServices(appInfo);
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStopping(ApplicationInfo appInfo) {
        Object object = grpcApplicationLock;
        synchronized (object) {
            GrpcServletApplication currentApp;
            if (!grpcApplications.isEmpty() && (currentApp = grpcApplications.remove(appInfo.getName())) != null) {
                currentApp.destroy();
            }
        }
    }

    public void applicationStopped(ApplicationInfo appInfo) {
    }

    private void setSecurityEnabled() {
        Set currentFeatureSet = ((FeatureProvisioner)this._featureProvisioner.getService()).getInstalledFeatures();
        if (currentFeatureSet.contains("appSecurity-2.0") || currentFeatureSet.contains("appSecurity-1.0") || currentFeatureSet.contains("appSecurity-3.0")) {
            useSecurity = true;
            return;
        }
        useSecurity = false;
    }

    public static boolean isSecurityEnabled() {
        return useSecurity;
    }

    public static ServerInterceptor getMonitoringServerInterceptor(String serviceName, String appName) {
        if (monitorService != null) {
            return monitorService.createInterceptor(serviceName, appName);
        }
        return null;
    }
}

