/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebSSOUtils {
    public static final TraceComponent tc = Tr.register(WebSSOUtils.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    static final long serialVersionUID = 4136232152830714334L;

    public String getRequestUrlWithEncodedQueryString(HttpServletRequest req) {
        StringBuffer reqURL = req.getRequestURL();
        if (req.getQueryString() != null) {
            reqURL.append("?");
            reqURL.append(this.getUrlEncodedQueryString(req));
        }
        return reqURL.toString();
    }

    public String getUrlEncodedQueryString(HttpServletRequest req) {
        StringBuilder qs = new StringBuilder();
        Map params = req.getParameterMap();
        if (!params.isEmpty()) {
            qs.append(this.getUrlEncodedQueryStringFromParameterMap(params));
        }
        return qs.toString();
    }

    public String getUrlEncodedQueryStringFromParameterMap(Map<String, String[]> params) {
        StringBuilder qs = new StringBuilder();
        Iterator<Map.Entry<String, String[]>> iter = params.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String[]> param = iter.next();
            qs.append(this.getUrlEncodedParameterAndValues(param.getKey(), param.getValue()));
            if (!iter.hasNext() || qs.charAt(qs.length() - 1) == '&') continue;
            qs.append("&");
        }
        return qs.toString();
    }

    public String getUrlEncodedParameterAndValues(String key, String[] values) {
        StringBuilder paramAndValue = new StringBuilder();
        paramAndValue.append(WebUtils.urlEncode(key));
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                paramAndValue.append("=" + WebUtils.urlEncode(value));
                if (i >= values.length - 1) continue;
                paramAndValue.append("&" + WebUtils.urlEncode(key));
            }
        }
        return paramAndValue.toString();
    }

    protected ReferrerURLCookieHandler getCookieHandler() {
        WebAppSecurityConfig config = this.getWebAppSecurityConfig();
        if (config != null) {
            return config.createReferrerURLCookieHandler();
        }
        return new ReferrerURLCookieHandler(config);
    }

    WebAppSecurityConfig getWebAppSecurityConfig() {
        return WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
    }
}

