/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.provisioning;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public abstract class AbstractResourceRepository {
    protected abstract File getRootDirectory();

    protected abstract String getDefaultBaseLocation();

    protected abstract List<Resource> getResourcesBySymbolicName(String var1);

    protected abstract void includeBaseLocation(String var1);

    protected abstract boolean isBaseLocationIncluded(String var1);

    protected abstract void warnThatAnIFixWasIgnored(String var1, String var2, int var3, int var4, int var5);

    public File selectResource(String baseLocation, String symbolicName, VersionRange versionRange) {
        return this.selectResource(baseLocation, symbolicName, versionRange, true, false);
    }

    protected File selectResource(String baseLocation, String symbolicName, VersionRange versionRange, boolean performURICheck, boolean selectBaseBundle) {
        HashSet<String> baseLocationParts;
        if (baseLocation == null || "".equals(baseLocation)) {
            baseLocation = this.getDefaultBaseLocation();
        }
        if (!baseLocation.contains(",")) {
            Object candidateFile;
            if (performURICheck) {
                try {
                    candidateFile = new File(URI.create(baseLocation));
                    if (((File)candidateFile).exists() && ((File)candidateFile).isFile() && ((File)candidateFile).isAbsolute()) {
                        return this.validateR4Bundle((File)candidateFile);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (((File)(candidateFile = new File(this.getRootDirectory(), baseLocation))).exists() && ((File)candidateFile).isFile()) {
                return this.validateR4Bundle((File)candidateFile);
            }
            baseLocationParts = new HashSet();
            baseLocationParts.add(baseLocation);
        } else {
            baseLocationParts = new HashSet<String>(Arrays.asList(baseLocation.split(",")));
        }
        for (String baseLocationPart : baseLocationParts) {
            if (this.isBaseLocationIncluded(baseLocationPart = baseLocationPart.trim())) continue;
            this.includeBaseLocation(baseLocationPart);
        }
        List<Resource> candidateResources = this.getResourcesBySymbolicName(symbolicName);
        if (candidateResources != null) {
            Collections.sort(candidateResources);
            Resource bestMatch = null;
            for (Resource candidateResource : candidateResources) {
                if (!baseLocationParts.contains(candidateResource.getBaseLocation()) || !versionRange.includes(candidateResource.getVersion())) continue;
                if (bestMatch == null) {
                    if (!candidateResource.isFix()) {
                        return candidateResource.getFile();
                    }
                    bestMatch = candidateResource;
                    if (!"com.ibm.ws.kernel.boot".equals(symbolicName) && !"com.ibm.ws.kernel.boot.archive".equals(symbolicName)) continue;
                    return bestMatch.getFile();
                }
                int bestMatchMajor = bestMatch.getVersion().getMajor();
                int bestMatchMinor = bestMatch.getVersion().getMinor();
                int bestMatchMicro = bestMatch.getVersion().getMicro();
                if (bestMatchMajor == candidateResource.getVersion().getMajor() && bestMatchMinor == candidateResource.getVersion().getMinor() && bestMatchMicro == candidateResource.getVersion().getMicro()) {
                    if (candidateResource.isFix()) continue;
                    return selectBaseBundle ? candidateResource.getFile() : bestMatch.getFile();
                }
                this.warnThatAnIFixWasIgnored(bestMatch.getFile().getName(), bestMatch.getSymbolicName(), bestMatchMajor, bestMatchMinor, bestMatchMicro);
                if (!candidateResource.isFix()) {
                    return candidateResource.getFile();
                }
                bestMatch = candidateResource;
            }
            if (bestMatch != null && !bestMatch.isFix()) {
                return bestMatch.getFile();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File validateR4Bundle(File candidateFile) {
        JarFile jar;
        block3: {
            File file;
            jar = null;
            try {
                jar = new JarFile(candidateFile);
                Manifest man = jar.getManifest();
                if (man == null || man.getMainAttributes().getValue("Bundle-ManifestVersion") == null) break block3;
                file = candidateFile;
            }
            catch (IOException iOException) {
                Utils.tryToClose(jar);
            }
            catch (Throwable throwable) {
                Utils.tryToClose(jar);
                throw throwable;
            }
            Utils.tryToClose(jar);
            return file;
        }
        Utils.tryToClose(jar);
        return null;
    }

    protected abstract class Resource
    implements Comparable<Resource> {
        protected Resource() {
        }

        protected abstract File getFile();

        protected abstract String getBaseLocation();

        protected abstract Version getVersion();

        protected abstract boolean isFix();

        protected abstract String getSymbolicName();

        @Override
        public int compareTo(Resource other) {
            Version otherVersion = other.getVersion();
            Version thisVersion = this.getVersion();
            return otherVersion.compareTo(thisVersion);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof Resource && other.getClass() == this.getClass()) {
                return this.compareTo((Resource)other) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.getVersion().hashCode();
        }
    }
}

