/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedAssertionProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedAssertionProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData request, WSDocInfo wsDocInfo) throws WSSecurityException {
        Element encryptedDataElement;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found EncryptedAssertion element");
        }
        if ((encryptedDataElement = WSSecurityUtil.getDirectChildElement(elem, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#")) == null) {
            return Collections.emptyList();
        }
        String typeStr = encryptedDataElement.getAttributeNS(null, "Type");
        if (typeStr != null && !"http://www.w3.org/2001/04/xmlenc#Element".equals(typeStr)) {
            throw new WSSecurityException(3, "badElement", new Object[]{"Element", typeStr});
        }
        QName el = new QName(encryptedDataElement.getNamespaceURI(), encryptedDataElement.getLocalName());
        Processor proc = request.getWssConfig().getProcessor(el);
        if (proc != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing decrypted element with: " + proc.getClass().getName());
            }
            return proc.handleToken(encryptedDataElement, request, wsDocInfo);
        }
        return Collections.emptyList();
    }
}

