/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.collector.Client;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ClientPool {
    private static final TraceComponent tc = Tr.register(ClientPool.class, null, null);
    private final AtomicInteger numClientsClosed = new AtomicInteger(0);
    private final int numClients;
    LinkedBlockingDeque<Client> clients;
    static final long serialVersionUID = -5142190197618849403L;

    @FFDCIgnore(value={InterruptedException.class})
    public ClientPool(String sslConfig, SSLSupport sslSupport, int numClients) throws SSLException {
        this.clients = new LinkedBlockingDeque(numClients);
        this.numClients = numClients;
        for (int i = 0; i < numClients; ++i) {
            Client client = this.createClient(sslConfig, sslSupport);
            boolean done = false;
            while (!done) {
                try {
                    this.clients.put(client);
                    done = true;
                }
                catch (InterruptedException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)"InterruptedException during <init> - will retry", (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("pool created  - " + (numClients - this.clients.remainingCapacity()) + " of " + numClients + " clients available."), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={InterruptedException.class})
    public Client checkoutClient() {
        Object client;
        block4: {
            client = null;
            try {
                while (client == null && this.numClientsClosed.get() == 0) {
                    client = this.clients.poll(200L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"InterruptedException during checkout", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            int clientHash = client != null ? client.hashCode() : 0;
            Tr.event((TraceComponent)tc, (String)("post-checkout - (" + clientHash + ") " + (this.numClients - this.clients.remainingCapacity()) + " of " + this.numClients + " clients available."), (Object[])new Object[0]);
        }
        return client;
    }

    @FFDCIgnore(value={InterruptedException.class})
    public void checkinClient(Client client) {
        boolean done = false;
        if (this.clients.remainingCapacity() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Checking in more clients than there should be.", (Object[])new Object[0]);
            }
            return;
        }
        while (!done) {
            try {
                if (!this.clients.contains(client)) {
                    this.clients.putFirst(client);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        int clientHash = client != null ? client.hashCode() : 0;
                        Tr.event((TraceComponent)tc, (String)("post-checkin  - (" + clientHash + ") " + (this.numClients - this.clients.remainingCapacity()) + " of " + this.numClients + " clients available."), (Object[])new Object[0]);
                    }
                }
                done = true;
            }
            catch (InterruptedException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)"InterruptedException during checkin - will retry", (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={InterruptedException.class})
    public void close() {
        while (this.numClientsClosed.get() < this.numClients) {
            try {
                Client client = this.clients.takeFirst();
                try {
                    client.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.collector.ClientPool", (String)"136", (Object)this, (Object[])new Object[0]);
                }
                this.numClientsClosed.incrementAndGet();
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("pool closed   - " + this.numClientsClosed + " of " + this.numClients + " clients closed"), (Object[])new Object[0]);
            }
            catch (InterruptedException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)"InterruptedException during close - will retry", (Object[])new Object[0]);
            }
        }
    }

    public abstract Client createClient(String var1, SSLSupport var2) throws SSLException;
}

