/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UtilImpl_ContainerUtils {
    static final long serialVersionUID = 182905918257438947L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ArtifactContainer getRootOfRoots(ArtifactContainer container) {
        ArtifactEntry entry = container.getEntryInEnclosingContainer();
        while (entry != null) {
            container = container.getRoot();
            entry = container.getEntryInEnclosingContainer();
        }
        return container;
    }

    public static String getFullInternalPath(ArtifactContainer container) {
        ArtifactEntry entry = container.getEntryInEnclosingContainer();
        if (entry == null) {
            return "/";
        }
        StringBuilder pathBuilder = new StringBuilder();
        while (entry != null) {
            pathBuilder.insert(0, entry.getPath());
            container = entry.getRoot();
            entry = container.getEntryInEnclosingContainer();
        }
        return pathBuilder.toString();
    }

    public static String getExternalPath(ArtifactContainer container) {
        Collection urls = container.getURLs();
        if (urls.isEmpty()) {
            return null;
        }
        URL firstUrl = null;
        Iterator iterator = urls.iterator();
        if (iterator.hasNext()) {
            URL url;
            firstUrl = url = (URL)iterator.next();
        }
        String firstPath = firstUrl.getPath();
        File firstFile = new File(firstPath);
        return UtilImpl_FileUtils.getCanonicalPath(firstFile);
    }

    public static String getFullExternalPath(ArtifactContainer container) {
        String internalPath;
        ArtifactEntry entry = container.getEntryInEnclosingContainer();
        if (entry == null) {
            internalPath = null;
        } else {
            StringBuilder pathBuilder = new StringBuilder();
            while (entry != null) {
                pathBuilder.insert(0, entry.getPath());
                container = entry.getRoot();
                entry = container.getEntryInEnclosingContainer();
            }
            internalPath = pathBuilder.toString();
        }
        String externalPath = UtilImpl_ContainerUtils.getExternalPath(container);
        if (internalPath == null) {
            return externalPath;
        }
        return externalPath + internalPath;
    }

    public static Entry getEntryInEnclosingContainer(Container container) {
        try {
            return (Entry)container.adapt(Entry.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.annocache.util.internal.UtilImpl_ContainerUtils", (String)"144", null, (Object[])new Object[]{container});
            return null;
        }
    }

    public static Container getRootOfRoots(Container container) {
        Entry entry = UtilImpl_ContainerUtils.getEntryInEnclosingContainer(container);
        while (entry != null) {
            container = container.getRoot();
            entry = UtilImpl_ContainerUtils.getEntryInEnclosingContainer(container);
        }
        return container;
    }

    public static String getFullInternalPath(Container container) {
        Entry entry = UtilImpl_ContainerUtils.getEntryInEnclosingContainer(container);
        if (entry == null) {
            return "/";
        }
        StringBuilder pathBuilder = new StringBuilder();
        while (entry != null) {
            pathBuilder.insert(0, entry.getPath());
            container = entry.getRoot();
            entry = UtilImpl_ContainerUtils.getEntryInEnclosingContainer(container);
        }
        return pathBuilder.toString();
    }

    public static String getExternalPath(Container container) {
        Collection urls = container.getURLs();
        if (urls.isEmpty()) {
            return null;
        }
        URL firstUrl = null;
        Iterator iterator = urls.iterator();
        if (iterator.hasNext()) {
            URL url;
            firstUrl = url = (URL)iterator.next();
        }
        String firstPath = firstUrl.getPath();
        File firstFile = new File(firstPath);
        return UtilImpl_FileUtils.getCanonicalPath(firstFile);
    }

    public static String getFullExternalPath(Container container) {
        String internalPath;
        Entry entry = UtilImpl_ContainerUtils.getEntryInEnclosingContainer(container);
        if (entry == null) {
            internalPath = null;
        } else {
            StringBuilder pathBuilder = new StringBuilder();
            while (entry != null) {
                pathBuilder.insert(0, entry.getPath());
                container = entry.getRoot();
                entry = UtilImpl_ContainerUtils.getEntryInEnclosingContainer(container);
            }
            internalPath = pathBuilder.toString();
        }
        String externalPath = UtilImpl_ContainerUtils.getExternalPath(container);
        if (internalPath == null) {
            return externalPath;
        }
        return externalPath + internalPath;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_ContainerUtils", UtilImpl_ContainerUtils.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    }
}

